/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.api.persistence.enhancer.generator;

import com.sun.jdo.api.persistence.enhancer.LogHelperEnhancer;
import com.sun.jdo.api.persistence.enhancer.generator.ImplHelper;
import com.sun.jdo.api.persistence.enhancer.meta.ExtendedJDOMetaData;
import com.sun.jdo.api.persistence.enhancer.meta.JDOMetaDataPropertyImpl;
import com.sun.jdo.api.persistence.enhancer.util.Assertion;
import com.sun.jdo.spi.persistence.utility.generator.JavaClassWriter;
import com.sun.jdo.spi.persistence.utility.generator.JavaFileWriter;
import com.sun.jdo.spi.persistence.utility.generator.io.IOJavaClassWriter;
import com.sun.jdo.spi.persistence.utility.generator.io.IOJavaFileWriter;
import com.sun.jdo.spi.persistence.utility.logging.Logger;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Properties;
import java.util.ResourceBundle;
import org.glassfish.persistence.common.I18NHelper;

public final class Main
extends Assertion {
    private static final Logger logger = LogHelperEnhancer.getLogger();
    private static final String dotLine = "----------------------------------------------------------------------";
    private final PrintWriter out = new PrintWriter(System.out, true);
    private final PrintWriter err = new PrintWriter(System.err, true);
    private final CmdLineOptions opts = new CmdLineOptions();
    private JavaFileWriter fWriter = null;
    private JavaClassWriter writer = null;
    private ExtendedJDOMetaData meta = null;
    private File destinationDir = null;
    private static final ResourceBundle messages = I18NHelper.loadBundle("com.sun.jdo.api.persistence.enhancer.Bundle");

    public Main() {
    }

    public Main(ExtendedJDOMetaData meta, File destinationDir) throws IOException {
        this.meta = meta;
        this.destinationDir = destinationDir;
        this.createDestinationDir();
    }

    public static final void main(String[] argv) {
        Main gen = new Main();
        try {
            gen.opts.processArgs(argv);
            gen.init();
            gen.generate();
        }
        catch (Exception ex) {
            gen.printError(null, ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init() throws FileNotFoundException, IOException {
        Main.affirm(this.opts.jdoPropertiesFileName != null);
        FileInputStream finput = null;
        try {
            File f = new File(this.opts.jdoPropertiesFileName);
            finput = new FileInputStream(f);
            Properties props = new Properties();
            props.load(finput);
            this.meta = new JDOMetaDataPropertyImpl(props, this.out);
        }
        finally {
            if (finput != null) {
                try {
                    finput.close();
                }
                catch (Exception ex) {
                    this.printError(ex.getMessage(), ex);
                }
            }
        }
        Main.affirm(this.opts.destinationDirectory != null);
        this.destinationDir = new File(this.opts.destinationDirectory);
        this.createDestinationDir();
    }

    private void createDestinationDir() throws IOException {
        if (!this.destinationDir.exists() && !this.destinationDir.mkdirs()) {
            throw new IOException(I18NHelper.getMessage(messages, "EXC_DestDirCreateFailure", this.destinationDir));
        }
    }

    private void generate() throws IOException {
        String[] classes = this.meta.getKnownClasses();
        for (int i = 0; i < classes.length; ++i) {
            String className = classes[i];
            this.generate(className);
        }
    }

    public File generate(String className) throws IOException {
        Main.affirm(className != null);
        this.printMessage("generating '" + className + "'...");
        String filePath = className.replace('/', File.separatorChar);
        String classFileName = filePath + ".java";
        File file = new File(this.destinationDir, classFileName);
        this.fWriter = new IOJavaFileWriter(file);
        this.writer = new IOJavaClassWriter();
        this.generateClass(className);
        this.fWriter.addClass(this.writer);
        this.printMessage("DONE generating '" + className + "'...");
        this.fWriter.save();
        return file;
    }

    private void generateClass(String className) throws IOException {
        Main.affirm(className != null);
        String packageName = ImplHelper.getPackageName(className);
        this.fWriter.setPackage(packageName, null);
        String oidClassName = this.meta.getKeyClass(className);
        if (oidClassName == null) {
            this.writeClassHeader(className);
        } else {
            String oidPackageName = ImplHelper.getPackageName(oidClassName);
            Main.affirm(packageName.equals(oidPackageName), "PC class and key class must be in same package.");
            boolean enclosedOid = oidClassName.startsWith(className + "$");
            if (enclosedOid) {
                this.writeClassHeader(className);
                this.writeOidClass(className, ImplHelper.getClassName(oidClassName), enclosedOid);
            } else {
                this.writeOidClass(className, ImplHelper.getClassName(oidClassName), enclosedOid);
                this.writeClassHeader(className);
            }
        }
        this.writeClassMembers(className);
        boolean isPC = this.meta.isPersistenceCapableClass(className);
        if (isPC) {
            boolean isPCRoot = this.meta.isPersistenceCapableRootClass(className);
            if (isPCRoot) {
                this.writePCRootMembers(className);
            }
            this.writePCMembers(className);
        }
    }

    private void writeClassHeader(String className) throws IOException {
        String[] stringArray;
        boolean isPCRoot = this.meta.isPersistenceCapableRootClass(className);
        String superclass = ImplHelper.normalizeClassName(this.meta.getSuperClass(className));
        String[] comments = null;
        if (isPCRoot) {
            String[] stringArray2 = new String[2];
            stringArray2[0] = "com.sun.jdo.spi.persistence.support.sqlstore.PersistenceCapable";
            stringArray = stringArray2;
            stringArray2[1] = "Cloneable";
        } else {
            stringArray = null;
        }
        String[] interfaces = stringArray;
        this.writer.setClassDeclaration(this.meta.getClassModifiers(className), ImplHelper.getClassName(className), comments);
        this.writer.setSuperclass(superclass);
        if (interfaces != null) {
            for (int i = 0; i < interfaces.length; ++i) {
                this.writer.addInterface(interfaces[i]);
            }
        }
    }

    private void writeClassMembers(String className) throws IOException {
        String fieldName;
        int i;
        String[] comments = new String[]{dotLine, "Class Members:", dotLine};
        this.writer.addConstructor(ImplHelper.getClassName(className), 1, null, null, null, ImplHelper.getDefaultConstructorImpl(), comments);
        String[] fieldNames = this.meta.getKnownFields(className);
        int n = fieldNames != null ? fieldNames.length : 0;
        ArrayList<String> list = new ArrayList<String>();
        for (i = 0; i < n; ++i) {
            fieldName = fieldNames[i];
            int access = this.meta.getFieldModifiers(className, fieldName);
            if ((access & 8) != 0) continue;
            list.add(fieldName);
        }
        this.writer.addMethod("clone", 1, "Object", null, null, new String[]{"java.lang.CloneNotSupportedException"}, ImplHelper.getCloneImpl(className), ImplHelper.COMMENT_NOT_ENHANCER_ADDED);
        for (i = 0; i < n; ++i) {
            fieldName = fieldNames[i];
            this.writeFieldMember(className, fieldName);
        }
    }

    private void writeFieldMember(String className, String fieldName) throws IOException {
        String fieldType = this.meta.getFieldType(className, fieldName);
        String normalizedFieldType = ImplHelper.normalizeClassName(fieldType);
        int fieldNumber = this.meta.getFieldNo(className, fieldName);
        int flags = this.meta.getFieldFlags(className, fieldName);
        int access = this.meta.getFieldModifiers(className, fieldName);
        this.writer.addField(fieldName, access, normalizedFieldType, null, null);
        if ((access & 8) != 0) {
            return;
        }
        Main.affirm((flags & 1) == 0 | (flags & 2) == 0);
        String[] impl = (flags & 1) != 0 ? ImplHelper.getFieldCheckReadImpl(fieldName, fieldType, fieldNumber) : ((flags & 2) != 0 ? ImplHelper.getFieldMediateReadImpl(fieldName, fieldType, fieldNumber) : ImplHelper.getFieldDirectReadImpl(fieldName, fieldType, fieldNumber));
        this.writer.addMethod(Main.createMethodName("get", fieldName), 1, normalizedFieldType, null, null, null, impl, ImplHelper.COMMENT_ENHANCER_ADDED);
        Main.affirm((flags & 4) == 0 | (flags & 8) == 0);
        impl = (flags & 4) != 0 ? ImplHelper.getFieldCheckWriteImpl(fieldName, fieldType, fieldNumber, fieldName) : ((flags & 8) != 0 && !this.meta.isKnownNonManagedField(className, fieldName, null) ? ImplHelper.getFieldMediateWriteImpl(fieldName, fieldType, fieldNumber, fieldName) : ImplHelper.getFieldDirectWriteImpl(fieldName, fieldType, fieldNumber, fieldName));
        this.writer.addMethod(Main.createMethodName("set", fieldName), 1, "void", new String[]{fieldName}, new String[]{normalizedFieldType}, null, impl, ImplHelper.COMMENT_ENHANCER_ADDED);
    }

    private void writePCRootMembers(String className) throws IOException {
        String[] comments = new String[]{dotLine, "Augmentation for Persistence-Capable Root Classes (added by enhancer):", dotLine};
        this.writer.addConstructor(ImplHelper.getClassName(className), 1, new String[]{"jdoStateManager"}, new String[]{"com.sun.jdo.spi.persistence.support.sqlstore.StateManager"}, null, ImplHelper.getJDOConstructorSMImpl("jdoStateManager"), comments);
        this.writer.addField("jdoStateManager", 129, "com.sun.jdo.spi.persistence.support.sqlstore.StateManager", "null", ImplHelper.COMMENT_ENHANCER_ADDED);
        this.writer.addField("jdoFlags", 129, "byte", "0", ImplHelper.COMMENT_ENHANCER_ADDED);
        this.writer.addMethod("jdoGetStateManager", 17, "com.sun.jdo.spi.persistence.support.sqlstore.StateManager", null, null, null, new String[]{"return jdoStateManager;"}, ImplHelper.COMMENT_ENHANCER_ADDED);
        this.writer.addMethod("jdoSetStateManager", 17, "void", new String[]{"jdoStateManager"}, new String[]{"com.sun.jdo.spi.persistence.support.sqlstore.StateManager"}, null, new String[]{"this.jdoStateManager = jdoStateManager;"}, ImplHelper.COMMENT_ENHANCER_ADDED);
        this.writer.addMethod("jdoGetFlags", 17, "byte", null, null, null, new String[]{"return jdoFlags;"}, ImplHelper.COMMENT_ENHANCER_ADDED);
        this.writer.addMethod("jdoSetFlags", 17, "void", new String[]{"jdoFlags"}, new String[]{"byte"}, null, new String[]{"this.jdoFlags = jdoFlags;"}, ImplHelper.COMMENT_ENHANCER_ADDED);
        this.writer.addMethod("jdoGetPersistenceManager", 17, "com.sun.jdo.api.persistence.support.PersistenceManager", null, null, null, ImplHelper.getJDOStateManagerObjectDelegationImpl("getPersistenceManager()"), ImplHelper.COMMENT_ENHANCER_ADDED);
        this.writer.addMethod("jdoGetObjectId", 17, Object.class.getName(), null, null, null, ImplHelper.getJDOStateManagerObjectDelegationImpl("getObjectId()"), ImplHelper.COMMENT_ENHANCER_ADDED);
        this.writer.addMethod("jdoIsPersistent", 17, "boolean", null, null, null, ImplHelper.getJDOStateManagerBooleanDelegationImpl("isPersistent()"), ImplHelper.COMMENT_ENHANCER_ADDED);
        this.writer.addMethod("jdoIsTransactional", 17, "boolean", null, null, null, ImplHelper.getJDOStateManagerBooleanDelegationImpl("isTransactional()"), ImplHelper.COMMENT_ENHANCER_ADDED);
        this.writer.addMethod("jdoIsNew", 17, "boolean", null, null, null, ImplHelper.getJDOStateManagerBooleanDelegationImpl("isNew()"), ImplHelper.COMMENT_ENHANCER_ADDED);
        this.writer.addMethod("jdoIsDeleted", 17, "boolean", null, null, null, ImplHelper.getJDOStateManagerBooleanDelegationImpl("isDeleted()"), ImplHelper.COMMENT_ENHANCER_ADDED);
        this.writer.addMethod("jdoIsDirty", 17, "boolean", null, null, null, ImplHelper.getJDOStateManagerBooleanDelegationImpl("isDirty()"), ImplHelper.COMMENT_ENHANCER_ADDED);
        this.writer.addMethod("jdoMakeDirty", 17, "void", new String[]{"fieldName"}, new String[]{String.class.getName()}, null, ImplHelper.getJDOStateManagerVoidDelegationImpl("makeDirty(fieldName)"), ImplHelper.COMMENT_ENHANCER_ADDED);
    }

    private void writePCMembers(String className) throws IOException {
        String[] comments = new String[]{dotLine, "Augmentation for Persistence-Capable Classes (added by enhancer):", dotLine};
        String[] managedFieldNames = this.meta.getManagedFields(className);
        String[] managedFieldTypes = this.meta.getFieldType(className, managedFieldNames);
        boolean isPCRoot = this.meta.isPersistenceCapableRootClass(className);
        this.writer.addMethod("jdoGetField", 1, "Object", new String[]{"fieldNumber"}, new String[]{"int"}, null, ImplHelper.getJDOGetFieldImpl("fieldNumber", managedFieldNames, managedFieldTypes), comments);
        this.writer.addMethod("jdoSetField", 1, "void", new String[]{"fieldNumber", "obj"}, new String[]{"int", "Object"}, null, ImplHelper.getJDOSetFieldImpl("fieldNumber", "obj", managedFieldNames, managedFieldTypes), ImplHelper.COMMENT_ENHANCER_ADDED);
        this.writer.addMethod("jdoClear", 1, "void", null, null, null, ImplHelper.getJDOClearImpl(className, this.meta, managedFieldNames, managedFieldTypes), ImplHelper.COMMENT_ENHANCER_ADDED);
        this.writer.addMethod("jdoNewInstance", 1, "Object", new String[]{"sm"}, new String[]{"com.sun.jdo.spi.persistence.support.sqlstore.StateManager"}, null, ImplHelper.getJDONewInstanceImpl(className, "sm"), ImplHelper.COMMENT_ENHANCER_ADDED);
    }

    private void writeOidClass(String className, String oidClassName, boolean enclosedOid) throws IOException {
        String[] comments = new String[]{dotLine, "Key Class:", dotLine};
        String superOidClassName = ImplHelper.normalizeClassName(this.meta.getSuperKeyClass(className));
        IOJavaClassWriter oidWriter = new IOJavaClassWriter();
        oidWriter.setClassDeclaration(enclosedOid ? 9 : 0, oidClassName, ImplHelper.COMMENT_NOT_ENHANCER_ADDED);
        oidWriter.setSuperclass(superOidClassName);
        oidWriter.addInterface(Serializable.class.getName());
        boolean isPCRoot = this.meta.isPersistenceCapableRootClass(className);
        String[] pknames = this.meta.getKeyFields(className);
        String[] pktypes = this.meta.getFieldType(className, pknames);
        for (int i = 0; i < pknames.length; ++i) {
            oidWriter.addField(pknames[i], 1, ImplHelper.normalizeClassName(pktypes[i]), null, null);
        }
        oidWriter.addConstructor(oidClassName, 1, null, null, null, ImplHelper.getDefaultConstructorImpl(), ImplHelper.COMMENT_NOT_ENHANCER_ADDED);
        oidWriter.addMethod("hashCode", 1, "int", null, null, null, ImplHelper.getOidHashCodeImpl(pknames, pktypes, isPCRoot), ImplHelper.COMMENT_NOT_ENHANCER_ADDED);
        oidWriter.addMethod("equals", 1, "boolean", new String[]{"pk"}, new String[]{Object.class.getName()}, null, ImplHelper.getOidEqualsImpl(oidClassName, pknames, pktypes, "pk", isPCRoot), ImplHelper.COMMENT_NOT_ENHANCER_ADDED);
        if (enclosedOid) {
            this.writer.addClass(oidWriter);
        } else {
            this.fWriter.addClass(oidWriter);
        }
    }

    private static String createMethodName(String prefix, String fieldName) {
        return prefix + Character.toUpperCase(fieldName.charAt(0)) + fieldName.substring(1);
    }

    private void printMessage(String msg) {
        logger.finest("TP PCClassGen: " + msg);
    }

    private void printError(String msg, Throwable ex) {
        if (msg != null) {
            String errmsg = msg + (String)(ex != null ? ": " + ex.getMessage() : "");
            logger.log(1000, "CME.generic_exception", errmsg);
        }
        if (ex != null) {
            logger.log(1000, "CME.generic_exception_stack", ex);
        }
    }

    private class CmdLineOptions {
        String destinationDirectory = null;
        String jdoXMLModelFileName = null;
        String jdoPropertiesFileName = null;
        boolean verbose = false;

        private CmdLineOptions() {
        }

        public void usage() {
            Main.this.err.println("Usage: Main <options> <arguments>...");
            Main.this.err.println("Options:");
            Main.this.err.println("  -v, --verbose            print verbose output");
            Main.this.err.println("  -d, --dest <dir>         destination directory for output files");
            Main.this.err.println("  -p, --properties <file>  use property file for meta data");
            Main.this.err.println();
            Main.this.err.println("Arguments:");
            Main.this.err.println();
            Main.this.err.println("Returns a non-zero value in case of errors.");
            System.exit(1);
        }

        protected int processArgs(String[] argv) {
            for (int i = 0; i < argv.length; ++i) {
                String arg = argv[i];
                if (arg.equals("-v") || arg.equals("--verbose")) {
                    this.verbose = true;
                    continue;
                }
                if (arg.equals("-d") || arg.equals("--dest")) {
                    if (argv.length - i < 2) {
                        Main.this.printError("Missing argument to the -d/-dest option", null);
                        this.usage();
                    }
                    this.destinationDirectory = argv[++i];
                    continue;
                }
                if (arg.equals("-p") || arg.equals("--properties")) {
                    if (argv.length - i < 2) {
                        Main.this.printError("Missing argument to the -p/--properties option", null);
                        this.usage();
                    }
                    this.jdoPropertiesFileName = argv[++i];
                    continue;
                }
                if (arg.length() > 0 && arg.charAt(0) == '-') {
                    Main.this.printError("Unrecognized option:" + arg, null);
                    this.usage();
                }
                if (arg.length() != 0) continue;
                Main.this.printMessage("Ignoring empty command line argument.");
            }
            if (this.jdoPropertiesFileName == null) {
                Main.this.printError("No destination directory specified", null);
                this.usage();
            }
            if (this.destinationDirectory == null) {
                Main.this.printError("No destination directory specified", null);
                this.usage();
            }
            return 0;
        }
    }
}

