/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.connectors.jms.util;

import com.sun.appserv.connectors.internal.api.ConnectorRuntimeException;
import com.sun.enterprise.config.serverbeans.Cluster;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.config.serverbeans.SystemProperty;
import com.sun.enterprise.connectors.jms.JMSLoggerInfo;
import com.sun.enterprise.connectors.jms.config.JmsService;
import com.sun.enterprise.connectors.jms.inflow.MdbContainerProps;
import com.sun.enterprise.connectors.jms.system.MQAddressList;
import com.sun.enterprise.deployment.ConnectorConfigProperty;
import com.sun.enterprise.deployment.ConnectorDescriptor;
import com.sun.enterprise.util.zip.ZipFile;
import com.sun.enterprise.util.zip.ZipFileException;
import java.io.File;
import java.io.FileInputStream;
import java.util.List;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.ejb.config.MdbContainer;
import org.glassfish.internal.api.Globals;
import org.glassfish.internal.api.RelativePathResolver;
import org.jvnet.hk2.config.types.Property;

public class JmsRaUtil {
    private static final String MQ_RAR = "imqjmsra.rar";
    private final String SYSTEM_APP_DIR = "lib" + File.separator + "install" + File.separator + "applications";
    private final String MQ_RAR_MANIFEST = "jmsra" + File.separator + "META-INF" + File.separator + "MANIFEST.MF";
    private static final String MANIFEST_TAG = "Implementation-Version";
    private static final String propName_reconnect_delay_in_seconds = "reconnect-delay-in-seconds";
    private static final String propName_reconnect_max_retries = "reconnect-max-retries";
    private static final String propName_reconnect_enabled = "reconnect-enabled";
    private static final int DEFAULT_RECONNECT_DELAY = 60;
    private static final int DEFAULT_RECONNECT_RETRIES = 60;
    private static final String propName_cmt_max_runtime_exceptions = "cmt-max-runtime-exceptions";
    private static final int DEFAULT_CMT_MAX_RUNTIME_EXCEPTIONS = 1;
    private static final String ENABLE_AUTO_CLUSTERING = "com.sun.enterprise.connectors.system.enableAutoClustering";
    private int cmtMaxRuntimeExceptions = 1;
    private int reconnectDelayInSeconds = 60;
    private int reconnectMaxRetries = 60;
    private boolean reconnectEnabled = false;
    JmsService js = null;
    MQAddressList list = null;
    private static final Logger _logger = JMSLoggerInfo.getLogger();

    public JmsRaUtil() throws ConnectorRuntimeException {
        this(null);
    }

    public JmsRaUtil(JmsService js) throws ConnectorRuntimeException {
        try {
            this.js = js != null ? js : Globals.get(JmsService.class);
            this.list = new MQAddressList(this.js);
        }
        catch (Exception ce) {
            throw JmsRaUtil.handleException(ce);
        }
    }

    public void setupAddressList() throws ConnectorRuntimeException {
        try {
            this.list.setup();
        }
        catch (Exception e) {
            throw JmsRaUtil.handleException(e);
        }
    }

    public String getUrl() {
        try {
            return this.list.toString();
        }
        catch (Exception e) {
            return null;
        }
    }

    public static boolean isClustered(List clusters, String instanceName) {
        return JmsRaUtil.enableClustering() && JmsRaUtil.isServerClustered(clusters, instanceName);
    }

    public static boolean isServerClustered(List clusters, String instanceName) {
        return JmsRaUtil.getClusterForServer(clusters, instanceName) != null;
    }

    public static Cluster getClusterForServer(List clusters, String instanceName) {
        for (int i = 0; i < clusters.size(); ++i) {
            List servers = ((Cluster)clusters.get(i)).getInstances();
            for (int j = 0; j < servers.size(); ++j) {
                if (!((Server)servers.get(j)).getName().equals(instanceName)) continue;
                return (Cluster)clusters.get(i);
            }
        }
        return null;
    }

    private static boolean enableClustering() {
        try {
            String enablecluster = System.getProperty(ENABLE_AUTO_CLUSTERING);
            _logger.log(Level.FINE, "Sun MQ Auto cluster system property " + enablecluster);
            if (enablecluster != null && enablecluster.trim().equals("false")) {
                _logger.log(Level.FINE, "Disabling Sun MQ Auto Clustering");
                return false;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        _logger.log(Level.FINE, "Enabling Sun MQ Auto Clustering");
        return true;
    }

    public String getJMSServiceType() {
        return this.js.getType();
    }

    public MQAddressList getUrlList() {
        return this.list;
    }

    public boolean getReconnectEnabled() {
        return Boolean.parseBoolean(this.js.getReconnectEnabled());
    }

    public String getReconnectInterval() {
        return this.js.getReconnectIntervalInSeconds();
    }

    public String getReconnectAttempts() {
        return this.js.getReconnectAttempts();
    }

    public String getAddressListIterations() {
        return this.js.getAddresslistIterations();
    }

    public String getAddressListBehaviour() {
        return this.js.getAddresslistBehavior();
    }

    public void setMdbContainerProperties() {
        List props;
        MdbContainer mdbc;
        block18: {
            mdbc = null;
            try {
                mdbc = Globals.get(MdbContainer.class);
            }
            catch (Exception e) {
                _logger.log(Level.WARNING, "AS-JMS-CORE-00023", new Object[]{e.getMessage()});
                if (!_logger.isLoggable(Level.FINE)) break block18;
                _logger.log(Level.FINE, e.getClass().getName(), e);
            }
        }
        if (mdbc != null && (props = mdbc.getProperty()) != null) {
            for (int i = 0; i < props.size(); ++i) {
                String name;
                Property p = (Property)props.get(i);
                if (p == null || (name = p.getName()) == null) continue;
                try {
                    if (name.equals(propName_reconnect_enabled)) {
                        if (p.getValue() == null) continue;
                        this.reconnectEnabled = Boolean.valueOf(p.getValue());
                        continue;
                    }
                    if (name.equals(propName_reconnect_delay_in_seconds)) {
                        try {
                            this.reconnectDelayInSeconds = Integer.parseInt(p.getValue());
                        }
                        catch (Exception e) {
                            _logger.log(Level.WARNING, "AS-JMS-CORE-00023", new Object[]{e.getMessage()});
                        }
                        continue;
                    }
                    if (name.equals(propName_reconnect_max_retries)) {
                        try {
                            this.reconnectMaxRetries = Integer.parseInt(p.getValue());
                        }
                        catch (Exception e) {
                            _logger.log(Level.WARNING, "AS-JMS-CORE-00023", new Object[]{e.getMessage()});
                        }
                        continue;
                    }
                    if (!name.equals(propName_cmt_max_runtime_exceptions)) continue;
                    try {
                        this.cmtMaxRuntimeExceptions = Integer.parseInt(p.getValue());
                    }
                    catch (Exception e) {
                        _logger.log(Level.WARNING, "AS-JMS-CORE-00023", new Object[]{e.getMessage()});
                    }
                    continue;
                }
                catch (Exception e) {
                    _logger.log(Level.WARNING, "AS-JMS-CORE-00023", new Object[]{e.getMessage()});
                    if (!_logger.isLoggable(Level.FINE)) continue;
                    _logger.log(Level.FINE, e.getClass().getName(), e);
                }
            }
        }
        if (this.reconnectDelayInSeconds < 0) {
            this.reconnectDelayInSeconds = 60;
        }
        if (this.reconnectMaxRetries < 0) {
            this.reconnectMaxRetries = 60;
        }
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "reconnect-delay-in-seconds=" + this.reconnectDelayInSeconds + ", reconnect-max-retries=" + this.reconnectMaxRetries + ", reconnect-enabled=" + this.reconnectEnabled);
        }
        MdbContainerProps.setReconnectDelay(this.reconnectDelayInSeconds);
        MdbContainerProps.setReconnectMaxRetries(this.reconnectMaxRetries);
        MdbContainerProps.setReconnectEnabled(this.reconnectEnabled);
        MdbContainerProps.setMaxRuntimeExceptions(this.cmtMaxRuntimeExceptions);
    }

    public void configureDescriptor(ConnectorDescriptor cd) {
        Object[] envProps = cd.getConfigProperties().toArray();
        for (int i = 0; i < envProps.length; ++i) {
            String userValue;
            ConnectorConfigProperty envProp = (ConnectorConfigProperty)envProps[i];
            String name = envProp.getName();
            if (!name.equals("ConnectionURL") || (userValue = this.getUrl()) == null) continue;
            cd.removeConfigProperty(envProp);
            cd.addConfigProperty(new ConnectorConfigProperty(name, userValue, userValue, envProp.getType()));
        }
    }

    public void upgradeIfNecessary() {
        String installedMqVersion = null;
        String deployedMqVersion = null;
        try {
            installedMqVersion = this.getInstalledMqVersion();
            _logger.log(Level.FINE, "installedMQVersion :: " + installedMqVersion);
            deployedMqVersion = this.getDeployedMqVersion();
            _logger.log(Level.FINE, "deployedMQVersion :: " + deployedMqVersion);
        }
        catch (Exception e) {
            return;
        }
        String deployed_dir = System.getProperty("com.sun.aas.installRoot") + File.separator + this.SYSTEM_APP_DIR + File.separator + "jmsra";
        if (!installedMqVersion.equals(deployedMqVersion)) {
            try {
                _logger.log(Level.INFO, "AS-JMS-CORE-00024");
                ZipFile rarFile = new ZipFile(System.getProperty("com.sun.aas.imqLib") + File.separator + MQ_RAR, deployed_dir);
                rarFile.explode();
                _logger.log(Level.INFO, "AS-JMS-CORE-00025");
            }
            catch (ZipFileException ze) {
                _logger.log(Level.SEVERE, "AS-JMS-CORE-00026", new Object[]{ze.getMessage()});
            }
        }
    }

    private String getInstalledMqVersion() throws Exception {
        String ver = null;
        String installed_dir = System.getProperty("com.sun.aas.imqLib");
        String jarFile = installed_dir + File.separator + MQ_RAR;
        _logger.log(Level.FINE, "Installed MQ JAR " + jarFile);
        try (java.util.zip.ZipFile jFile = null;){
            jFile = new File(jarFile).exists() ? new JarFile(jarFile) : new JarFile(installed_dir + File.separator + ".." + File.separator + MQ_RAR);
            Manifest mf = ((JarFile)jFile).getManifest();
            String string = ver = mf.getMainAttributes().getValue(MANIFEST_TAG);
            return string;
        }
    }

    private String getDeployedMqVersion() throws Exception {
        String string;
        String ver = null;
        String deployed_dir = System.getProperty("com.sun.aas.installRoot") + File.separator + this.SYSTEM_APP_DIR;
        String manifestFile = deployed_dir + File.separator + this.MQ_RAR_MANIFEST;
        _logger.log(Level.FINE, "Deployed MQ version Manifest file" + manifestFile);
        FileInputStream fis = new FileInputStream(manifestFile);
        try {
            Manifest mf = new Manifest(fis);
            string = ver = mf.getMainAttributes().getValue(MANIFEST_TAG);
        }
        catch (Throwable throwable) {
            try {
                try {
                    fis.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                _logger.log(Level.WARNING, "AS-JMS-CORE-00027", new Object[]{e.getMessage() + ":" + manifestFile});
                throw e;
            }
        }
        fis.close();
        return string;
    }

    private static ConnectorRuntimeException handleException(Exception e) {
        ConnectorRuntimeException cre = new ConnectorRuntimeException(e.getMessage());
        cre.initCause((Throwable)e);
        return cre;
    }

    public static String getJMSPropertyValue(Server as) {
        SystemProperty sp = as.getSystemProperty("JMS_PROVIDER_PORT");
        if (sp != null) {
            return sp.getValue();
        }
        Cluster cluster = as.getCluster();
        if (cluster != null && (sp = cluster.getSystemProperty("JMS_PROVIDER_PORT")) != null) {
            return sp.getValue();
        }
        Config config = as.getConfig();
        if (config != null) {
            sp = config.getSystemProperty("JMS_PROVIDER_PORT");
        }
        if (sp != null) {
            return sp.getValue();
        }
        return null;
    }

    public static String getUnAliasedPwd(String alias) {
        try {
            String unalisedPwd = RelativePathResolver.getRealPasswordFromAlias(alias);
            if (unalisedPwd != null && "".equals(unalisedPwd)) {
                return unalisedPwd;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return alias;
    }
}

