/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jta.admin.cli;

import com.sun.enterprise.config.serverbeans.Cluster;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.transaction.api.JavaEETransactionManager;
import com.sun.enterprise.util.i18n.StringManager;
import com.sun.logging.LogDomains;
import fish.payara.enterprise.config.serverbeans.DeploymentGroup;
import jakarta.inject.Inject;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.FailurePolicy;
import org.glassfish.api.admin.RestEndpoint;
import org.glassfish.api.admin.RestEndpoints;
import org.glassfish.api.admin.RestParam;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.hk2.api.PerLookup;
import org.jvnet.hk2.annotations.Service;

@Service(name="freeze-transaction-service")
@TargetType(value={CommandTarget.DAS, CommandTarget.STANDALONE_INSTANCE, CommandTarget.CLUSTER, CommandTarget.CLUSTERED_INSTANCE, CommandTarget.CONFIG, CommandTarget.DEPLOYMENT_GROUP})
@ExecuteOn(value={RuntimeType.INSTANCE}, ifNeverStarted=FailurePolicy.Error)
@PerLookup
@I18n(value="freeze.transaction.service")
@RestEndpoints(value={@RestEndpoint(configBean=Cluster.class, opType=RestEndpoint.OpType.POST, path="freeze-transaction-service", description="Freeze Transaction Service", params={@RestParam(name="target", value="$parent")}), @RestEndpoint(configBean=Server.class, opType=RestEndpoint.OpType.POST, path="freeze-transaction-service", description="Freeze Transaction Service", params={@RestParam(name="target", value="$parent")}), @RestEndpoint(configBean=Domain.class, opType=RestEndpoint.OpType.POST, path="freeze-transaction-service", description="Freeze Transaction Service"), @RestEndpoint(configBean=DeploymentGroup.class, opType=RestEndpoint.OpType.POST, path="freeze-transaction-service", description="Freeze Transaction Service")})
public class FreezeTransactionService
implements AdminCommand {
    private static StringManager localStrings = StringManager.getManager(FreezeTransactionService.class);
    private static final Logger logger = LogDomains.getLogger(FreezeTransactionService.class, (String)"javax.enterprise.resource.jta", (boolean)false);
    @Param(optional=true)
    String target = "server";
    @Inject
    JavaEETransactionManager transactionMgr;

    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        try {
            if (this.transactionMgr.isFrozen()) {
                if (logger.isLoggable(Level.INFO)) {
                    logger.info("Transaction is already frozen.");
                }
                return;
            }
            this.transactionMgr.freeze();
            report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
        }
        catch (Exception e) {
            report.setMessage(localStrings.getString("freeze.transaction.service.failed"));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setFailureCause((Throwable)e);
        }
    }
}

