/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.microprofile.metrics.cdi.extension;

import fish.payara.microprofile.metrics.cdi.AnnotationReader;
import fish.payara.microprofile.metrics.cdi.MetricsAnnotationBinding;
import fish.payara.microprofile.metrics.cdi.interceptor.CountedInterceptor;
import fish.payara.microprofile.metrics.cdi.interceptor.MetricsInterceptor;
import fish.payara.microprofile.metrics.cdi.interceptor.TimedInterceptor;
import fish.payara.microprofile.metrics.cdi.producer.MetricProducer;
import fish.payara.microprofile.metrics.cdi.producer.MetricRegistryProducer;
import jakarta.enterprise.event.Observes;
import jakarta.enterprise.inject.spi.AfterBeanDiscovery;
import jakarta.enterprise.inject.spi.AnnotatedCallable;
import jakarta.enterprise.inject.spi.AnnotatedType;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.enterprise.inject.spi.BeforeBeanDiscovery;
import jakarta.enterprise.inject.spi.Extension;
import jakarta.enterprise.inject.spi.ProcessAnnotatedType;
import jakarta.enterprise.inject.spi.WithAnnotations;
import jakarta.enterprise.util.AnnotationLiteral;
import jakarta.enterprise.util.Nonbinding;
import jakarta.interceptor.Interceptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Member;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.microprofile.metrics.Metadata;
import org.eclipse.microprofile.metrics.annotation.Counted;
import org.eclipse.microprofile.metrics.annotation.Gauge;
import org.eclipse.microprofile.metrics.annotation.Timed;

public class MetricCDIExtension<E extends Member & AnnotatedElement>
implements Extension {
    private static final AnnotationLiteral<Nonbinding> NON_BINDING = new AnnotationLiteral<Nonbinding>(){};
    private static final AnnotationLiteral<MetricsAnnotationBinding> METRICS_ANNOTATION_BINDING = new AnnotationLiteral<MetricsAnnotationBinding>(){};
    private final Map<String, E> annotatedElements = new HashMap<String, E>();
    private final Map<String, Metadata> metadataMap = new HashMap<String, Metadata>();
    private final List<String> validationMessages = new ArrayList<String>();

    void beforeBeanDiscovery(@Observes BeforeBeanDiscovery beforeBeanDiscovery, BeanManager manager) {
        MetricCDIExtension.addNonbindingAnnotation(Counted.class, beforeBeanDiscovery);
        MetricCDIExtension.addNonbindingAnnotation(Timed.class, beforeBeanDiscovery);
        MetricCDIExtension.addNonbindingAnnotation(Gauge.class, beforeBeanDiscovery);
        MetricCDIExtension.addAnnotatedType(CountedInterceptor.class, manager, beforeBeanDiscovery);
        MetricCDIExtension.addAnnotatedType(TimedInterceptor.class, manager, beforeBeanDiscovery);
        MetricCDIExtension.addAnnotatedType(MetricsInterceptor.class, manager, beforeBeanDiscovery);
        MetricCDIExtension.addAnnotatedType(MetricProducer.class, manager, beforeBeanDiscovery);
        MetricCDIExtension.addAnnotatedType(MetricRegistryProducer.class, manager, beforeBeanDiscovery);
    }

    <T> void metricsAnnotations(@Observes @WithAnnotations(value={Counted.class, Gauge.class, Timed.class}) ProcessAnnotatedType<T> processAnnotatedType) {
        processAnnotatedType.configureAnnotatedType().add(METRICS_ANNOTATION_BINDING);
    }

    <T> void validateMetrics(@Observes @WithAnnotations(value={Counted.class, Gauge.class, Timed.class}) ProcessAnnotatedType<T> processAnnotatedType) {
        AnnotatedType annotatedType = processAnnotatedType.getAnnotatedType();
        ArrayList annotatedCallables = new ArrayList(annotatedType.getConstructors());
        annotatedCallables.addAll(annotatedType.getMethods());
        Class bean = annotatedType.getJavaClass();
        for (AnnotatedCallable annotatedElement : annotatedCallables) {
            if (bean.isAnnotationPresent(Interceptor.class)) continue;
            Member element = annotatedElement.getJavaMember();
            this.validateAnnotated(element, bean);
        }
    }

    private void validateAnnotated(E element, Class<?> bean) {
        for (AnnotationReader<?> reader : AnnotationReader.readers()) {
            this.validateAnnotated(element, bean, reader);
        }
    }

    private <T extends Annotation> void validateAnnotated(E element, Class<?> bean, AnnotationReader<T> reader) {
        if (!reader.isPresent(bean, element)) {
            return;
        }
        Metadata metadata = reader.metadata(bean, element);
        String name = metadata.getName();
        this.annotatedElements.putIfAbsent(name, element);
        this.metadataMap.putIfAbsent(name, metadata);
    }

    void validationError(@Observes AfterBeanDiscovery afterBeanDiscovery) {
        this.validationMessages.forEach(message -> afterBeanDiscovery.addDefinitionError((Throwable)new IllegalStateException((String)message)));
        this.annotatedElements.clear();
        this.metadataMap.clear();
        this.validationMessages.clear();
    }

    private static <T extends Annotation> void addNonbindingAnnotation(Class<T> annotation, BeforeBeanDiscovery beforeBeanDiscovery) {
        beforeBeanDiscovery.configureInterceptorBinding(annotation).filterMethods(method -> !method.isAnnotationPresent(Nonbinding.class)).forEach(method -> method.add(NON_BINDING));
    }

    private static <T> void addAnnotatedType(Class<T> type, BeanManager manager, BeforeBeanDiscovery beforeBeanDiscovery) {
        beforeBeanDiscovery.addAnnotatedType(manager.createAnnotatedType(type), type.getName());
    }
}

