/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.microprofile.metrics.cdi.interceptor;

import fish.payara.microprofile.metrics.MetricsService;
import fish.payara.microprofile.metrics.cdi.AnnotationReader;
import fish.payara.microprofile.metrics.cdi.interceptor.ThreeFunctionResolver;
import jakarta.enterprise.inject.Intercepted;
import jakarta.enterprise.inject.spi.Bean;
import jakarta.inject.Inject;
import jakarta.interceptor.AroundConstruct;
import jakarta.interceptor.AroundInvoke;
import jakarta.interceptor.AroundTimeout;
import jakarta.interceptor.InvocationContext;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Member;
import org.eclipse.microprofile.metrics.Metric;
import org.eclipse.microprofile.metrics.MetricID;
import org.eclipse.microprofile.metrics.annotation.Counted;
import org.eclipse.microprofile.metrics.annotation.Timed;
import org.glassfish.internal.api.Globals;

abstract class AbstractInterceptor {
    @Inject
    @Intercepted
    protected Bean<?> bean;
    private MetricsService metricsService;
    private MetricsService.MetricsContext metricsContext;

    AbstractInterceptor() {
    }

    protected static <E extends Member & AnnotatedElement, M extends Metric> M apply(E element, Class<?> bean, AnnotationReader<?> reader, Class<M> metricType, ThreeFunctionResolver<MetricID, Class<M>, String, M> loader) {
        Metric metric;
        MetricID metricID = reader.metricID(bean, element);
        Timed timedAnnotation = ((AnnotatedElement)element).getAnnotation(Timed.class);
        Counted countedAnnotation = ((AnnotatedElement)element).getAnnotation(Counted.class);
        String scope = null;
        if (timedAnnotation != null) {
            scope = timedAnnotation.scope();
        }
        if (countedAnnotation != null) {
            scope = countedAnnotation.scope();
        }
        if ((metric = (Metric)loader.apply(metricID, metricType, scope)) == null) {
            throw new IllegalStateException("No " + metricType.getSimpleName() + " with ID [" + metricID + "] found in application registry");
        }
        return (M)metric;
    }

    public <T extends Metric> T getMetric(MetricID metricID, Class<T> metricType, String scope) {
        this.initService();
        if (scope != null) {
            return this.metricsContext.getOrCreateRegistry(scope).getMetric(metricID, metricType);
        }
        return this.metricsContext.getApplicationRegistry().getMetric(metricID, metricType);
    }

    @AroundConstruct
    private Object constructorInvocation(InvocationContext context) throws Exception {
        return this.preInterceptor(context, context.getConstructor());
    }

    @AroundInvoke
    private Object methodInvocation(InvocationContext context) throws Exception {
        return this.preInterceptor(context, context.getMethod());
    }

    @AroundTimeout
    private Object timeoutInvocation(InvocationContext context) throws Exception {
        return this.preInterceptor(context, context.getMethod());
    }

    private <E extends Member & AnnotatedElement> Object preInterceptor(InvocationContext context, E element) throws Exception {
        this.initService();
        if (this.metricsService.isEnabled()) {
            return this.applyInterceptor(context, element);
        }
        return context.proceed();
    }

    private void initService() {
        if (this.metricsService == null) {
            this.metricsService = (MetricsService)Globals.getDefaultBaseServiceLocator().getService(MetricsService.class, new Annotation[0]);
            if (this.metricsService.isEnabled()) {
                this.metricsContext = this.metricsService.getContext(true);
            }
        }
    }

    protected abstract <E extends Member & AnnotatedElement> Object applyInterceptor(InvocationContext var1, E var2) throws Exception;
}

