/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.microprofile.metrics.cdi.interceptor;

import fish.payara.microprofile.metrics.MetricsService;
import fish.payara.microprofile.metrics.cdi.AnnotationReader;
import fish.payara.microprofile.metrics.cdi.MetricsAnnotationBinding;
import fish.payara.microprofile.metrics.impl.GaugeImpl;
import jakarta.annotation.Priority;
import jakarta.enterprise.inject.Intercepted;
import jakarta.enterprise.inject.spi.Bean;
import jakarta.inject.Inject;
import jakarta.interceptor.AroundConstruct;
import jakarta.interceptor.Interceptor;
import jakarta.interceptor.InvocationContext;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Set;
import java.util.function.BiConsumer;
import org.eclipse.microprofile.metrics.Metadata;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.eclipse.microprofile.metrics.Tag;
import org.eclipse.microprofile.metrics.annotation.Counted;
import org.eclipse.microprofile.metrics.annotation.Gauge;
import org.eclipse.microprofile.metrics.annotation.Timed;
import org.glassfish.internal.api.Globals;

@Interceptor
@MetricsAnnotationBinding
@Priority(value=1000)
public class MetricsInterceptor {
    private MetricRegistry registry;
    private Bean<?> bean;

    @Inject
    public MetricsInterceptor(MetricRegistry registry, @Intercepted Bean<?> bean) {
        this.registry = registry;
        this.bean = bean;
    }

    @AroundConstruct
    private Object constructorInvocation(InvocationContext context) throws Exception {
        Object target;
        MetricsService metricsService = (MetricsService)Globals.getDefaultBaseServiceLocator().getService(MetricsService.class, new Annotation[0]);
        if (metricsService.isEnabled()) {
            Class beanClass = this.bean.getBeanClass();
            this.registerMetrics(beanClass, context.getConstructor(), context.getTarget(), metricsService);
            this.registerFromStereotypes(this.bean.getStereotypes(), beanClass, context.getConstructor(), context.getTarget(), metricsService);
            this.registerFromParentType(beanClass, beanClass.getSuperclass(), context.getConstructor(), context.getTarget(), metricsService);
            target = context.proceed();
            Class type = beanClass;
            do {
                for (Method method : type.getDeclaredMethods()) {
                    if (method.isSynthetic()) continue;
                    this.registerMetrics(beanClass, method, context.getTarget(), metricsService);
                    this.registerFromStereotypes(this.bean.getStereotypes(), beanClass, method, context.getTarget(), metricsService);
                    this.registerFromParentType(beanClass, beanClass.getSuperclass(), method, context.getTarget(), metricsService);
                }
            } while (!Object.class.equals(type = type.getSuperclass()));
        } else {
            target = context.proceed();
        }
        return target;
    }

    private <E extends Member & AnnotatedElement> void registerFromParentType(Class<?> bean, Class<?> superClassBean, E element, Object target, MetricsService metricsService) {
        for (Annotation annotation : superClassBean.getAnnotations()) {
            if (annotation.annotationType().isAssignableFrom(Timed.class)) {
                this.registerTimedMetric((Timed)annotation, bean, element, metricsService);
                for (Method method : superClassBean.getDeclaredMethods()) {
                    if (method.isSynthetic() || Modifier.isPrivate(method.getModifiers())) continue;
                    this.registerTimedMetric((Timed)annotation, bean, element, metricsService);
                }
            }
            if (annotation.annotationType().isAssignableFrom(Counted.class)) {
                this.registerCountedMetric((Counted)annotation, bean, element, metricsService);
                for (Method method : superClassBean.getDeclaredMethods()) {
                    if (method.isSynthetic() || Modifier.isPrivate(method.getModifiers())) continue;
                    this.registerCountedMetric((Counted)annotation, bean, element, metricsService);
                }
            }
            if (!annotation.annotationType().isAssignableFrom(Gauge.class)) continue;
            this.registerGaugeMetric((Gauge)annotation, bean, element, target, metricsService);
            for (Method method : superClassBean.getDeclaredMethods()) {
                if (method.isSynthetic()) continue;
                this.registerGaugeMetric((Gauge)annotation, bean, element, target, metricsService);
            }
        }
    }

    private <E extends Member & AnnotatedElement> void registerFromStereotypes(Set<Class<? extends Annotation>> stereotypes, Class<?> bean, E element, Object target, MetricsService metricsService) {
        for (Class<? extends Annotation> a : stereotypes) {
            Annotation[] array;
            for (Annotation annotation : array = a.getAnnotations()) {
                this.registerFromAnnotation(annotation, bean, element, target, metricsService);
            }
        }
    }

    private <E extends Member & AnnotatedElement> void registerMetrics(Class<?> bean, E element, Object target, MetricsService metricsService) {
        Timed timedAnnotation = ((AnnotatedElement)element).getAnnotation(Timed.class);
        Counted countedAnnotation = ((AnnotatedElement)element).getAnnotation(Counted.class);
        Gauge gaugeAnnotation = ((AnnotatedElement)element).getAnnotation(Gauge.class);
        if (timedAnnotation != null && !this.isMethodPrivate(element)) {
            this.registerTimedMetric(timedAnnotation, bean, element, metricsService);
        }
        if (countedAnnotation != null && !this.isMethodPrivate(element)) {
            this.registerCountedMetric(countedAnnotation, bean, element, metricsService);
        }
        if (gaugeAnnotation != null) {
            this.registerGaugeMetric(gaugeAnnotation, bean, element, target, metricsService);
        }
        if (timedAnnotation == null && countedAnnotation == null && gaugeAnnotation == null) {
            for (Annotation annotation : bean.getAnnotations()) {
                this.registerFromAnnotation(annotation, bean, element, target, metricsService);
            }
        }
    }

    private <E extends Member & AnnotatedElement> boolean isMethodPrivate(E element) {
        return element instanceof Method && Modifier.isPrivate(((Method)element).getModifiers());
    }

    private <E extends Member & AnnotatedElement> void registerFromAnnotation(Annotation annotation, Class<?> bean, E element, Object target, MetricsService metricsService) {
        if (annotation.annotationType().isAssignableFrom(Timed.class) && !this.isMethodPrivate(element)) {
            this.registerTimedMetric((Timed)annotation, bean, element, metricsService);
        }
        if (annotation.annotationType().isAssignableFrom(Counted.class) && !this.isMethodPrivate(element)) {
            this.registerCountedMetric((Counted)annotation, bean, element, metricsService);
        }
        if (annotation.annotationType().isAssignableFrom(Gauge.class)) {
            this.registerGaugeMetric((Gauge)annotation, bean, element, target, metricsService);
        }
    }

    private <E extends Member & AnnotatedElement> void registerTimedMetric(Timed timedAnnotation, Class<?> bean, E element, MetricsService metricsService) {
        String scope = timedAnnotation.scope();
        if (scope != null) {
            MetricRegistry metricRegistry = metricsService.getContext(true).getOrCreateRegistry(scope);
            MetricsInterceptor.register(bean, element, AnnotationReader.TIMED, metricRegistry::timer);
        } else {
            MetricsInterceptor.register(bean, element, AnnotationReader.TIMED, this.registry::timer);
        }
    }

    private <E extends Member & AnnotatedElement> void registerCountedMetric(Counted countedAnnotation, Class<?> bean, E element, MetricsService metricsService) {
        String scope = countedAnnotation.scope();
        if (scope != null) {
            MetricRegistry metricRegistry = metricsService.getContext(true).getOrCreateRegistry(scope);
            MetricsInterceptor.register(bean, element, AnnotationReader.COUNTED, metricRegistry::counter);
        } else {
            MetricsInterceptor.register(bean, element, AnnotationReader.COUNTED, this.registry::counter);
        }
    }

    private <E extends Member & AnnotatedElement> void registerGaugeMetric(Gauge gaugeAnnotation, Class<?> bean, E element, Object target, MetricsService metricsService) {
        String scope = gaugeAnnotation.scope();
        if (scope != null) {
            MetricRegistry metricRegistry = metricsService.getContext(true).getOrCreateRegistry(scope);
            MetricsInterceptor.register(bean, element, AnnotationReader.GAUGE, (metadata, tags) -> metricRegistry.gauge((Metadata)metadata, new GaugeImpl((Method)element, target), (Tag)tags));
        } else {
            MetricsInterceptor.register(bean, element, AnnotationReader.GAUGE, (metadata, tags) -> this.registry.gauge((Metadata)metadata, new GaugeImpl((Method)element, target), (Tag)tags));
        }
    }

    private static <E extends Member & AnnotatedElement, T extends Annotation> void register(Class<?> bean, E element, AnnotationReader<T> reader, BiConsumer<Metadata, Tag[]> register) {
        if (reader.isPresent(bean, element)) {
            register.accept(reader.metadata(bean, element), reader.tags(reader.annotation(bean, element)));
        }
    }
}

