/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.opentracing;

import fish.payara.nucleus.requesttracing.RequestTracingService;
import fish.payara.opentracing.PayaraRequestTracingProcessor;
import io.opentelemetry.api.GlobalOpenTelemetry;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.logs.Logger;
import io.opentelemetry.api.metrics.Meter;
import io.opentelemetry.api.trace.Tracer;
import io.opentelemetry.api.trace.TracerProvider;
import io.opentelemetry.context.propagation.ContextPropagators;
import io.opentelemetry.sdk.OpenTelemetrySdk;
import io.opentelemetry.sdk.autoconfigure.AutoConfiguredOpenTelemetrySdk;
import io.opentelemetry.sdk.autoconfigure.spi.ConfigurationException;
import io.opentelemetry.sdk.logs.SdkLoggerProvider;
import io.opentelemetry.sdk.metrics.SdkMeterProvider;
import io.opentelemetry.sdk.trace.SdkTracerProvider;
import io.opentelemetry.sdk.trace.SpanProcessor;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import jakarta.inject.Inject;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.logging.Level;
import org.glassfish.api.event.EventListener;
import org.glassfish.api.event.Events;
import org.glassfish.api.invocation.ApplicationEnvironment;
import org.glassfish.api.invocation.ComponentInvocation;
import org.glassfish.api.invocation.InvocationManager;
import org.glassfish.hk2.api.ServiceHandle;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.internal.data.ApplicationInfo;
import org.glassfish.internal.data.ApplicationRegistry;
import org.glassfish.internal.deployment.Deployment;
import org.jvnet.hk2.annotations.Service;

@Service(name="opentelemetry-service")
public class OpenTelemetryService
implements EventListener {
    public static final String INSTRUMENTATION_SCOPE_NAME = "payara";
    private static final Map<String, OpenTelemetryAppInfo> appTelemetries = new ConcurrentHashMap<String, OpenTelemetryAppInfo>();
    private static final java.util.logging.Logger logger = java.util.logging.Logger.getLogger(OpenTelemetryService.class.getName());
    @Inject
    Events events;
    @Inject
    ServiceLocator locator;
    @Inject
    InvocationManager invocationManager;
    @Inject
    ApplicationRegistry applicationRegistry;

    public Tracer getCurrentTracer() {
        String appName = this.initializeCurrentApplication();
        return this.getTracer(appName).orElseThrow(() -> OpenTelemetryService.currentAppNotInitializedException(appName));
    }

    public void initializeCurrentApplication(Map<String, String> otelProps) {
        this.initializeApplication(this.currentApplication(), otelProps);
    }

    public void shutdownCurrentApplication() {
        this.shutdown(this.currentApplication());
    }

    public OpenTelemetry getCurrentSdk() {
        String appName = this.initializeCurrentApplication();
        return (OpenTelemetry)this.getSdk(appName).orElseThrow(() -> OpenTelemetryService.currentAppNotInitializedException(appName));
    }

    @PostConstruct
    void postConstruct() {
        if (this.events != null) {
            this.events.register((EventListener)this);
        } else {
            logger.log(Level.WARNING, "OpenTelemetry service not registered to Payara Events: The Tracer for an application won't be removed upon undeployment");
        }
        GlobalOpenTelemetry.set((OpenTelemetry)new GlobalTelemetry());
    }

    @PreDestroy
    void stopAll() {
        appTelemetries.values().forEach(OpenTelemetryAppInfo::shutdown);
    }

    public void event(EventListener.Event<?> event) {
        if (event.is(Deployment.APPLICATION_UNLOADED)) {
            ApplicationInfo info = (ApplicationInfo)event.hook();
            this.shutdown(info.getName());
        }
    }

    private void shutdown(String appName) {
        OpenTelemetryAppInfo appInfo = appTelemetries.remove(appName);
        if (appInfo != null) {
            appInfo.shutdown();
        }
    }

    private String initializeCurrentApplication() {
        String appName = this.currentApplication();
        if (appName == null) {
            throw new IllegalStateException("No application code is executing. Cannot determine current application scope");
        }
        this.ensureAppInitialized(appName, null);
        return appName;
    }

    private Optional<Tracer> getTracer(String applicationName) {
        return this.get(applicationName, OpenTelemetryAppInfo::tracer);
    }

    private static IllegalStateException currentAppNotInitializedException(String appName) {
        return new IllegalStateException("Application " + appName + " should have initialized, but it didn't");
    }

    private String currentApplication() {
        ComponentInvocation invocation = this.invocationManager.getCurrentInvocation();
        if (invocation == null) {
            ApplicationEnvironment appEnv = this.invocationManager.peekAppEnvironment();
            if (appEnv != null) {
                return appEnv.getName();
            }
            return null;
        }
        String appName = invocation.getAppName();
        if (appName == null && (appName = invocation.getModuleName()) == null && (appName = invocation.getComponentId()) != null && this.applicationRegistry.get(appName) == null) {
            String[] componentIds = appName.split("_/");
            appName = componentIds[0];
        }
        return appName;
    }

    void ensureAppInitialized(String appName, Map<String, String> properties) {
        appTelemetries.computeIfAbsent(appName, k -> new OpenTelemetryAppInfo(this.createSdk(appName, properties)));
    }

    private <T> Optional<T> get(String applicationName, Function<OpenTelemetryAppInfo, T> getter) {
        if (applicationName == null) {
            return Optional.empty();
        }
        OpenTelemetryAppInfo appInfo = appTelemetries.get(applicationName);
        if (appInfo == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(getter.apply(appInfo));
    }

    private OpenTelemetrySdk createSdk(String applicationName, Map<String, String> configProperties) {
        if (this.isOtelEnabled(configProperties) || this.isPayaraTracingEnabled()) {
            HashMap<String, String> props = new HashMap<String, String>(configProperties != null ? configProperties : Map.of());
            this.addDefault(props, "otel.service.name", applicationName);
            this.addDefault(props, "otel.metrics.exporter", "none");
            try {
                return AutoConfiguredOpenTelemetrySdk.builder().setServiceClassLoader(Thread.currentThread().getContextClassLoader()).registerShutdownHook(false).addTracerProviderCustomizer((builder, config) -> {
                    if (this.isPayaraTracingEnabled()) {
                        return builder.addSpanProcessor((SpanProcessor)new PayaraRequestTracingProcessor((RequestTracingService)this.locator.getService(RequestTracingService.class, new Annotation[0])));
                    }
                    return builder;
                }).addPropertiesSupplier(() -> props).setResultAsGlobal(false).build().getOpenTelemetrySdk();
            }
            catch (ConfigurationException ce) {
                logger.log(Level.SEVERE, "Failed to configure OpenTelemetry for " + applicationName + " using classlaoder " + Thread.currentThread().getContextClassLoader() + " will revert to no-op", ce);
                return OpenTelemetrySdk.builder().build();
            }
        }
        return OpenTelemetrySdk.builder().build();
    }

    private boolean isOtelEnabled(Map<String, String> configProperties) {
        boolean result;
        boolean bl = result = configProperties != null && !configProperties.isEmpty();
        if (!result) {
            result = "false".equalsIgnoreCase(System.getProperty("otel.sdk.disabled", "true"));
        }
        if (!result) {
            result = "false".equalsIgnoreCase(System.getenv("OTEL_SDK_DISABLED"));
        }
        return result;
    }

    private boolean isPayaraTracingEnabled() {
        ServiceHandle handle = this.locator.getServiceHandle(RequestTracingService.class, new Annotation[0]);
        return handle != null && handle.isActive() && ((RequestTracingService)handle.getService()).isRequestTracingEnabled();
    }

    private void addDefault(Map<String, String> props, String key, String value) {
        if (props.containsKey(key)) {
            return;
        }
        if (System.getProperty(key) != null) {
            return;
        }
        if (System.getenv(key.toUpperCase().replace('.', '_')) != null) {
            return;
        }
        props.put(key, value);
    }

    private Optional<Meter> getMeter(String applicationName) {
        return this.get(applicationName, OpenTelemetryAppInfo::meter);
    }

    private Optional<Logger> getLogger(String applicationName) {
        return this.get(applicationName, OpenTelemetryAppInfo::logger);
    }

    private OpenTelemetrySdk initializeApplication(String applicationName, Map<String, String> configProperties) {
        OpenTelemetrySdk sdk = this.createSdk(applicationName, configProperties);
        OpenTelemetryAppInfo previous = appTelemetries.put(applicationName, new OpenTelemetryAppInfo(sdk));
        if (previous != null) {
            previous.shutdown();
        }
        return sdk;
    }

    Optional<OpenTelemetrySdk> getSdk(String applicationName) {
        return this.get(applicationName, OpenTelemetryAppInfo::sdk);
    }

    public Optional<OpenTelemetrySdk> getSdkDependency(String applicationName, Runnable shutdownListener) {
        return this.get(applicationName, appInfo -> {
            appInfo.addShutdownListener(shutdownListener);
            return appInfo.sdk();
        });
    }

    public boolean isEnabled() {
        String application = this.currentApplication();
        return application != null && appTelemetries.containsKey(application) || this.isPayaraTracingEnabled();
    }

    class GlobalTelemetry
    implements OpenTelemetry {
        GlobalTelemetry() {
        }

        public TracerProvider getTracerProvider() {
            return OpenTelemetryService.this.get(OpenTelemetryService.this.currentApplication(), appInfo -> appInfo.sdk().getTracerProvider()).orElse(TracerProvider.noop());
        }

        public ContextPropagators getPropagators() {
            return OpenTelemetryService.this.get(OpenTelemetryService.this.currentApplication(), appInfo -> appInfo.sdk().getPropagators()).orElse(ContextPropagators.noop());
        }
    }

    static class OpenTelemetryAppInfo {
        private final OpenTelemetrySdk sdk;
        private Tracer tracer;
        private Meter meter;
        private Logger logger;
        private List<Runnable> shutdownListeners;

        OpenTelemetryAppInfo(OpenTelemetrySdk sdk) {
            this.sdk = sdk;
        }

        Tracer tracer() {
            if (this.tracer == null) {
                this.tracer = this.sdk.getTracerProvider().get(OpenTelemetryService.INSTRUMENTATION_SCOPE_NAME);
            }
            return this.tracer;
        }

        Meter meter() {
            if (this.meter == null) {
                this.meter = this.sdk.getMeterProvider().get(OpenTelemetryService.INSTRUMENTATION_SCOPE_NAME);
            }
            return this.meter;
        }

        Logger logger() {
            if (this.logger == null) {
                this.logger = this.sdk.getSdkLoggerProvider().get(OpenTelemetryService.INSTRUMENTATION_SCOPE_NAME);
            }
            return this.logger;
        }

        OpenTelemetrySdk sdk() {
            return this.sdk;
        }

        synchronized void addShutdownListener(Runnable listener) {
            if (this.shutdownListeners == null) {
                this.shutdownListeners = new ArrayList<Runnable>(2);
            }
            this.shutdownListeners.add(listener);
        }

        synchronized void shutdown() {
            SdkLoggerProvider logProvider;
            SdkMeterProvider meterProvider;
            SdkTracerProvider tracerProvider;
            if (this.shutdownListeners != null) {
                this.shutdownListeners.forEach(Runnable::run);
            }
            if ((tracerProvider = this.sdk.getSdkTracerProvider()) != null) {
                tracerProvider.shutdown();
            }
            if ((meterProvider = this.sdk.getSdkMeterProvider()) != null) {
                meterProvider.shutdown();
            }
            if ((logProvider = this.sdk.getSdkLoggerProvider()) != null) {
                logProvider.shutdown();
            }
        }
    }
}

