/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.opentracing;

import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.StatusCode;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.Scope;

public class PropagationHelper
implements Scope {
    private final Span span;
    private final Context propagatedContext;
    private Scope spanScope;
    private Scope contextScope;
    private boolean singleThreaded = true;
    private boolean errorReported;

    private PropagationHelper(Span span, Context propagatedContext) {
        this.span = span;
        this.propagatedContext = propagatedContext;
    }

    public static PropagationHelper start(Span span, Context spanContext) {
        return new PropagationHelper(span, spanContext).start(true);
    }

    public static PropagationHelper startMultiThreaded(Span span, Context spanContext) {
        return new PropagationHelper(span, spanContext).start(false);
    }

    public Scope localScope() {
        return new LocalScope();
    }

    public Span span() {
        return this.span;
    }

    private PropagationHelper start(boolean singleThreaded) {
        this.singleThreaded = singleThreaded;
        if (this.propagatedContext != null) {
            this.contextScope = this.propagatedContext.makeCurrent();
        }
        this.spanScope = this.span.makeCurrent();
        return this;
    }

    public void end() {
        if (!this.errorReported) {
            this.span.end();
            this.span.setStatus(StatusCode.OK);
        }
    }

    public void end(Throwable error) {
        if (error == null) {
            this.end();
        } else {
            this.errorReported = true;
            this.span.setStatus(StatusCode.ERROR, error.getMessage());
            this.span.recordException(error);
        }
    }

    public void close() {
        if (this.spanScope != null) {
            this.spanScope.close();
            this.spanScope = null;
        }
        if (this.contextScope != null) {
            this.contextScope.close();
            this.contextScope = null;
        }
        if (this.singleThreaded && !this.errorReported) {
            this.end();
        }
    }

    public class LocalScope
    implements Scope {
        private final Scope localContext;
        private final Scope localSpan;

        private LocalScope() {
            this.localContext = PropagationHelper.this.propagatedContext != null ? PropagationHelper.this.propagatedContext.makeCurrent() : null;
            this.localSpan = PropagationHelper.this.span.makeCurrent();
        }

        public void close() {
            if (this.localContext != null) {
                this.localContext.close();
            }
            this.localSpan.close();
        }
    }
}

