/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.nucleus.exec;

import com.hazelcast.cluster.Member;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.scheduledexecutor.IScheduledExecutorService;
import com.hazelcast.scheduledexecutor.IScheduledFuture;
import fish.payara.nucleus.events.HazelcastEvents;
import fish.payara.nucleus.exec.ScheduledTaskFuture;
import fish.payara.nucleus.hazelcast.HazelcastCore;
import jakarta.annotation.PostConstruct;
import jakarta.inject.Inject;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import org.glassfish.api.event.EventListener;
import org.glassfish.api.event.Events;
import org.glassfish.hk2.runlevel.RunLevel;
import org.jvnet.hk2.annotations.Service;

@Service(name="payara-cluster-executor")
@RunLevel(value=10)
public class ClusterExecutionService
implements EventListener {
    private static final Logger logger = Logger.getLogger(ClusterExecutionService.class.getCanonicalName());
    @Inject
    private HazelcastCore hzCore;
    @Inject
    private Events events;

    @PostConstruct
    public void postConstruct() {
        this.events.register((EventListener)this);
    }

    public <T extends Serializable> Future<T> runCallable(Callable<T> callable) {
        Future result = null;
        if (this.hzCore.isEnabled()) {
            result = this.hzCore.getInstance().getExecutorService("payara-cluster-execution").submit(callable);
        }
        return result;
    }

    public <T extends Serializable> Future<T> runCallable(UUID memberUUID, Callable<T> callable) {
        Future result = null;
        if (this.hzCore.isEnabled()) {
            Member toSubmitTo = this.selectMember(memberUUID);
            result = this.hzCore.getInstance().getExecutorService("payara-cluster-execution").submitToMember(callable, toSubmitTo);
        }
        return result;
    }

    public <T extends Serializable> Map<UUID, Future<T>> runCallable(Collection<UUID> memberUUIDS, Callable<T> callable) {
        HashMap<UUID, Future<T>> result = new HashMap<UUID, Future<T>>(2);
        if (this.hzCore.isEnabled()) {
            Set<Member> membersToSubmit = this.selectMembers(memberUUIDS);
            Map results = this.hzCore.getInstance().getExecutorService("payara-cluster-execution").submitToMembers(callable, membersToSubmit);
            for (Map.Entry entry : results.entrySet()) {
                Member member = (Member)entry.getKey();
                result.put(member.getUuid(), (Future)entry.getValue());
            }
        }
        return result;
    }

    public <T extends Serializable> Map<UUID, Future<T>> runCallableAllMembers(Callable<T> callable) {
        HashMap<UUID, Future<T>> result = new HashMap<UUID, Future<T>>(2);
        if (this.hzCore.isEnabled()) {
            HazelcastInstance instance = this.hzCore.getInstance();
            Map results = this.hzCore.getInstance().getExecutorService("payara-cluster-execution").submitToAllMembers(callable);
            for (Map.Entry entry : results.entrySet()) {
                Member member = (Member)entry.getKey();
                result.put(member.getUuid(), (Future)entry.getValue());
            }
        }
        return result;
    }

    public <V extends Serializable> ScheduledTaskFuture<V> schedule(Callable<V> callable, long delay, TimeUnit unit) {
        ScheduledTaskFuture result = null;
        if (this.hzCore.isEnabled()) {
            IScheduledExecutorService scheduledExecutorService = this.hzCore.getInstance().getScheduledExecutorService("payara-scheduled-execution");
            IScheduledFuture schedule = scheduledExecutorService.schedule(callable, delay, unit);
            result = new ScheduledTaskFuture(schedule);
        }
        return result;
    }

    public <V extends Serializable> ScheduledTaskFuture<V> schedule(UUID memberUUID, Callable<V> callable, long delay, TimeUnit unit) {
        ScheduledTaskFuture result = null;
        if (this.hzCore.isEnabled()) {
            Member toSubmitTo = this.selectMember(memberUUID);
            IScheduledExecutorService scheduledExecutorService = this.hzCore.getInstance().getScheduledExecutorService("payara-scheduled-execution");
            IScheduledFuture schedule = scheduledExecutorService.scheduleOnMember(callable, toSubmitTo, delay, unit);
            result = new ScheduledTaskFuture(schedule);
        }
        return result;
    }

    public <V extends Serializable> Map<UUID, ScheduledTaskFuture<V>> schedule(Collection<UUID> memberUUIDs, Callable<V> callable, long delay, TimeUnit unit) {
        HashMap result = new HashMap(2);
        if (this.hzCore.isEnabled()) {
            Set<Member> toSubmitTo = this.selectMembers(memberUUIDs);
            IScheduledExecutorService scheduledExecutorService = this.hzCore.getInstance().getScheduledExecutorService("payara-scheduled-execution");
            Map schedule = scheduledExecutorService.scheduleOnMembers(callable, toSubmitTo, delay, unit);
            for (Map.Entry entry : schedule.entrySet()) {
                Member member = (Member)entry.getKey();
                result.put(member.getUuid(), new ScheduledTaskFuture((IScheduledFuture)entry.getValue()));
            }
        }
        return result;
    }

    public ScheduledTaskFuture<? extends Serializable> scheduleAtFixedRate(Runnable runnable, long delay, long period, TimeUnit unit) {
        ScheduledTaskFuture result = null;
        if (this.hzCore.isEnabled()) {
            IScheduledExecutorService scheduledExecutorService = this.hzCore.getInstance().getScheduledExecutorService("payara-scheduled-execution");
            IScheduledFuture schedule = scheduledExecutorService.scheduleAtFixedRate(runnable, delay, period, unit);
            result = new ScheduledTaskFuture(schedule);
        }
        return result;
    }

    public ScheduledTaskFuture<?> scheduleAtFixedRate(UUID memberUUID, Runnable runnable, long delay, long period, TimeUnit unit) {
        ScheduledTaskFuture result = null;
        if (this.hzCore.isEnabled()) {
            Member toSubmitTo = this.selectMember(memberUUID);
            IScheduledExecutorService scheduledExecutorService = this.hzCore.getInstance().getScheduledExecutorService("payara-scheduled-execution");
            IScheduledFuture schedule = scheduledExecutorService.scheduleOnMemberAtFixedRate(runnable, toSubmitTo, delay, period, unit);
            result = new ScheduledTaskFuture(schedule);
        }
        return result;
    }

    public Map<UUID, ScheduledTaskFuture<?>> scheduleAtFixedRate(Collection<UUID> memberUUIDs, Runnable runnable, long delay, long period, TimeUnit unit) {
        HashMap result = new HashMap(2);
        if (this.hzCore.isEnabled()) {
            Set<Member> toSubmitTo = this.selectMembers(memberUUIDs);
            IScheduledExecutorService scheduledExecutorService = this.hzCore.getInstance().getScheduledExecutorService("payara-scheduled-execution");
            Map schedule = scheduledExecutorService.scheduleOnMembersAtFixedRate(runnable, toSubmitTo, delay, period, unit);
            for (Map.Entry entry : schedule.entrySet()) {
                Member member = (Member)entry.getKey();
                result.put(member.getUuid(), new ScheduledTaskFuture((IScheduledFuture)entry.getValue()));
            }
        }
        return result;
    }

    public void event(EventListener.Event event) {
        if (event.is(HazelcastEvents.HAZELCAST_BOOTSTRAP_COMPLETE) && this.hzCore.isEnabled()) {
            logger.config("Payara Clustered Executor Service Enabled");
        }
    }

    private Member selectMember(UUID memberUUID) {
        Set members = this.hzCore.getInstance().getCluster().getMembers();
        Member toSubmitTo = null;
        for (Member member : members) {
            if (!member.getUuid().equals(memberUUID)) continue;
            toSubmitTo = member;
            break;
        }
        return toSubmitTo;
    }

    private Set<Member> selectMembers(Collection<UUID> memberUUIDS) {
        HazelcastInstance instance = this.hzCore.getInstance();
        Set members = instance.getCluster().getMembers();
        HashSet<Member> membersToSubmit = new HashSet<Member>(members.size());
        for (Member member : members) {
            if (!memberUUIDS.contains(member.getUuid())) continue;
            membersToSubmit.add(member);
        }
        return membersToSubmit;
    }
}

