/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.nucleus.hazelcast;

import com.hazelcast.cluster.Address;
import com.hazelcast.cluster.Member;
import com.hazelcast.internal.partition.membergroup.DefaultMemberGroup;
import com.hazelcast.logging.ILogger;
import com.hazelcast.spi.discovery.AbstractDiscoveryStrategy;
import com.hazelcast.spi.discovery.DiscoveryNode;
import com.hazelcast.spi.discovery.SimpleDiscoveryNode;
import com.hazelcast.spi.partitiongroup.MemberGroup;
import com.hazelcast.spi.partitiongroup.PartitionGroupStrategy;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.Node;
import com.sun.enterprise.util.io.InstanceDirs;
import fish.payara.nucleus.hazelcast.HazelcastRuntimeConfiguration;
import fish.payara.nucleus.hazelcast.MemberAddressPicker;
import fish.payara.nucleus.hazelcast.PayaraHazelcastDiscoveryFactory;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.logging.Level;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.grizzly.utils.Holder;
import org.glassfish.internal.api.Globals;

public final class DomainDiscoveryStrategy
extends AbstractDiscoveryStrategy {
    private final boolean hostAwarePartitioning;
    private final Holder.LazyHolder<InetAddress> chosenAddress = Holder.LazyHolder.lazyHolder(MemberAddressPicker::findMyAddressOrLocalHost);

    public DomainDiscoveryStrategy(ILogger logger, Map<String, Comparable> properties) {
        super(logger, properties);
        this.hostAwarePartitioning = (Boolean)this.getOrDefault("fish.payara.cluster", PayaraHazelcastDiscoveryFactory.HOST_AWARE_PARTITIONING, Boolean.FALSE);
    }

    public Iterable<DiscoveryNode> discoverNodes() {
        LinkedList<DiscoveryNode> nodes;
        block21: {
            this.getLogger().fine("Starting Domain Node Discovery");
            nodes = new LinkedList<DiscoveryNode>();
            Domain domain = (Domain)Globals.getDefaultHabitat().getService(Domain.class, new Annotation[0]);
            ServerEnvironment env = (ServerEnvironment)Globals.getDefaultHabitat().getService(ServerEnvironment.class, new Annotation[0]);
            HazelcastRuntimeConfiguration hzConfig = (HazelcastRuntimeConfiguration)domain.getExtensionByType(HazelcastRuntimeConfiguration.class);
            if (!env.isDas()) {
                try {
                    this.getLogger().fine("This is a Standalone Instance");
                    String dasHost = hzConfig.getDASPublicAddress();
                    if (dasHost == null || dasHost.isEmpty()) {
                        dasHost = hzConfig.getDASBindAddress();
                    }
                    if ((dasHost = Optional.ofNullable(MemberAddressPicker.initAddress(dasHost, 0)).map(InetSocketAddress::getHostString).orElse("")).isEmpty()) {
                        this.getLogger().fine("Neither DAS Public Address or Bind Address is set in the configuration");
                        InstanceDirs instance = new InstanceDirs(env.getInstanceRoot());
                        Properties dasProps = new Properties();
                        dasProps.load(new FileInputStream(instance.getDasPropertiesFile()));
                        this.getLogger().fine("Loaded the das.properties file from the agent directory");
                        dasHost = dasProps.getProperty("agent.das.host");
                        dasHost = InetAddress.getByName(dasHost).getHostAddress();
                        this.getLogger().log(Level.FINE, String.format("Loaded the das.properties file from the agent directory and found DAS IP %s", dasHost));
                    }
                    if (dasHost.isEmpty() || dasHost.equals("127.0.0.1") || dasHost.equals("localhost")) {
                        this.getLogger().fine("Looks like the DAS IP is loopback or empty let's find the actual IP of this machine as that is where the DAS is");
                        nodes.add((DiscoveryNode)new SimpleDiscoveryNode(new Address((InetAddress)this.chosenAddress.get(), Integer.parseInt(hzConfig.getDasPort()))));
                    } else {
                        this.getLogger().log(Level.FINE, String.format("DAS should be listening on %s", dasHost));
                        nodes.add((DiscoveryNode)new SimpleDiscoveryNode(new Address(dasHost, Integer.valueOf(hzConfig.getDasPort()).intValue())));
                    }
                    this.getLogger().fine("Also adding all known domain nodes and start ports in case the DAS is down");
                    for (Node node : domain.getNodes().getNode()) {
                        InetAddress address = InetAddress.getByName(node.getNodeHost());
                        if (address.isLoopbackAddress()) continue;
                        this.getLogger().log(Level.FINE, String.format("Adding Node %s", address));
                        nodes.add((DiscoveryNode)new SimpleDiscoveryNode(new Address(address.getHostAddress(), Integer.valueOf(hzConfig.getStartPort()).intValue())));
                    }
                }
                catch (IOException ex) {
                    this.getLogger().log(Level.SEVERE, "Exception", (Throwable)ex);
                }
            } else if (env.isMicro()) {
                try {
                    this.getLogger().log(Level.FINE, String.format("We are Payara Micro therefore adding DAS %s", hzConfig.getDASPublicAddress()));
                    String dasHost = Optional.ofNullable(MemberAddressPicker.initAddress(hzConfig.getDASPublicAddress(), 0)).map(InetSocketAddress::getHostString).orElse("");
                    if (hzConfig.getDasPort().equals("4848")) {
                        this.getLogger().log(Level.WARNING, "You have specified 4848 as the datagrid domain port however this is the default DAS admin port, the default domain datagrid port is 4900");
                    }
                    if (dasHost.isEmpty() || dasHost.equals("127.0.0.1") || dasHost.equals("localhost")) {
                        nodes.add((DiscoveryNode)new SimpleDiscoveryNode(new Address((InetAddress)this.chosenAddress.get(), Integer.parseInt(hzConfig.getDasPort()))));
                        break block21;
                    }
                    nodes.add((DiscoveryNode)new SimpleDiscoveryNode(new Address(InetAddress.getByName(dasHost), Integer.valueOf(hzConfig.getDasPort()).intValue())));
                }
                catch (NumberFormatException | UnknownHostException ex) {
                    this.getLogger().log(Level.SEVERE, "Exception", (Throwable)ex);
                }
            } else {
                this.getLogger().fine("We are the DAS therefore we will add all known nodes with start port as IP addresses to connect to");
                if (domain.getNodes() == null) {
                    nodes.add((DiscoveryNode)new SimpleDiscoveryNode(new Address((InetAddress)this.chosenAddress.get(), Integer.parseInt(hzConfig.getStartPort()))));
                } else {
                    for (Node node : domain.getNodes().getNode()) {
                        try {
                            InetAddress address = InetAddress.getByName(node.getNodeHost());
                            if (!address.isLoopbackAddress()) {
                                this.getLogger().log(Level.FINE, String.format("Adding Node %s", address));
                                nodes.add((DiscoveryNode)new SimpleDiscoveryNode(new Address(address.getHostAddress(), Integer.valueOf(hzConfig.getStartPort()).intValue())));
                                continue;
                            }
                            nodes.add((DiscoveryNode)new SimpleDiscoveryNode(new Address((InetAddress)this.chosenAddress.get(), Integer.parseInt(hzConfig.getStartPort()))));
                        }
                        catch (IOException ex) {
                            this.getLogger().log(Level.SEVERE, "Exception", (Throwable)ex);
                        }
                    }
                }
            }
        }
        return nodes;
    }

    public PartitionGroupStrategy getPartitionGroupStrategy(Collection<? extends Member> allMembers) {
        this.getLogger().finest("Getting Partition Strategy");
        HashMap<String, MemberGroup> memberGroups = new HashMap<String, MemberGroup>();
        this.collectMembers(allMembers, memberGroups);
        return memberGroups::values;
    }

    private void collectMembers(Collection<? extends Member> members, Map<String, MemberGroup> memberGroups) {
        for (Member member : members) {
            StringBuilder sb = new StringBuilder();
            sb.append(member.getAttribute("GLASSFISH_INSTANCE_GROUP"));
            if (this.hostAwarePartitioning) {
                sb.append("|");
                sb.append(member.getAddress().getHost());
            }
            memberGroups.compute(sb.toString(), (key, val) -> {
                if (val == null) {
                    val = new DefaultMemberGroup();
                }
                val.addMember(member);
                this.getLogger().fine(String.format("added %s - %s to %s", member.getAddress(), member.getUuid(), key));
                return val;
            });
        }
    }
}

