/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.nucleus.hazelcast.admin;

import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.util.ColumnFormatter;
import fish.payara.nucleus.hazelcast.HazelcastConfigSpecificConfiguration;
import fish.payara.nucleus.hazelcast.HazelcastRuntimeConfiguration;
import jakarta.inject.Inject;
import java.util.HashMap;
import java.util.Properties;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.CommandLock;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RestEndpoint;
import org.glassfish.api.admin.RestEndpoints;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.internal.api.Target;
import org.jvnet.hk2.annotations.Service;

@Service(name="get-hazelcast-configuration")
@PerLookup
@CommandLock(value=CommandLock.LockType.NONE)
@I18n(value="get.hazelcast.configuration")
@ExecuteOn(value={RuntimeType.DAS})
@RestEndpoints(value={@RestEndpoint(configBean=Domain.class, opType=RestEndpoint.OpType.GET, path="get-hazelcast-configuration", description="List Hazelcast Configuration")})
public class GetHazelcastConfiguration
implements AdminCommand {
    @Inject
    private Domain domain;
    @Inject
    private Target targetUtil;
    @Param(name="target", optional=true, defaultValue="server")
    String target;
    @Param(name="checkencrypted", optional=true)
    private boolean checkEncrypted;

    public void execute(AdminCommandContext context) {
        Config config = this.targetUtil.getConfig(this.target);
        if (config == null) {
            context.getActionReport().setMessage("No such config named: " + this.target);
            context.getActionReport().setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        HazelcastConfigSpecificConfiguration nodeConfiguration = (HazelcastConfigSpecificConfiguration)config.getExtensionByType(HazelcastConfigSpecificConfiguration.class);
        HazelcastRuntimeConfiguration runtimeConfiguration = (HazelcastRuntimeConfiguration)this.domain.getExtensionByType(HazelcastRuntimeConfiguration.class);
        ActionReport actionReport = context.getActionReport();
        if (this.checkEncrypted) {
            if (!Boolean.parseBoolean(runtimeConfiguration.getDatagridEncryptionEnabled())) {
                actionReport.setMessage("Data Grid Not Encrypted");
                actionReport.setActionExitCode(ActionReport.ExitCode.FAILURE);
            } else {
                actionReport.setActionExitCode(ActionReport.ExitCode.SUCCESS);
            }
            return;
        }
        String[] headers = new String[]{"Property Name", "PropertyValue", "Scope"};
        ColumnFormatter columnFormatter = new ColumnFormatter(headers);
        columnFormatter.addRow(new Object[]{"Configuration File", runtimeConfiguration.getHazelcastConfigurationFile(), "Domain"});
        columnFormatter.addRow(new Object[]{"Interfaces", runtimeConfiguration.getInterface(), "Domain"});
        columnFormatter.addRow(new Object[]{"Auto Increment Port", runtimeConfiguration.getAutoIncrementPort(), "Domain"});
        columnFormatter.addRow(new Object[]{"Start Port", runtimeConfiguration.getStartPort(), "Domain"});
        columnFormatter.addRow(new Object[]{"Cluster Name", runtimeConfiguration.getClusterGroupName(), "Domain"});
        columnFormatter.addRow(new Object[]{"License Key", runtimeConfiguration.getLicenseKey(), "Domain"});
        columnFormatter.addRow(new Object[]{"Host Aware Partitioning", runtimeConfiguration.getHostAwarePartitioning(), "Domain"});
        columnFormatter.addRow(new Object[]{"DAS Public Address", runtimeConfiguration.getDASPublicAddress(), "Domain"});
        columnFormatter.addRow(new Object[]{"DAS Bind Address", runtimeConfiguration.getDASBindAddress(), "Domain"});
        columnFormatter.addRow(new Object[]{"DAS Port", runtimeConfiguration.getDasPort(), "Domain"});
        columnFormatter.addRow(new Object[]{"Cluster Mode", runtimeConfiguration.getDiscoveryMode(), "Domain"});
        columnFormatter.addRow(new Object[]{"Tcpip Members", runtimeConfiguration.getTcpipMembers(), "Domain"});
        columnFormatter.addRow(new Object[]{"DNS Members", runtimeConfiguration.getDnsMembers(), "Domain"});
        columnFormatter.addRow(new Object[]{"MulticastGroup", runtimeConfiguration.getMulticastGroup(), "Domain"});
        columnFormatter.addRow(new Object[]{"MulticastPort", runtimeConfiguration.getMulticastPort(), "Domain"});
        columnFormatter.addRow(new Object[]{"Kubernetes Namespace", runtimeConfiguration.getKubernetesNamespace(), "Domain"});
        columnFormatter.addRow(new Object[]{"Kubernetes Service Name", runtimeConfiguration.getKubernetesServiceName(), "Domain"});
        columnFormatter.addRow(new Object[]{"Encrypt Datagrid", runtimeConfiguration.getDatagridEncryptionEnabled(), "Domain"});
        columnFormatter.addRow(new Object[]{"Enabled", nodeConfiguration.getEnabled(), "Config"});
        columnFormatter.addRow(new Object[]{"JNDIName", nodeConfiguration.getJNDIName(), "Config"});
        columnFormatter.addRow(new Object[]{"Cache Manager JNDI Name", nodeConfiguration.getCacheManagerJNDIName(), "Config"});
        columnFormatter.addRow(new Object[]{"Caching Provider JNDI Name", nodeConfiguration.getCachingProviderJNDIName(), "Config"});
        columnFormatter.addRow(new Object[]{"Lite Member", nodeConfiguration.getLite(), "Config"});
        columnFormatter.addRow(new Object[]{"Member Name", nodeConfiguration.getMemberName(), "Config"});
        columnFormatter.addRow(new Object[]{"Member Group", nodeConfiguration.getMemberGroup(), "Config"});
        columnFormatter.addRow(new Object[]{"Executor Pool Size", nodeConfiguration.getExecutorPoolSize(), "Config"});
        columnFormatter.addRow(new Object[]{"Executor Queue Capacity", nodeConfiguration.getExecutorQueueCapacity(), "Config"});
        columnFormatter.addRow(new Object[]{"Scheduled Executor Pool Size", nodeConfiguration.getScheduledExecutorPoolSize(), "Config"});
        columnFormatter.addRow(new Object[]{"Scheduled Executor Queue Capacity", nodeConfiguration.getScheduledExecutorQueueCapacity(), "Config"});
        columnFormatter.addRow(new Object[]{"Public Address", nodeConfiguration.getPublicAddress(), "Config"});
        columnFormatter.addRow(new Object[]{"Config Specific Data Grid Start Port", nodeConfiguration.getConfigSpecificDataGridStartPort(), "Config"});
        HashMap<String, String> map = new HashMap<String, String>(26);
        Properties extraProps = new Properties();
        map.put("hazelcastConfigurationFile", runtimeConfiguration.getHazelcastConfigurationFile());
        map.put("enabled", nodeConfiguration.getEnabled());
        map.put("autoIncrementPort", runtimeConfiguration.getAutoIncrementPort());
        map.put("startPort", runtimeConfiguration.getStartPort());
        map.put("multicastGroup", runtimeConfiguration.getMulticastGroup());
        map.put("multicastPort", runtimeConfiguration.getMulticastPort());
        map.put("jndiName", nodeConfiguration.getJNDIName());
        map.put("lite", nodeConfiguration.getLite());
        map.put("clusterName", runtimeConfiguration.getClusterGroupName());
        map.put("licenseKey", runtimeConfiguration.getLicenseKey());
        map.put("hostAwarePartitioning", runtimeConfiguration.getHostAwarePartitioning());
        map.put("dasPublicAddress", runtimeConfiguration.getDASPublicAddress());
        map.put("dasBindAddress", runtimeConfiguration.getDASBindAddress());
        map.put("dasPort", runtimeConfiguration.getDasPort());
        map.put("tcpipMembers", runtimeConfiguration.getTcpipMembers());
        map.put("dnsMembers", runtimeConfiguration.getDnsMembers());
        map.put("clusterMode", runtimeConfiguration.getDiscoveryMode());
        map.put("memberName", nodeConfiguration.getMemberName());
        map.put("memberGroup", nodeConfiguration.getMemberGroup());
        map.put("interfaces", runtimeConfiguration.getInterface());
        map.put("cacheManagerJndiName", nodeConfiguration.getCacheManagerJNDIName());
        map.put("cachingProviderJndiName", nodeConfiguration.getCachingProviderJNDIName());
        map.put("executorPoolSize", nodeConfiguration.getExecutorPoolSize());
        map.put("executorQueueCapacity", nodeConfiguration.getExecutorQueueCapacity());
        map.put("scheduledExecutorPoolSize", nodeConfiguration.getScheduledExecutorPoolSize());
        map.put("scheduledExecutorQueueCapacity", nodeConfiguration.getScheduledExecutorQueueCapacity());
        map.put("publicAddress", nodeConfiguration.getPublicAddress());
        map.put("kubernetesNamespace", runtimeConfiguration.getKubernetesNamespace());
        map.put("kubernetesServiceName", runtimeConfiguration.getKubernetesServiceName());
        map.put("configSpecificDataGridStartPort", nodeConfiguration.getConfigSpecificDataGridStartPort());
        map.put("encryptDatagrid", runtimeConfiguration.getDatagridEncryptionEnabled());
        extraProps.put("getHazelcastConfiguration", map);
        actionReport.setExtraProperties(extraProps);
        actionReport.setMessage(columnFormatter.toString());
        actionReport.setActionExitCode(ActionReport.ExitCode.SUCCESS);
    }
}

