/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.rest.provider;

import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.ext.Provider;
import java.util.Set;
import org.glassfish.admin.rest.provider.BaseProvider;
import org.glassfish.admin.rest.provider.MethodMetaData;
import org.glassfish.admin.rest.provider.ParameterMetaData;
import org.glassfish.admin.rest.provider.ProviderUtil;
import org.glassfish.admin.rest.results.OptionsResult;

@Provider
@Produces(value={"application/xml"})
public class OptionsResultXmlProvider
extends BaseProvider<OptionsResult> {
    private static final String QUERY_PARAMETERS = "queryParameters";
    private static final String MESSAGE_PARAMETERS = "messageParameters";
    private static final String METHOD = "method";

    public OptionsResultXmlProvider() {
        super(OptionsResult.class, MediaType.APPLICATION_XML_TYPE);
    }

    @Override
    public String getContent(OptionsResult proxy) {
        String indent = "  ";
        String result = "<" + proxy.getName() + ">";
        result = result + this.getRespresenationForMethodMetaData(proxy, indent);
        result = result + "\n" + ProviderUtil.getEndXmlElement(proxy.getName());
        return result;
    }

    String getRespresenationForMethodMetaData(OptionsResult proxy, String indent) {
        StringBuilder result = new StringBuilder();
        Set<String> methods = proxy.methods();
        for (String method : methods) {
            result.append(this.getMethod(method, indent));
            MethodMetaData methodMetaData = proxy.getMethodMetaData(method);
            result.append(this.getMessageParams(methodMetaData, indent + "  "));
            result.append("\n").append(indent);
            result.append((CharSequence)result).append(ProviderUtil.getEndXmlElement(METHOD));
        }
        return result.toString();
    }

    private String getMethod(String method, String indent) {
        String result = "\n" + indent + "<";
        result = result + "method name=";
        result = result + ProviderUtil.quote(method);
        result = result + ">";
        return result;
    }

    private String getMessageParams(MethodMetaData methodMetaData, String indent) {
        StringBuilder result = new StringBuilder();
        if (methodMetaData.sizeParameterMetaData() > 0) {
            result.append("\n").append(indent);
            result.append("<messageParameters>");
            Set<String> parameters = methodMetaData.parameters();
            for (String parameter : parameters) {
                ParameterMetaData parameterMetaData = methodMetaData.getParameterMetaData(parameter);
                result.append(this.getParameter(parameter, parameterMetaData, indent + "  "));
            }
            result.append("\n").append(indent);
            result.append(ProviderUtil.getEndXmlElement(MESSAGE_PARAMETERS));
        }
        return result.toString();
    }

    private String getParameter(String parameter, ParameterMetaData parameterMetaData, String indent) {
        StringBuilder result = new StringBuilder("\n" + indent);
        result.append("<").append(parameter);
        Set<String> attributes = parameterMetaData.attributes();
        for (String attributeName : attributes) {
            String attributeValue = parameterMetaData.getAttributeValue(attributeName);
            result.append(this.getAttribute(attributeName, attributeValue));
        }
        result.append("/>");
        return result.toString();
    }

    private String getAttribute(String name, String value) {
        Object result = " ";
        name = name.replace(' ', '-');
        result = (String)result + name + "=" + ProviderUtil.quote(value);
        return result;
    }
}

