/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.rest.resources;

import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.core.Response;
import java.io.InputStream;

@Path(value="/static/")
public class StaticResource {
    private static final String PATH_INSIDE_JAR = "org/glassfish/admin/rest/static/";
    private static final String[] mimes = new String[]{".bmp", "image/bmp", ".bz", "application/x-bzip", ".bz2", "application/x-bzip2", ".css", "text/css", ".gz", "application/x-gzip", ".gzip", "application/x-gzip", ".htm", "text/html", ".html", "text/html", ".htmls", "text/html", ".htx", "text/html", ".ico", "image/x-icon", ".jpe", "image/jpeg", ".jpe", "image/pjpeg", ".jpeg", "image/jpeg", ".jpg", "image/jpeg", ".js", "application/x-javascript", ".javascript", "application/x-javascript", ".json", "application/json", ".png", "image/png", ".text", "text/plain", ".tif", "image/tiff", ".tiff", "image/tiff", ".xml", "text/xml", ".zip", "application/zip"};

    @GET
    @Path(value="{resource: .+}")
    public Response getPath(@PathParam(value="resource") String resource) {
        InputStream is = this.getClass().getClassLoader().getResourceAsStream(PATH_INSIDE_JAR + resource);
        Response r = null;
        String m = this.getMime(resource);
        Response.ResponseBuilder rp = Response.ok((Object)is, m);
        rp.header("resource3-header", m);
        r = rp.build();
        return r;
    }

    private String getMime(String extension) {
        for (int i = 0; i < mimes.length; i += 2) {
            if (!extension.endsWith(mimes[i])) continue;
            return mimes[i + 1];
        }
        return "text/plain";
    }
}

