/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.ejb.http.admin;

import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.SecurityService;
import com.sun.enterprise.util.StringUtils;
import fish.payara.ejb.http.admin.EjbInvokerConfiguration;
import jakarta.inject.Inject;
import java.nio.file.Path;
import java.util.logging.Logger;
import javax.security.auth.Subject;
import org.glassfish.api.ActionReport;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.CommandRunner;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.ParameterMap;
import org.glassfish.api.admin.RestEndpoint;
import org.glassfish.api.admin.RestEndpoints;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.deployment.autodeploy.AutoDeployer;
import org.glassfish.deployment.autodeploy.AutoDeploymentOperation;
import org.glassfish.deployment.autodeploy.AutoUndeploymentOperation;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.internal.api.Target;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.TransactionFailure;

@Service(name="set-ejb-invoker-configuration")
@PerLookup
@ExecuteOn(value={RuntimeType.DAS})
@TargetType(value={CommandTarget.CLUSTER, CommandTarget.CLUSTERED_INSTANCE, CommandTarget.CONFIG, CommandTarget.DAS, CommandTarget.DEPLOYMENT_GROUP, CommandTarget.STANDALONE_INSTANCE})
@RestEndpoints(value={@RestEndpoint(configBean=EjbInvokerConfiguration.class, opType=RestEndpoint.OpType.POST, path="set-ejb-invoker-configuration", description="Sets the ejb-invoker configuration")})
public class SetEjbInvokerConfigurationCommand
implements AdminCommand {
    private static final Logger LOGGER = Logger.getLogger(SetEjbInvokerConfigurationCommand.class.getName());
    @Inject
    private Target targetUtil;
    @Param(optional=true)
    private Boolean enabled;
    @Param(optional=true)
    private String endpoint;
    @Param(optional=true, alias="virtualservers")
    private String virtualServers;
    @Param(optional=true, alias="securityenabled")
    protected Boolean securityEnabled;
    @Param(optional=true, alias="realmname")
    protected String realmName;
    @Param(optional=true, alias="authtype")
    protected String authType;
    @Param(optional=true, alias="authmodule")
    protected String authModule;
    @Param(optional=true, alias="authmoduleclass")
    protected String authModuleClass;
    @Param(optional=true)
    protected String roles;
    @Param(optional=true, defaultValue="server")
    protected String target;
    @Inject
    protected CommandRunner commandRunner;
    @Inject
    private SecurityService securityService;
    @Inject
    private ServerEnvironment serverEnvironment;
    @Inject
    private ServiceLocator serviceLocator;
    @Inject
    private Domain domain;

    public void execute(AdminCommandContext context) {
        ActionReport actionReport = context.getActionReport();
        Subject subject = context.getSubject();
        Config targetConfig = this.targetUtil.getConfig(this.target);
        EjbInvokerConfiguration config = (EjbInvokerConfiguration)targetConfig.getExtensionByType(EjbInvokerConfiguration.class);
        try {
            ConfigSupport.apply(configProxy -> {
                if (this.enabled != null) {
                    configProxy.setEnabled(this.enabled.toString());
                }
                if (this.endpoint != null) {
                    configProxy.setEndpoint(this.endpoint);
                }
                if (this.virtualServers != null) {
                    configProxy.setVirtualServers(this.virtualServers);
                }
                if (this.securityEnabled != null) {
                    configProxy.setSecurityEnabled(this.securityEnabled.toString());
                }
                if (this.realmName != null) {
                    configProxy.setRealmName(this.realmName);
                }
                if (this.authType != null) {
                    configProxy.setAuthType(this.authType);
                }
                if (this.authModule != null) {
                    configProxy.setAuthModule(this.authModule);
                }
                if (this.authModuleClass != null) {
                    if (StringUtils.ok((String)this.authModuleClass) && this.authModuleClass.indexOf(46) == -1) {
                        actionReport.failure(LOGGER, "authModuleClass parameter value must be fully qualified class name.");
                    }
                    configProxy.setAuthModuleClass(this.authModuleClass);
                }
                if (this.roles != null) {
                    configProxy.setRoles(this.roles);
                }
                actionReport.setActionExitCode(ActionReport.ExitCode.SUCCESS);
                return configProxy;
            }, (ConfigBeanProxy)config);
        }
        catch (TransactionFailure ex) {
            actionReport.failure(LOGGER, "Failed to update EJB Invoker configuration", (Throwable)ex);
        }
        if (Boolean.parseBoolean(config.getSecurityEnabled())) {
            if (StringUtils.ok((String)config.getAuthModuleClass())) {
                String moduleClass = config.getAuthModuleClass();
                String moduleId = moduleClass.substring(moduleClass.lastIndexOf(46) + 1);
                ActionReport checkSecurityProviderReport = actionReport.addSubActionsReport();
                ActionReport createSecurityProviderReport = actionReport.addSubActionsReport();
                if (!this.messageSecurityProviderExists(moduleId, checkSecurityProviderReport, context.getSubject())) {
                    this.createRequiredMessageSecurityProvider(moduleId, moduleClass, createSecurityProviderReport, subject);
                }
                if (checkSecurityProviderReport.hasFailures() || createSecurityProviderReport.hasFailures()) {
                    actionReport.setActionExitCode(ActionReport.ExitCode.FAILURE);
                    return;
                }
            }
            if (!StringUtils.ok((String)config.getRealmName()) || config.getRealmName().equals("file")) {
                ActionReport checkUserReport = actionReport.addSubActionsReport();
                ActionReport createUserReport = actionReport.addSubActionsReport();
                if (!this.defaultUserExists(config, checkUserReport, subject) && !checkUserReport.hasFailures()) {
                    this.createDefaultUser(config, createUserReport, subject);
                }
                if (checkUserReport.hasFailures() || createUserReport.hasFailures()) {
                    actionReport.setActionExitCode(ActionReport.ExitCode.FAILURE);
                    return;
                }
            }
        }
        if (this.enabled != null) {
            if (this.enabled.booleanValue()) {
                this.enableEjbInvoker(actionReport);
            } else {
                this.disableEjbInvoker(actionReport);
            }
        } else if (Boolean.parseBoolean(config.getEnabled())) {
            actionReport.setMessage("Restart server or re-enable the ejb-invoker service for the change to take effect.");
        }
        if (!actionReport.hasFailures() && !actionReport.hasWarnings()) {
            actionReport.getSubActionsReport().clear();
        }
    }

    public void disableEjbInvoker(ActionReport report) {
        Path endPointsPath = this.serverEnvironment.getInstanceRoot().toPath().resolve("endpoints");
        Path ejbInvokerPath = endPointsPath.resolve("__ejb-invoker");
        AutoUndeploymentOperation autoUndeploymentOperation = AutoUndeploymentOperation.newInstance(this.serviceLocator, ejbInvokerPath.toFile(), AutoDeployer.getNameFromFilePath(endPointsPath.toFile(), ejbInvokerPath.toFile()), this.target);
        AutoDeployer.AutodeploymentStatus deploymentStatus = autoUndeploymentOperation.run();
        report.setActionExitCode(deploymentStatus.getExitCode());
        if (deploymentStatus.getExitCode().equals((Object)ActionReport.ExitCode.FAILURE)) {
            if (this.domain.getApplications().getApplication("__ejb-invoker") == null) {
                report.appendMessage("\nEJB Invoker is not enabled on any target");
            } else {
                report.appendMessage("\nFailed to disable Ejb Invoker - was it enabled on the specified target?");
            }
        }
    }

    public void enableEjbInvoker(ActionReport report) {
        Path endPointsPath = this.serverEnvironment.getInstanceRoot().toPath().resolve("endpoints");
        Path ejbInvokerPath = endPointsPath.resolve("__ejb-invoker");
        Config targetConfig = this.targetUtil.getConfig(this.target);
        EjbInvokerConfiguration configuration = (EjbInvokerConfiguration)targetConfig.getExtensionByType(EjbInvokerConfiguration.class);
        AutoDeploymentOperation autoDeploymentOperation = AutoDeploymentOperation.newInstance(this.serviceLocator, ejbInvokerPath.toFile(), configuration.getVirtualServers(), this.target, configuration.getEndpoint());
        if (this.domain.getApplications().getApplication("__ejb-invoker") == null) {
            AutoDeployer.AutodeploymentStatus deploymentStatus = autoDeploymentOperation.run();
            report.setActionExitCode(deploymentStatus.getExitCode());
        } else {
            report.setActionExitCode(ActionReport.ExitCode.WARNING);
            report.setMessage("EJB Invoker is already deployed on at least one target, please edit it as you would a normal application using the create-application-ref, delete-application-ref, or update-application-ref commands");
        }
    }

    private boolean messageSecurityProviderExists(String authModule, ActionReport subActionReport, Subject subject) {
        boolean exists = false;
        CommandRunner.CommandInvocation invocation = this.commandRunner.getCommandInvocation("list-message-security-providers", subActionReport, subject, false);
        ParameterMap parameters = new ParameterMap();
        parameters.add((Object)"layer", (Object)"HttpServlet");
        invocation.parameters(parameters).execute();
        for (ActionReport.MessagePart message : subActionReport.getTopMessagePart().getChildren()) {
            if (!message.getMessage().equals(authModule)) continue;
            exists = true;
            break;
        }
        return exists;
    }

    private void createRequiredMessageSecurityProvider(String authModule, String authModuleClass, ActionReport subActionReport, Subject subject) {
        CommandRunner.CommandInvocation invocation = this.commandRunner.getCommandInvocation("create-message-security-provider", subActionReport, subject, false);
        ParameterMap parameters = new ParameterMap();
        parameters.add((Object)"classname", (Object)authModuleClass);
        parameters.add((Object)"isdefaultprovider", (Object)"false");
        parameters.add((Object)"layer", (Object)"HttpServlet");
        parameters.add((Object)"providertype", (Object)"server");
        parameters.add((Object)"target", (Object)this.target);
        parameters.add((Object)"requestauthsource", (Object)"sender");
        parameters.add((Object)"DEFAULT", (Object)authModule);
        invocation.parameters(parameters).execute();
    }

    protected boolean defaultUserExists(EjbInvokerConfiguration config, ActionReport subActionReport, Subject subject) {
        CommandRunner.CommandInvocation invocation = this.commandRunner.getCommandInvocation("list-file-users", subActionReport, subject, false);
        ParameterMap parameters = new ParameterMap();
        parameters.add((Object)"authrealmname", (Object)(StringUtils.ok((String)config.getRealmName()) ? config.getRealmName() : this.securityService.getDefaultRealm()));
        invocation.parameters(parameters).execute();
        for (ActionReport.MessagePart message : subActionReport.getTopMessagePart().getChildren()) {
            if (!message.getMessage().equals("invoker")) continue;
            return true;
        }
        return false;
    }

    protected void createDefaultUser(EjbInvokerConfiguration config, ActionReport subActionReport, Subject subject) {
        CommandRunner.CommandInvocation invocation = this.commandRunner.getCommandInvocation("create-file-user", subActionReport, subject, false);
        ParameterMap parameters = new ParameterMap();
        parameters.add((Object)"groups", (Object)config.getRoles().replace(',', ':'));
        parameters.add((Object)"userpassword", (Object)"invoker");
        parameters.add((Object)"target", (Object)this.target);
        parameters.add((Object)"authrealmname", (Object)(StringUtils.ok((String)config.getRealmName()) ? config.getRealmName() : this.securityService.getDefaultRealm()));
        parameters.add((Object)"DEFAULT", (Object)"invoker");
        invocation.parameters(parameters).execute();
    }
}

