/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.tpcengine.nio;

import com.hazelcast.internal.tpcengine.Option;
import com.hazelcast.internal.tpcengine.net.AsyncSocket;
import com.hazelcast.internal.tpcengine.net.AsyncSocketBuilder;
import com.hazelcast.internal.tpcengine.net.AsyncSocketReader;
import com.hazelcast.internal.tpcengine.nio.NioAcceptRequest;
import com.hazelcast.internal.tpcengine.nio.NioAsyncSocket;
import com.hazelcast.internal.tpcengine.nio.NioAsyncSocketOptions;
import com.hazelcast.internal.tpcengine.nio.NioReactor;
import com.hazelcast.internal.tpcengine.util.ExceptionUtil;
import com.hazelcast.internal.tpcengine.util.Preconditions;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.channels.SocketChannel;
import java.util.concurrent.CompletableFuture;

public class NioAsyncSocketBuilder
implements AsyncSocketBuilder {
    static final int DEFAULT_WRITE_QUEUE_CAPACITY = 131072;
    final NioReactor reactor;
    final SocketChannel socketChannel;
    final NioAcceptRequest acceptRequest;
    final boolean clientSide;
    boolean regularSchedule = true;
    boolean writeThrough;
    boolean receiveBufferIsDirect = true;
    int writeQueueCapacity = 131072;
    AsyncSocketReader reader;
    NioAsyncSocketOptions options;
    private boolean build;

    NioAsyncSocketBuilder(NioReactor reactor, NioAcceptRequest acceptRequest) {
        try {
            this.reactor = reactor;
            this.acceptRequest = acceptRequest;
            if (acceptRequest == null) {
                this.socketChannel = SocketChannel.open();
                this.clientSide = true;
            } else {
                this.socketChannel = acceptRequest.socketChannel;
                this.clientSide = false;
            }
            this.socketChannel.configureBlocking(false);
            this.options = new NioAsyncSocketOptions(this.socketChannel);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public <T> boolean setIfSupported(Option<T> option, T value) {
        this.verifyNotBuild();
        return this.options.setIfSupported(option, value);
    }

    public NioAsyncSocketBuilder setReceiveBufferIsDirect(boolean receiveBufferIsDirect) {
        this.verifyNotBuild();
        this.receiveBufferIsDirect = receiveBufferIsDirect;
        return this;
    }

    public NioAsyncSocketBuilder setWriteQueueCapacity(int writeQueueCapacity) {
        this.verifyNotBuild();
        this.writeQueueCapacity = Preconditions.checkPositive(writeQueueCapacity, "writeQueueCapacity");
        return this;
    }

    public NioAsyncSocketBuilder setRegularSchedule(boolean regularSchedule) {
        this.verifyNotBuild();
        this.regularSchedule = regularSchedule;
        return this;
    }

    public NioAsyncSocketBuilder setWriteThrough(boolean writeThrough) {
        this.verifyNotBuild();
        this.writeThrough = writeThrough;
        return this;
    }

    @Override
    public final NioAsyncSocketBuilder setReader(AsyncSocketReader reader) {
        this.verifyNotBuild();
        this.reader = Preconditions.checkNotNull(reader);
        return this;
    }

    @Override
    public AsyncSocket build() {
        this.verifyNotBuild();
        this.build = true;
        if (this.reader == null) {
            throw new IllegalStateException("reader is not configured.");
        }
        if (Thread.currentThread() == this.reactor.eventloopThread()) {
            return new NioAsyncSocket(this);
        }
        CompletableFuture future = new CompletableFuture();
        this.reactor.execute(() -> {
            try {
                NioAsyncSocket asyncSocket = new NioAsyncSocket(this);
                future.complete(asyncSocket);
            }
            catch (Throwable e) {
                future.completeExceptionally(e);
                throw ExceptionUtil.sneakyThrow(e);
            }
        });
        return (AsyncSocket)future.join();
    }

    private void verifyNotBuild() {
        if (this.build) {
            throw new IllegalStateException("Can't call build twice on the same AsyncSocketBuilder");
        }
    }
}

