/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.spi.impl.tenantcontrol.impl;

import com.hazelcast.core.DistributedObjectEvent;
import com.hazelcast.core.DistributedObjectListener;
import com.hazelcast.internal.cluster.ClusterVersionListener;
import com.hazelcast.internal.services.PreJoinAwareService;
import com.hazelcast.internal.util.ConcurrencyUtil;
import com.hazelcast.internal.util.ExceptionUtil;
import com.hazelcast.internal.util.InvocationUtil;
import com.hazelcast.internal.util.MapUtil;
import com.hazelcast.internal.util.ServiceLoader;
import com.hazelcast.logging.ILogger;
import com.hazelcast.spi.impl.InternalCompletableFuture;
import com.hazelcast.spi.impl.NodeEngineImpl;
import com.hazelcast.spi.impl.tenantcontrol.impl.TenantControlReplicationOperation;
import com.hazelcast.spi.tenantcontrol.TenantControl;
import com.hazelcast.spi.tenantcontrol.TenantControlFactory;
import com.hazelcast.version.Version;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class TenantControlServiceImpl
implements ClusterVersionListener,
DistributedObjectListener,
PreJoinAwareService<TenantControlReplicationOperation> {
    public static final String SERVICE_NAME = "hz:impl:tenantControlService";
    private static final int MAX_RETRIES = 100;
    private static final String TENANT_CONTROL_FACTORY = "com.hazelcast.spi.tenantcontrol.TenantControlFactory";
    private final TenantControlFactory tenantControlFactory;
    private final NodeEngineImpl nodeEngine;
    private final ILogger logger;
    private final ConcurrentMap<String, ConcurrentMap<String, TenantControl>> tenantControlMap = MapUtil.createConcurrentHashMap(1);

    public TenantControlServiceImpl(NodeEngineImpl nodeEngine) {
        this.nodeEngine = nodeEngine;
        this.logger = nodeEngine.getLogger(TenantControlServiceImpl.class.getName());
        this.tenantControlFactory = this.initTenantControlFactory(nodeEngine.getConfigClassLoader());
        nodeEngine.getProxyService().addProxyListener(this);
    }

    @Nullable
    public TenantControl getTenantControl(@Nonnull String serviceName, @Nonnull String objectName) {
        if (!this.isTenantControlEnabled()) {
            return TenantControl.NOOP_TENANT_CONTROL;
        }
        ConcurrentMap objectTenantControl = (ConcurrentMap)this.tenantControlMap.get(serviceName);
        return objectTenantControl != null ? (TenantControl)objectTenantControl.get(objectName) : null;
    }

    public void appendTenantControl(@Nonnull String serviceName, @Nonnull String objectName, @Nonnull TenantControl tenantControl) {
        this.tenantControlMap.computeIfAbsent(serviceName, name -> new ConcurrentHashMap()).putIfAbsent(objectName, tenantControl);
    }

    public TenantControlFactory getTenantControlFactory() {
        return this.tenantControlFactory;
    }

    public TenantControl initializeTenantControl(@Nonnull String serviceName, @Nonnull String objectName) {
        if (!this.isTenantControlEnabled()) {
            return TenantControl.NOOP_TENANT_CONTROL;
        }
        TenantControl tenantControl = this.tenantControlFactory.saveCurrentTenant();
        this.appendTenantControl(serviceName, objectName, tenantControl);
        try {
            InvocationUtil.invokeOnStableClusterSerial(this.nodeEngine, () -> new TenantControlReplicationOperation(serviceName, objectName, tenantControl), 100).get();
        }
        catch (Throwable t) {
            throw ExceptionUtil.rethrow(t);
        }
        return tenantControl;
    }

    @Override
    public void onClusterVersionChange(Version newVersion) {
        if (this.isTenantControlEnabled()) {
            InternalCompletableFuture future = InvocationUtil.invokeOnStableClusterSerial(this.nodeEngine, () -> new TenantControlReplicationOperation(this.tenantControlMap), 100);
            future.whenCompleteAsync((v, t) -> {
                if (t != null) {
                    this.logger.warning("Failed to propagate tenant control", (Throwable)t);
                }
            }, ConcurrencyUtil.CALLER_RUNS);
        }
    }

    @Override
    public void distributedObjectCreated(DistributedObjectEvent event) {
    }

    @Override
    public void distributedObjectDestroyed(DistributedObjectEvent event) {
        ConcurrentMap serviceMap = (ConcurrentMap)this.tenantControlMap.get(event.getServiceName());
        if (serviceMap == null) {
            return;
        }
        TenantControl tc = (TenantControl)serviceMap.remove(event.getObjectName().toString());
        if (tc == null) {
            return;
        }
        tc.unregisterObject();
    }

    private TenantControlFactory initTenantControlFactory(ClassLoader configClassLoader) {
        TenantControlFactory factory;
        block2: {
            factory = null;
            try {
                factory = ServiceLoader.load(TenantControlFactory.class, TENANT_CONTROL_FACTORY, configClassLoader);
            }
            catch (Exception e) {
                if (!this.logger.isFinestEnabled()) break block2;
                this.logger.finest("Could not load service provider for TenantControl", e);
            }
        }
        return factory != null ? factory : TenantControlFactory.NOOP_TENANT_CONTROL_FACTORY;
    }

    private boolean isTenantControlEnabled() {
        return this.tenantControlFactory != TenantControlFactory.NOOP_TENANT_CONTROL_FACTORY;
    }

    @Override
    public TenantControlReplicationOperation getPreJoinOperation() {
        return this.isTenantControlEnabled() ? new TenantControlReplicationOperation(this.tenantControlMap) : null;
    }
}

