/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.loader;

import com.sun.enterprise.loader.ItemChecker;
import com.sun.enterprise.loader.WatchProcessor;
import com.sun.enterprise.util.CULoggerInfo;
import java.io.IOException;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;

class DirWatcher {
    private static final Map<FileSystem, DirWatcher> PER_FS = new ConcurrentHashMap<FileSystem, DirWatcher>();
    private static final Logger LOGGER = CULoggerInfo.getLogger();
    private final WatchService watchService;
    private Map<Path, WatchProcessor> processors = new ConcurrentHashMap<Path, WatchProcessor>();

    static boolean hasItem(Path parent, String item) {
        return DirWatcher.forPath(parent).hasFilesystemItem(parent, item);
    }

    static void register(Path path) throws IOException {
        DirWatcher.forPath(path).registerInFilesystem(path);
    }

    static void unregister(Path path) {
        DirWatcher.forPath(path).unregisterFromFilesystem(path);
    }

    private static DirWatcher forPath(Path path) {
        return PER_FS.computeIfAbsent(path.getFileSystem(), DirWatcher::new);
    }

    private DirWatcher(FileSystem fileSystem) {
        try {
            this.watchService = fileSystem.newWatchService();
        }
        catch (IOException | UnsupportedOperationException e) {
            throw new IllegalArgumentException("Filesystem WatchService is unavailable", e);
        }
    }

    private void registerInFilesystem(Path path) throws IOException {
        if (Files.notExists(path, new LinkOption[0])) {
            WatchProcessor watcher2;
            this.processors.compute(path, (p, watcher) -> watcher == null ? ItemChecker.registerNonExisting(p, this.watchService) : watcher.subscribe());
            do {
                path = path.getParent();
                watcher2 = this.processors.computeIfAbsent(path, p -> new ParentWatcher((Path)p, this.watchService));
            } while (!watcher2.registered && !Files.exists(path, new LinkOption[0]));
            watcher2.register();
        } else {
            this.processors.compute(path, (p, watcher) -> watcher == null ? ItemChecker.registerExisting(p, this.watchService) : watcher.subscribe());
        }
    }

    private boolean hasFilesystemItem(Path parent, String item) {
        this.syncWatches();
        WatchProcessor checker = this.processors.get(parent);
        if (checker == null || !(checker instanceof ItemChecker)) {
            LOGGER.info(() -> "Watch service attempted to get checker for untracked item " + parent.toAbsolutePath());
            return true;
        }
        return ((ItemChecker)checker).hasItem(item);
    }

    private synchronized void syncWatches() {
        WatchKey key;
        while ((key = this.watchService.poll()) != null) {
            Path root = (Path)key.watchable();
            WatchProcessor processor = this.processors.get(root);
            if (processor == null || processor.isCancelled()) {
                key.cancel();
                continue;
            }
            for (WatchEvent<?> event : key.pollEvents()) {
                WatchEvent.Kind<?> kind = event.kind();
                boolean keepRegistered = true;
                if (kind == StandardWatchEventKinds.OVERFLOW) {
                    LOGGER.warning(() -> "File system watcher overflowed for " + root);
                    keepRegistered = processor.overflowed();
                } else {
                    WatchEvent<?> ev = event;
                    Path filename = (Path)ev.context();
                    if (kind == StandardWatchEventKinds.ENTRY_CREATE) {
                        keepRegistered = processor.created(filename);
                    }
                    if (kind == StandardWatchEventKinds.ENTRY_DELETE) {
                        keepRegistered = processor.deleted(filename);
                    }
                }
                if (keepRegistered) continue;
                key.cancel();
            }
            boolean valid = key.reset();
            if (valid) continue;
            processor.cancelled();
        }
        return;
    }

    private void unregisterFromFilesystem(Path path) {
        WatchProcessor processor = this.processors.get(path);
        if (processor != null && processor.unsubscribe()) {
            processor.cancelled();
            this.processors.remove(path);
        }
    }

    class ParentWatcher
    extends WatchProcessor {
        ParentWatcher(Path p, WatchService watchService) {
            super(p, watchService);
        }

        @Override
        protected void register() {
            super.register();
            try (Stream<Path> stream = Files.list(this.root);){
                stream.forEach(this::registerSubProcessor);
            }
            catch (IOException e) {
                LOGGER.log(Level.INFO, "Error when listing directory", e);
            }
        }

        @Override
        protected boolean created(Path filename) {
            LOGGER.fine(() -> "In parent directory " + this.root + ": created " + filename);
            Path path = this.root.resolve(filename);
            this.registerSubProcessor(path);
            return true;
        }

        private void registerSubProcessor(Path path) {
            WatchProcessor processor;
            if (Files.isDirectory(path, new LinkOption[0]) && (processor = DirWatcher.this.processors.get(path)) != null) {
                processor.register();
            }
        }
    }
}

