/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.universal;

import com.sun.enterprise.universal.Duration;

public final class NanoDuration {
    private static final double NSEC_PER_MICROSECOND = 1000.0;
    private static final double NSEC_PER_MILLISECOND = 1000000.0;
    private static final double NSEC_PER_SECOND = 1.0E9;
    private static final double NSEC_PER_MINUTE = 6.0E10;
    private double numSeconds = -1.0;
    private double numMilliSeconds = -1.0;
    private double numMicroSeconds = -1.0;
    private double numNanoSeconds = -1.0;
    private Duration duration;

    public NanoDuration(long nsec) {
        if ((double)nsec >= 6.0E10) {
            this.duration = new Duration(nsec / 1000000L);
            return;
        }
        if ((double)nsec >= 1.0E9) {
            this.numSeconds = (double)nsec / 1.0E9;
        } else if ((double)nsec >= 1000000.0) {
            this.numMilliSeconds = (double)nsec / 1000000.0;
        } else if ((double)nsec >= 1000.0) {
            this.numMicroSeconds = (double)nsec / 1000.0;
        } else {
            this.numNanoSeconds = nsec;
        }
    }

    public String toString() {
        if (this.duration != null) {
            return this.duration.toString();
        }
        String fmt = "%.2f %s";
        String s = this.numSeconds > 0.0 ? String.format("%.2f %s", this.numSeconds, "seconds") : (this.numMilliSeconds > 0.0 ? String.format("%.2f %s", this.numMilliSeconds, "msec") : (this.numMicroSeconds > 0.0 ? String.format("%.2f %s", this.numMicroSeconds, "usec") : (this.numNanoSeconds > 0.0 ? String.format("%.2f %s", this.numNanoSeconds, "nsec") : String.format("%.2f %s", 0.0, "nsec"))));
        return s;
    }
}

