/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.auth.realm;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;

public class GroupMapper {
    private Map<String, List<String>> groupMappingTable = new HashMap<String, List<String>>();

    public void parse(String mappingStr) {
        StringTokenizer tokenizer = new StringTokenizer(mappingStr, ";");
        while (tokenizer.hasMoreElements()) {
            String mapping = tokenizer.nextToken();
            String[] mappingGroups = mapping.split(",");
            String mappedGroup = null;
            int indexOfArrow = mapping.indexOf("->");
            if (indexOfArrow > 0 && mappingGroups != null && mappingGroups.length > 0) {
                String tmpGroup = mapping.substring(indexOfArrow + 2);
                mappedGroup = tmpGroup.trim();
            }
            this.validate(mappedGroup, mappingGroups);
            for (String grp : mappingGroups) {
                int aIndex = grp.indexOf("->");
                String theGroup = aIndex > 0 ? grp.substring(0, aIndex).trim() : grp.trim();
                List<String> mappedGroupList = this.groupMappingTable.get(theGroup);
                if (mappedGroupList == null) {
                    mappedGroupList = new ArrayList<String>();
                }
                mappedGroupList.add(mappedGroup);
                this.groupMappingTable.put(theGroup, mappedGroupList);
            }
        }
    }

    public void getMappedGroups(String group, List<String> result) {
        if (result == null) {
            throw new RuntimeException("result argument cannot be NULL");
        }
        List<String> mappedGrps = this.groupMappingTable.get(group);
        if (mappedGrps == null || mappedGrps.isEmpty()) {
            return;
        }
        this.addUnique(result, mappedGrps);
        ArrayList<String> result1 = new ArrayList<String>();
        for (String str : mappedGrps) {
            this.getMappedGroups(group, str, result1);
        }
        this.addUnique(result, result1);
    }

    private void addUnique(List<String> dest, List<String> src) {
        for (String str : src) {
            if (dest.contains(str)) continue;
            dest.add(str);
        }
    }

    private void getMappedGroups(String group, String str, List<String> result) {
        List<String> mappedGrps = this.groupMappingTable.get(str);
        if (mappedGrps == null || mappedGrps.isEmpty()) {
            return;
        }
        if (mappedGrps.contains(group)) {
            throw new RuntimeException("Illegal Mapping: cycle detected with group'" + group);
        }
        this.addUnique(result, mappedGrps);
        for (String str1 : mappedGrps) {
            this.getMappedGroups(group, str1, result);
        }
    }

    private void validate(String mappedGroup, String[] mappingGroups) {
        for (String str : mappingGroups) {
            String theGroup;
            int aIndex = str.indexOf("->");
            String string = theGroup = aIndex > 0 ? str.substring(0, aIndex) : str;
            if (!theGroup.equals(mappedGroup)) continue;
            throw new RuntimeException("Illegal Mapping: Identity Mapping of group '" + theGroup + "' to '" + theGroup + "'");
        }
    }
}

