/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.ssl;

import com.sun.enterprise.security.SecurityLoggerInfo;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import org.glassfish.grizzly.ssl.SSLSupport;

public class GlassfishSSLSupport
implements SSLSupport {
    private static final Logger logger = SecurityLoggerInfo.getLogger();
    private static final SSLSupport.CipherData[] ciphers = new SSLSupport.CipherData[]{new SSLSupport.CipherData("_WITH_NULL_", 0), new SSLSupport.CipherData("_WITH_IDEA_CBC_", 128), new SSLSupport.CipherData("_WITH_RC2_CBC_40_", 40), new SSLSupport.CipherData("_WITH_RC4_40_", 40), new SSLSupport.CipherData("_WITH_RC4_128_", 128), new SSLSupport.CipherData("_WITH_DES40_CBC_", 40), new SSLSupport.CipherData("_WITH_DES_CBC_", 56), new SSLSupport.CipherData("_WITH_3DES_EDE_CBC_", 168), new SSLSupport.CipherData("_WITH_AES_128_", 128), new SSLSupport.CipherData("_WITH_AES_256_", 256)};
    private final SSLSocket socket;
    private final SSLEngine engine;
    private SSLSession session;

    public GlassfishSSLSupport(SSLSocket socket) {
        this.socket = socket;
        this.engine = null;
        this.session = socket.getSession();
    }

    public GlassfishSSLSupport(SSLEngine engine) {
        this.socket = null;
        this.engine = engine;
        if (engine != null) {
            this.session = engine.getSession();
        }
    }

    public String getCipherSuite() throws IOException {
        if (this.session == null) {
            return null;
        }
        return this.session.getCipherSuite();
    }

    public Certificate[] getPeerCertificates() throws IOException {
        return this.getPeerCertificates(false);
    }

    public Certificate[] getPeerCertificates(boolean force) throws IOException {
        if (this.session == null) {
            return null;
        }
        Certificate[] certs = null;
        certs = this.session.getPeerCertificates();
        if (certs == null) {
            certs = new X509Certificate[]{};
        }
        if (certs.length == 0 && force) {
            this.session.invalidate();
            this.handshake();
            this.session = this.socket == null ? this.engine.getSession() : this.socket.getSession();
        }
        return this.getX509Certs();
    }

    public Integer getKeySize() throws IOException {
        if (this.session == null) {
            return null;
        }
        Integer keySize = (Integer)this.session.getValue("jakarta.servlet.request.key_size");
        if (keySize == null) {
            int size = 0;
            String cipherSuite = this.session.getCipherSuite();
            for (SSLSupport.CipherData cipher : ciphers) {
                if (!cipherSuite.contains(cipher.phrase)) continue;
                size = cipher.keySize;
                break;
            }
            keySize = size;
            this.session.putValue("jakarta.servlet.request.key_size", keySize);
        }
        return keySize;
    }

    public String getSessionId() throws IOException {
        if (this.session == null) {
            return null;
        }
        byte[] sessionId = this.session.getId();
        if (sessionId == null) {
            return null;
        }
        StringBuilder Id = new StringBuilder();
        for (byte b : sessionId) {
            String digit = Integer.toHexString(b);
            if (digit.length() < 2) {
                Id.append('0');
            } else if (digit.length() > 2) {
                digit = digit.substring(digit.length() - 2);
            }
            Id.append(digit);
        }
        return Id.toString();
    }

    private void handshake() throws IOException {
        this.socket.setNeedClientAuth(true);
        this.socket.startHandshake();
    }

    private Certificate[] getX509Certs() {
        Certificate[] certs = null;
        try {
            certs = this.session.getPeerCertificates();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (certs == null) {
            certs = new X509Certificate[]{};
        }
        Certificate[] x509Certs = new X509Certificate[certs.length];
        for (int i = 0; i < x509Certs.length; ++i) {
            try {
                byte[] buffer = certs[i].getEncoded();
                CertificateFactory cf = CertificateFactory.getInstance("X.509");
                ByteArrayInputStream stream = new ByteArrayInputStream(buffer);
                x509Certs[i] = (X509Certificate)cf.generateCertificate(stream);
                if (!logger.isLoggable(Level.FINEST)) continue;
                logger.log(Level.FINE, "Cert #{0} = {1}", new Object[]{i, x509Certs[i]});
                continue;
            }
            catch (Exception ex) {
                logger.log(Level.INFO, "NCLS-SECURITY-05056", new Object[]{certs[i], ex.toString()});
                return null;
            }
        }
        if (x509Certs.length < 1) {
            return null;
        }
        return x509Certs;
    }
}

