/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.web.ha.authenticator;

import com.sun.enterprise.container.common.spi.util.JavaEEIOUtils;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.security.Principal;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.catalina.Container;
import org.apache.catalina.Session;
import org.apache.catalina.authenticator.SingleSignOn;
import org.apache.catalina.authenticator.SingleSignOnEntry;
import org.apache.catalina.core.StandardContext;
import org.glassfish.web.ha.LogFacade;
import org.glassfish.web.ha.authenticator.HASessionData;
import org.glassfish.web.ha.authenticator.HASingleSignOnEntryMetadata;

public class HASingleSignOnEntry
extends SingleSignOnEntry {
    private static final Logger logger = LogFacade.getLogger();
    protected long maxIdleTime;
    protected JavaEEIOUtils ioUtils;
    protected HASingleSignOnEntryMetadata metadata = null;

    public HASingleSignOnEntry() {
        this(null, null, null, null, null, 0L, 0L, 0L, null);
    }

    public HASingleSignOnEntry(Container container, HASingleSignOnEntryMetadata m, JavaEEIOUtils ioUtils) {
        this(m.getId(), null, m.getAuthType(), m.getUserName(), m.getRealmName(), m.getLastAccessTime(), m.getMaxIdleTime(), m.getVersion(), ioUtils);
        this.principal = this.parsePrincipal(m);
        this.metadata.principalBytes = m.getPrincipalBytes() == null ? null : (byte[])m.getPrincipalBytes().clone();
        for (HASessionData data : m.getHASessionDataSet()) {
            StandardContext context = (StandardContext)container.findChild(data.getContextPath());
            Session session = null;
            try {
                session = context.getManager().findSession(data.getSessionId());
            }
            catch (IOException ex) {
                throw new IllegalStateException("Cannot find the session: " + data.getSessionId(), ex);
            }
            if (session == null) continue;
            this.sessions.put(data.getSessionId(), session);
        }
        logger.log(Level.FINER, "Loaded HA SSO entry from metadata. Principal: {}", this.principal);
    }

    public HASingleSignOnEntry(String id, Principal principal, String authType, String username, String realmName, long lastAccessTime, long maxIdleTime, long version, JavaEEIOUtils ioUtils) {
        super(id, version, principal, authType, username, realmName);
        this.lastAccessTime = lastAccessTime;
        this.maxIdleTime = maxIdleTime;
        this.ioUtils = ioUtils;
        this.metadata = new HASingleSignOnEntryMetadata(id, version, this.convertToByteArray(principal), authType, username, realmName, lastAccessTime, maxIdleTime);
        logger.log(Level.FINER, "Created HA SSO entry. Principal: {}", this.principal);
    }

    public HASingleSignOnEntryMetadata getMetadata() {
        return this.metadata;
    }

    public long getMaxIdleTime() {
        return this.maxIdleTime;
    }

    public synchronized boolean addSession(SingleSignOn sso, Session session) {
        boolean result = super.addSession(sso, session);
        if (result) {
            this.metadata.addHASessionData(new HASessionData(session.getId(), session.getManager().getContainer().getName()));
        }
        return result;
    }

    public synchronized void removeSession(Session session) {
        super.removeSession(session);
        this.metadata.removeHASessionData(new HASessionData(session.getId(), session.getManager().getContainer().getName()));
    }

    public void setLastAccessTime(long lastAccessTime) {
        super.setLastAccessTime(lastAccessTime);
        this.metadata.setLastAccessTime(lastAccessTime);
    }

    public long incrementAndGetVersion() {
        long ver = super.incrementAndGetVersion();
        this.metadata.setVersion(ver);
        return ver;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private byte[] convertToByteArray(Principal obj) {
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            byte[] byArray;
            block13: {
                ObjectOutputStream oos = this.ioUtils.createObjectOutputStream((OutputStream)baos, true);
                try {
                    oos.writeObject(obj);
                    oos.flush();
                    byArray = baos.toByteArray();
                    if (oos == null) break block13;
                }
                catch (Throwable throwable) {
                    if (oos != null) {
                        try {
                            oos.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                oos.close();
            }
            return byArray;
        }
        catch (Exception ex) {
            throw new IllegalStateException("Could not convert principal to byte array", ex);
        }
    }

    private Principal parsePrincipal(HASingleSignOnEntryMetadata m) {
        Principal principal;
        block8: {
            ObjectInputStream ois = this.ioUtils.createObjectInputStream((InputStream)new BufferedInputStream(new ByteArrayInputStream(m.getPrincipalBytes())), true, ((Object)((Object)this)).getClass().getClassLoader(), 0L);
            try {
                principal = (Principal)ois.readObject();
                if (ois == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (ois != null) {
                        try {
                            ois.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception ex) {
                    throw new IllegalStateException("Could not parse principal from HA-SSO Metadata", ex);
                }
            }
            ois.close();
        }
        return principal;
    }
}

