/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.monitoring.internal.data;

import fish.payara.monitoring.adapt.MonitoringConsoleRuntime;
import fish.payara.monitoring.collect.MonitoringData;
import fish.payara.monitoring.collect.MonitoringDataCollector;
import fish.payara.monitoring.collect.MonitoringDataSource;
import fish.payara.monitoring.data.ConsumingMonitoringDataCollector;
import fish.payara.monitoring.data.MonitoringAnnotationConsumer;
import fish.payara.monitoring.data.MonitoringDataConsumer;
import fish.payara.monitoring.data.SeriesRepository;
import fish.payara.monitoring.internal.util.JobHandle;
import fish.payara.monitoring.model.EmptyDataset;
import fish.payara.monitoring.model.Series;
import fish.payara.monitoring.model.SeriesAnnotation;
import fish.payara.monitoring.model.SeriesAnnotations;
import fish.payara.monitoring.model.SeriesDataset;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;

public class InMemorySeriesRepository
implements SeriesRepository {
    private static final Logger LOGGER = Logger.getLogger("monitoring-console-core");
    private static final int MAX_ANNOTATIONS_PER_SERIES = 20;
    private final Set<String> sourcesFailingBefore = ConcurrentHashMap.newKeySet();
    private final String instanceName;
    private final boolean isDas;
    private final MonitoringConsoleRuntime runtime;
    private final Supplier<? extends List<MonitoringDataSource>> sources;
    private volatile Map<Series, SeriesDataset> secondsWrite = new ConcurrentHashMap<Series, SeriesDataset>();
    private volatile Map<Series, SeriesDataset> secondsRead = new ConcurrentHashMap<Series, SeriesDataset>();
    private final Map<Series, SeriesDataset[]> remoteInstanceDatasets = new ConcurrentHashMap<Series, SeriesDataset[]>();
    private final Map<Series, SeriesAnnotations> annotationsBySeries = new ConcurrentHashMap<Series, SeriesAnnotations>();
    private final Set<String> instances = ConcurrentHashMap.newKeySet();
    private final JobHandle dataCollectionJob = new JobHandle("monitoring data collection");
    private long collectedSecond;
    private int estimatedNumberOfSeries = 50;
    private final AtomicBoolean aggregate = new AtomicBoolean();

    public InMemorySeriesRepository(String instanceName, boolean receiver, MonitoringConsoleRuntime runtime, Supplier<? extends List<MonitoringDataSource>> sources) {
        this.isDas = receiver;
        this.instanceName = instanceName;
        this.runtime = runtime;
        this.sources = sources;
        this.instances.add(instanceName);
    }

    public void setEnabled(boolean enabled) {
        if (!enabled) {
            this.dataCollectionJob.stop();
        } else {
            LOGGER.info("Starting monitoring data collection for " + this.instanceName);
            this.dataCollectionJob.start(this.runtime, 1, TimeUnit.SECONDS, this.isDas ? this::collectSourcesToMemory : this::collectSourcesToPublish);
        }
    }

    public void setHistoryEnabled(boolean enabled) {
        this.aggregate.set(enabled);
    }

    @Override
    public Set<String> instances() {
        return this.instances;
    }

    public void addRemoteDatasets(SeriesDatasetsSnapshot snapshot) {
        String instance = snapshot.instance;
        this.instances.add(instance);
        long time = snapshot.time;
        if (snapshot.annotations != null) {
            for (SeriesAnnotation a : snapshot.annotations) {
                this.addRemoteAnnotation(a);
            }
        }
        boolean aggregate = this.aggregate.get();
        for (int i = 0; i < snapshot.numberOfSeries; ++i) {
            Series series = null;
            try {
                series = new Series(snapshot.series[i]);
            }
            catch (IllegalArgumentException ex) {
                LOGGER.log(Level.FINEST, "Failed to add remote series: " + snapshot.series[i], ex);
            }
            if (series == null) continue;
            long value = snapshot.values[i];
            this.remoteInstanceDatasets.compute(series, (key, seriesByInstance) -> InMemorySeriesRepository.addRemotePoint(seriesByInstance, instance, key, time, value, aggregate));
        }
    }

    private static SeriesDataset[] addRemotePoint(SeriesDataset[] seriesByInstance, String instance, Series series, long time, long value, boolean aggregate) {
        if (seriesByInstance == null) {
            return new SeriesDataset[]{new EmptyDataset(instance, series, 60).add(time, value)};
        }
        for (int i = 0; i < seriesByInstance.length; ++i) {
            SeriesDataset instanceSet = seriesByInstance[i];
            if (!instanceSet.getInstance().equals(instance)) continue;
            seriesByInstance[i] = seriesByInstance[i].add(time, value, aggregate);
            return seriesByInstance;
        }
        seriesByInstance = Arrays.copyOf(seriesByInstance, seriesByInstance.length + 1);
        seriesByInstance[seriesByInstance.length - 1] = new EmptyDataset(instance, series, 60).add(time, value, aggregate);
        return seriesByInstance;
    }

    private void collectSourcesToMemory() {
        this.tick();
        for (Map.Entry<Series, SeriesDataset> e : this.secondsRead.entrySet()) {
            this.secondsWrite.put(e.getKey(), e.getValue());
        }
        this.collectAll(new ConsumingMonitoringDataCollector(this::addLocalPoint, this::addLocalAnnotation));
        this.swapLocalBuffer();
    }

    private void collectSourcesToPublish() {
        this.tick();
        SeriesDatasetsSnapshot msg = new SeriesDatasetsSnapshot(this.instanceName, this.collectedSecond, this.estimatedNumberOfSeries);
        this.collectAll(new ConsumingMonitoringDataCollector(msg, msg));
        this.estimatedNumberOfSeries = msg.numberOfSeries;
        this.sendMessage(msg);
    }

    private void sendMessage(SeriesDatasetsSnapshot msg) {
        try (ByteArrayOutputStream bos = new ByteArrayOutputStream();
             ObjectOutputStream oos = new ObjectOutputStream(bos);){
            oos.writeObject(msg);
            oos.flush();
            this.runtime.send(bos.toByteArray());
        }
        catch (IOException ex) {
            LOGGER.log(Level.FINE, "Failed to send monitoring data message", ex);
        }
    }

    private void collectAll(MonitoringDataCollector collector) {
        long collectionStart = System.currentTimeMillis();
        int collectedSources = 0;
        int failedSources = 0;
        long second = this.collectedSecond / 1000L;
        MonitoringDataCollector monitoringCollector = collector.in((CharSequence)"monitoring");
        for (MonitoringDataSource source : this.sources.get()) {
            String sourceId = source.getClass().getSimpleName();
            MonitoringData meta = InMemorySeriesRepository.getMetaAnnotation(source);
            if (!InMemorySeriesRepository.collectNow(second, meta)) continue;
            try {
                ++collectedSources;
                long sourceStart = System.currentTimeMillis();
                source.collect(meta == null ? collector : collector.in((CharSequence)meta.ns()));
                this.sourcesFailingBefore.remove(sourceId);
                monitoringCollector.group((CharSequence)sourceId).collect((CharSequence)"CollectionDuration", System.currentTimeMillis() - sourceStart);
            }
            catch (RuntimeException e) {
                if (!this.sourcesFailingBefore.contains(sourceId)) {
                    LOGGER.log(Level.FINE, "Error collecting metrics", e);
                }
                ++failedSources;
                this.sourcesFailingBefore.add(sourceId);
            }
        }
        long estimatedTotalBytesMemory = 0L;
        for (SeriesDataset set : this.secondsWrite.values()) {
            estimatedTotalBytesMemory += (long)set.estimatedBytesMemory();
        }
        int seriesCount = this.secondsWrite.size();
        monitoringCollector.collect((CharSequence)"CollectionDuration", System.currentTimeMillis() - collectionStart).collectNonZero((CharSequence)"SeriesCount", (long)seriesCount).collectNonZero((CharSequence)"TotalBytesMemory", estimatedTotalBytesMemory).collectNonZero((CharSequence)"AverageBytesMemoryPerSeries", seriesCount == 0 ? 0L : estimatedTotalBytesMemory / (long)seriesCount).collect((CharSequence)"CollectedSourcesCount", (long)collectedSources).collect((CharSequence)"CollectedSourcesErrorCount", (long)failedSources);
    }

    private static boolean collectNow(long now, MonitoringData meta) {
        return meta == null || now % (long)meta.intervalSeconds() == 0L;
    }

    private static MonitoringData getMetaAnnotation(MonitoringDataSource source) {
        try {
            Method collect = source.getClass().getMethod("collect", MonitoringDataCollector.class);
            return collect.getAnnotation(MonitoringData.class);
        }
        catch (NoSuchMethodException | SecurityException e) {
            return null;
        }
    }

    private void tick() {
        this.collectedSecond = System.currentTimeMillis() / 1000L * 1000L;
    }

    private void swapLocalBuffer() {
        Map<Series, SeriesDataset> tmp = this.secondsRead;
        this.secondsRead = this.secondsWrite;
        this.secondsWrite = tmp;
    }

    private void addLocalPoint(CharSequence key, long value) {
        Series series = InMemorySeriesRepository.seriesOrNull(key);
        if (series != null) {
            this.secondsWrite.compute(series, (s, dataset) -> dataset == null ? this.emptySet((Series)s).add(this.collectedSecond, value, this.aggregate.get()) : dataset.add(this.collectedSecond, value, this.aggregate.get()));
        }
    }

    private void addLocalAnnotation(CharSequence series, long value, boolean keyed, String[] annotations) {
        Series s = InMemorySeriesRepository.seriesOrNull(series);
        if (s != null) {
            this.addLocalAnnotation(new SeriesAnnotation(this.collectedSecond, s, this.instanceName, value, keyed, annotations));
        }
    }

    private void addLocalAnnotation(SeriesAnnotation annotation) {
        if (annotation.getValue() == 0L && !this.secondsRead.containsKey(annotation.getSeries())) {
            this.addAnnotation(annotation.permanent());
            return;
        }
        this.addAnnotation(annotation);
    }

    private void addRemoteAnnotation(SeriesAnnotation annotation) {
        if (annotation.getValue() == 0L && !InMemorySeriesRepository.instanceSetExists(this.remoteInstanceDatasets.get(annotation.getSeries()), annotation.getInstance())) {
            this.addAnnotation(annotation.permanent());
            return;
        }
        this.addAnnotation(annotation);
    }

    private static boolean instanceSetExists(SeriesDataset[] sets, String instance) {
        if (sets == null) {
            return false;
        }
        for (SeriesDataset remoteSet : sets) {
            if (!remoteSet.getInstance().equals(instance)) continue;
            return true;
        }
        return false;
    }

    private void addAnnotation(SeriesAnnotation annotation) {
        this.annotationsBySeries.computeIfAbsent(annotation.getSeries(), key -> new SeriesAnnotations(20)).add(annotation);
    }

    static Series seriesOrNull(CharSequence key) {
        try {
            return new Series(key.toString());
        }
        catch (Exception ex) {
            LOGGER.log(Level.FINEST, "Failed to create local series: " + key, ex);
            return null;
        }
    }

    private SeriesDataset emptySet(Series series) {
        return new EmptyDataset(this.instanceName, series, 60);
    }

    @Override
    public List<SeriesAnnotation> selectAnnotations(Series series, String ... instances) {
        if (!this.isDas) {
            return Collections.emptyList();
        }
        if (series.isPattern()) {
            return this.selectAnnotationsForPattern(series, instances);
        }
        SeriesAnnotations annotations = this.annotationsBySeries.get(series);
        if (annotations == null || annotations.isEmpty()) {
            return Collections.emptyList();
        }
        if (instances == null || instances.length == 0) {
            return annotations.toList();
        }
        HashSet<String> filter = new HashSet<String>(Arrays.asList(instances));
        return annotations.stream().filter(a -> filter.contains(a.getInstance())).collect(Collectors.toList());
    }

    private List<SeriesAnnotation> selectAnnotationsForPattern(Series pattern, String ... instances) {
        ArrayList<SeriesAnnotation> matches = new ArrayList<SeriesAnnotation>();
        Set<String> filter = this.createInstanceFilter(instances);
        for (Map.Entry<Series, SeriesAnnotations> entry : this.annotationsBySeries.entrySet()) {
            if (!pattern.matches(entry.getKey())) continue;
            for (SeriesAnnotation a : entry.getValue()) {
                if (!filter.contains(a.getInstance())) continue;
                matches.add(a);
            }
        }
        return matches;
    }

    @Override
    public List<SeriesDataset> selectSeries(Series series, String ... instances) {
        if (!this.isDas) {
            return Collections.emptyList();
        }
        ArrayList<SeriesDataset> res = new ArrayList<SeriesDataset>();
        this.selectSeries(res, Collections.singleton(series), this.createInstanceFilter(instances));
        return res;
    }

    public Set<String> createInstanceFilter(String ... instances) {
        return instances == null || instances.length == 0 ? this.instances : new HashSet<String>(Arrays.asList(instances));
    }

    private void selectSeries(List<SeriesDataset> res, Set<Series> seriesSet, Set<String> instanceFilter) {
        for (Series series : seriesSet) {
            if (series.isPattern()) {
                this.selectSeries(res, this.seriesMatchingPattern(series), instanceFilter);
                continue;
            }
            SeriesDataset localSet = this.secondsRead.get(series);
            SeriesDataset[] remoteSets = this.remoteInstanceDatasets.get(series);
            if (localSet != null && InMemorySeriesRepository.isRelevantSet(localSet, instanceFilter)) {
                res.add(localSet);
            }
            if (remoteSets == null || remoteSets.length <= 0) continue;
            for (SeriesDataset remoteSet : remoteSets) {
                if (!InMemorySeriesRepository.isRelevantSet(remoteSet, instanceFilter)) continue;
                res.add(remoteSet);
            }
        }
    }

    private static boolean isRelevantSet(SeriesDataset set, Set<String> instanceFilter) {
        return instanceFilter.contains(set.getInstance());
    }

    private Set<Series> seriesMatchingPattern(Series pattern) {
        HashSet<Series> matches = new HashSet<Series>();
        for (Series candidate : this.secondsRead.keySet()) {
            if (!pattern.matches(candidate)) continue;
            matches.add(candidate);
        }
        for (Series candidate : this.remoteInstanceDatasets.keySet()) {
            if (!pattern.matches(candidate)) continue;
            matches.add(candidate);
        }
        return matches;
    }

    @Override
    public Iterable<SeriesDataset> selectAllSeries() {
        return this.secondsRead.values();
    }

    public static final class SeriesDatasetsSnapshot
    implements Serializable,
    MonitoringDataConsumer,
    MonitoringAnnotationConsumer {
        final String instance;
        final long time;
        int numberOfSeries;
        String[] series;
        long[] values;
        ArrayList<SeriesAnnotation> annotations;

        SeriesDatasetsSnapshot(String instance, long time, int estimatedNumberOfSeries) {
            this.instance = instance;
            this.time = time;
            this.series = new String[estimatedNumberOfSeries];
            this.values = new long[estimatedNumberOfSeries];
        }

        @Override
        public void accept(CharSequence series, long value) {
            if (this.numberOfSeries >= this.series.length) {
                this.series = Arrays.copyOf(this.series, Math.round((float)this.series.length * 1.3f));
                this.values = Arrays.copyOf(this.values, this.series.length);
            }
            this.series[this.numberOfSeries] = series.toString();
            this.values[this.numberOfSeries++] = value;
        }

        @Override
        public void accept(CharSequence series, long value, boolean keyed, String[] attrs) {
            Series s;
            if (this.annotations == null) {
                this.annotations = new ArrayList();
            }
            if ((s = InMemorySeriesRepository.seriesOrNull(series.toString())) != null) {
                this.annotations.add(new SeriesAnnotation(this.time, s, this.instance, value, keyed, attrs));
            }
        }
    }
}

