/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.monitoring.model;

public enum Unit {
    COUNT("count"),
    PERCENT("percent"),
    BYTES("bytes"),
    SECONDS("sec"),
    MILLIS("ms"),
    NANOS("ns"),
    UPDOWN("updown");

    private final String shortName;

    public static Unit fromShortName(String shortName) {
        for (Unit u : Unit.values()) {
            if (!u.shortName.equals(shortName)) continue;
            return u;
        }
        throw new IllegalArgumentException("Unknown unit short name: " + shortName);
    }

    private Unit(String shortName) {
        this.shortName = shortName;
    }

    public String toString() {
        return this.shortName;
    }
}

