/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment;

import com.sun.enterprise.deployment.AuthMechanism;
import com.sun.enterprise.deployment.ConnectionDefDescriptor;
import com.sun.enterprise.deployment.EnvironmentProperty;
import com.sun.enterprise.deployment.OrderedSet;
import jakarta.resource.spi.AuthenticationMechanism;
import jakarta.resource.spi.security.GenericCredential;
import jakarta.resource.spi.security.PasswordCredential;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.deployment.common.Descriptor;
import org.ietf.jgss.GSSCredential;

public class OutboundResourceAdapter
extends Descriptor {
    private int transactionSupport = 1;
    private Set<AuthMechanism> authMechanisms = new OrderedSet<AuthMechanism>();
    private boolean reauthenticationSupport = false;
    private Set<ConnectionDefDescriptor> connectionDefs = new OrderedSet<ConnectionDefDescriptor>();
    private boolean reauthenticationSupportSet = false;
    private boolean transactionSupportSet = false;

    public boolean supportsReauthentication() {
        return this.reauthenticationSupport;
    }

    public String getReauthenticationSupport() {
        return String.valueOf(this.reauthenticationSupport);
    }

    public void setReauthenticationSupport(boolean reauthenticationSupport) {
        this.reauthenticationSupportSet = true;
        this.reauthenticationSupport = reauthenticationSupport;
    }

    public void setReauthenticationSupport(String reauthSupport) {
        this.reauthenticationSupport = Boolean.valueOf(reauthSupport);
        this.reauthenticationSupportSet = true;
    }

    public String getTransSupport() {
        switch (this.transactionSupport) {
            case 0: {
                return "NoTransaction";
            }
            case 1: {
                return "LocalTransaction";
            }
        }
        return "XATransaction";
    }

    public int getTransactionSupport() {
        return this.transactionSupport;
    }

    public void setTransactionSupport(int transactionSupport) {
        this.transactionSupport = transactionSupport;
        this.transactionSupportSet = true;
    }

    public void setTransactionSupport(String support) {
        try {
            this.transactionSupport = "XATransaction".equals(support) ? 2 : ("LocalTransaction".equals(support) ? 1 : 0);
            this.transactionSupportSet = true;
        }
        catch (NumberFormatException nfe) {
            Logger.getAnonymousLogger().log(Level.WARNING, "Error occurred", nfe);
        }
    }

    public Set<AuthMechanism> getAuthMechanisms() {
        if (this.authMechanisms == null) {
            this.authMechanisms = new OrderedSet<AuthMechanism>();
        }
        return this.authMechanisms;
    }

    public boolean addAuthMechanism(AuthMechanism mech) {
        boolean flag = false;
        for (AuthMechanism next : this.authMechanisms) {
            if (next.getAuthMechVal() != mech.getAuthMechVal()) continue;
            return flag;
        }
        flag = this.authMechanisms.add(mech);
        return flag;
    }

    public boolean removeAuthMechanism(AuthMechanism mech) {
        boolean flag = false;
        for (AuthMechanism next : this.authMechanisms) {
            if (!((Object)((Object)next)).equals((Object)mech)) continue;
            flag = this.authMechanisms.remove((Object)mech);
            return flag;
        }
        return flag;
    }

    public boolean addAuthMechanism(int mech) {
        boolean flag = false;
        for (AuthMechanism next : this.authMechanisms) {
            if (next.getAuthMechVal() != mech) continue;
            return flag;
        }
        String credInf = null;
        credInf = mech == 0 ? "jakarta.resource.spi.security.PasswordCredential" : "jakarta.resource.spi.security.GenericCredential";
        AuthMechanism auth = new AuthMechanism("", mech, credInf);
        flag = this.authMechanisms.add(auth);
        return flag;
    }

    public boolean removeAuthMechanism(int mech) {
        boolean flag = false;
        for (AuthMechanism next : this.authMechanisms) {
            if (next.getAuthMechVal() != mech) continue;
            flag = this.authMechanisms.remove((Object)next);
            return flag;
        }
        return flag;
    }

    public void addConnectionDefDescriptor(ConnectionDefDescriptor conDefDesc) {
        this.connectionDefs.add(conDefDesc);
    }

    public boolean hasConnectionDefDescriptor(String connectionFactoryIntf) {
        for (ConnectionDefDescriptor cdd : this.connectionDefs) {
            if (!cdd.getConnectionFactoryIntf().equals(connectionFactoryIntf)) continue;
            return true;
        }
        return false;
    }

    public void removeConnectionDefDescriptor(ConnectionDefDescriptor conDefDesc) {
        this.connectionDefs.remove((Object)conDefDesc);
    }

    public Set<ConnectionDefDescriptor> getConnectionDefs() {
        return this.connectionDefs;
    }

    public void setConnectionDef(ConnectionDefDescriptor conDef) {
        this.connectionDefs.add(conDef);
    }

    public ConnectionDefDescriptor getConnectionDef() {
        Iterator<ConnectionDefDescriptor> iter = this.connectionDefs.iterator();
        ConnectionDefDescriptor conDef = iter.next();
        return conDef;
    }

    public String getManagedConnectionFactoryImpl() {
        return this.getConnectionDef().getManagedConnectionFactoryImpl();
    }

    public void setManagedConnectionFactoryImpl(String managedConnectionFactoryImpl) {
        this.getConnectionDef().setManagedConnectionFactoryImpl(managedConnectionFactoryImpl);
    }

    public Set getConfigProperties() {
        return this.getConnectionDef().getConfigProperties();
    }

    public void addConfigProperty(EnvironmentProperty configProperty) {
        this.getConnectionDef().getConfigProperties().add(configProperty);
    }

    public void removeConfigProperty(EnvironmentProperty configProperty) {
        this.getConnectionDef().getConfigProperties().remove(configProperty);
    }

    public String getConnectionFactoryImpl() {
        return this.getConnectionDef().getConnectionFactoryImpl();
    }

    public void setConnectionFactoryImpl(String cf) {
        this.getConnectionDef().setConnectionFactoryImpl(cf);
    }

    public String getConnectionFactoryIntf() {
        return this.getConnectionDef().getConnectionFactoryIntf();
    }

    public void setConnectionFactoryIntf(String cf) {
        this.getConnectionDef().setConnectionFactoryIntf(cf);
    }

    public String getConnectionIntf() {
        return this.getConnectionDef().getConnectionIntf();
    }

    public void setConnectionIntf(String con) {
        this.getConnectionDef().setConnectionIntf(con);
    }

    public String getConnectionImpl() {
        return this.getConnectionDef().getConnectionImpl();
    }

    public void setConnectionImpl(String con) {
        this.getConnectionDef().setConnectionImpl(con);
    }

    public boolean isReauthenticationSupportSet() {
        return this.reauthenticationSupportSet;
    }

    public boolean isTransactionSupportSet() {
        return this.transactionSupportSet;
    }

    public static String getCredentialInterfaceName(AuthenticationMechanism.CredentialInterface ci) {
        if (ci.equals((Object)AuthenticationMechanism.CredentialInterface.GenericCredential)) {
            return GenericCredential.class.getName();
        }
        if (ci.equals((Object)AuthenticationMechanism.CredentialInterface.GSSCredential)) {
            return GSSCredential.class.getName();
        }
        if (ci.equals((Object)AuthenticationMechanism.CredentialInterface.PasswordCredential)) {
            return PasswordCredential.class.getName();
        }
        throw new RuntimeException("Invalid credential interface :  " + ci);
    }
}

