/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.exporter.internal.okhttp;

import fish.payara.shaded.okhttp3.Headers;
import fish.payara.shaded.okhttp3.OkHttpClient;
import fish.payara.shaded.okhttp3.Request;
import io.opentelemetry.api.GlobalOpenTelemetry;
import io.opentelemetry.api.metrics.MeterProvider;
import io.opentelemetry.exporter.internal.ExporterBuilderUtil;
import io.opentelemetry.exporter.internal.TlsConfigHelper;
import io.opentelemetry.exporter.internal.auth.Authenticator;
import io.opentelemetry.exporter.internal.marshal.Marshaler;
import io.opentelemetry.exporter.internal.okhttp.OkHttpExporter;
import io.opentelemetry.exporter.internal.okhttp.OkHttpUtil;
import io.opentelemetry.exporter.internal.retry.RetryInterceptor;
import io.opentelemetry.exporter.internal.retry.RetryPolicy;
import java.net.URI;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import javax.net.ssl.SSLContext;
import javax.net.ssl.X509TrustManager;

public final class OkHttpExporterBuilder<T extends Marshaler> {
    public static final long DEFAULT_TIMEOUT_SECS = 10L;
    private final String exporterName;
    private final String type;
    private String endpoint;
    private long timeoutNanos = TimeUnit.SECONDS.toNanos(10L);
    private boolean compressionEnabled = false;
    private boolean exportAsJson = false;
    @Nullable
    private Headers.Builder headersBuilder;
    private final TlsConfigHelper tlsConfigHelper = new TlsConfigHelper();
    @Nullable
    private RetryPolicy retryPolicy;
    private Supplier<MeterProvider> meterProviderSupplier = GlobalOpenTelemetry::getMeterProvider;
    @Nullable
    private Authenticator authenticator;

    public OkHttpExporterBuilder(String exporterName, String type, String defaultEndpoint) {
        this.exporterName = exporterName;
        this.type = type;
        this.endpoint = defaultEndpoint;
    }

    public OkHttpExporterBuilder<T> setTimeout(long timeout, TimeUnit unit) {
        this.timeoutNanos = unit.toNanos(timeout);
        return this;
    }

    public OkHttpExporterBuilder<T> setTimeout(Duration timeout) {
        return this.setTimeout(timeout.toNanos(), TimeUnit.NANOSECONDS);
    }

    public OkHttpExporterBuilder<T> setEndpoint(String endpoint) {
        URI uri = ExporterBuilderUtil.validateEndpoint(endpoint);
        this.endpoint = uri.toString();
        return this;
    }

    public OkHttpExporterBuilder<T> setCompression(String compressionMethod) {
        this.compressionEnabled = compressionMethod.equals("gzip");
        return this;
    }

    public OkHttpExporterBuilder<T> addHeader(String key, String value) {
        if (this.headersBuilder == null) {
            this.headersBuilder = new Headers.Builder();
        }
        this.headersBuilder.add(key, value);
        return this;
    }

    public OkHttpExporterBuilder<T> setAuthenticator(Authenticator authenticator) {
        this.authenticator = authenticator;
        return this;
    }

    public OkHttpExporterBuilder<T> setTrustManagerFromCerts(byte[] trustedCertificatesPem) {
        this.tlsConfigHelper.setTrustManagerFromCerts(trustedCertificatesPem);
        return this;
    }

    public OkHttpExporterBuilder<T> setKeyManagerFromCerts(byte[] privateKeyPem, byte[] certificatePem) {
        this.tlsConfigHelper.setKeyManagerFromCerts(privateKeyPem, certificatePem);
        return this;
    }

    public OkHttpExporterBuilder<T> setSslContext(SSLContext sslContext, X509TrustManager trustManager) {
        this.tlsConfigHelper.setSslContext(sslContext, trustManager);
        return this;
    }

    public OkHttpExporterBuilder<T> setMeterProvider(MeterProvider meterProvider) {
        this.meterProviderSupplier = () -> meterProvider;
        return this;
    }

    public OkHttpExporterBuilder<T> setRetryPolicy(RetryPolicy retryPolicy) {
        this.retryPolicy = retryPolicy;
        return this;
    }

    public OkHttpExporterBuilder<T> exportAsJson() {
        this.exportAsJson = true;
        return this;
    }

    public OkHttpExporter<T> build() {
        Headers headers;
        OkHttpClient.Builder clientBuilder = new OkHttpClient.Builder().dispatcher(OkHttpUtil.newDispatcher()).callTimeout(Duration.ofNanos(this.timeoutNanos));
        SSLContext sslContext = this.tlsConfigHelper.getSslContext();
        X509TrustManager trustManager = this.tlsConfigHelper.getTrustManager();
        if (sslContext != null && trustManager != null) {
            clientBuilder.sslSocketFactory(sslContext.getSocketFactory(), trustManager);
        }
        Headers headers2 = headers = this.headersBuilder == null ? null : this.headersBuilder.build();
        if (this.retryPolicy != null) {
            clientBuilder.addInterceptor(new RetryInterceptor(this.retryPolicy, OkHttpExporter::isRetryable));
        }
        if (this.authenticator != null) {
            Authenticator finalAuthenticator = this.authenticator;
            clientBuilder.authenticator((route, response) -> {
                Request.Builder requestBuilder = response.request().newBuilder();
                finalAuthenticator.getHeaders().forEach(requestBuilder::header);
                return requestBuilder.build();
            });
        }
        return new OkHttpExporter(this.exporterName, this.type, clientBuilder.build(), this.meterProviderSupplier, this.endpoint, headers, this.compressionEnabled, this.exportAsJson);
    }
}

