/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.exporter.otlp.http.metrics;

import io.opentelemetry.api.internal.Utils;
import io.opentelemetry.api.metrics.MeterProvider;
import io.opentelemetry.exporter.internal.okhttp.OkHttpExporterBuilder;
import io.opentelemetry.exporter.internal.otlp.OtlpUserAgent;
import io.opentelemetry.exporter.internal.otlp.metrics.MetricsRequestMarshaler;
import io.opentelemetry.exporter.otlp.http.metrics.OtlpHttpMetricExporter;
import io.opentelemetry.sdk.metrics.export.AggregationTemporalitySelector;
import io.opentelemetry.sdk.metrics.export.DefaultAggregationSelector;
import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLContext;
import javax.net.ssl.X509TrustManager;

public final class OtlpHttpMetricExporterBuilder {
    private static final String DEFAULT_ENDPOINT = "http://localhost:4318/v1/metrics";
    private static final AggregationTemporalitySelector DEFAULT_AGGREGATION_TEMPORALITY_SELECTOR = AggregationTemporalitySelector.alwaysCumulative();
    private final OkHttpExporterBuilder<MetricsRequestMarshaler> delegate;
    private AggregationTemporalitySelector aggregationTemporalitySelector = DEFAULT_AGGREGATION_TEMPORALITY_SELECTOR;
    private DefaultAggregationSelector defaultAggregationSelector = DefaultAggregationSelector.getDefault();

    OtlpHttpMetricExporterBuilder() {
        this.delegate = new OkHttpExporterBuilder("otlp", "metric", DEFAULT_ENDPOINT);
        this.delegate.setMeterProvider(MeterProvider.noop());
        OtlpUserAgent.addUserAgentHeader(this.delegate::addHeader);
    }

    public OtlpHttpMetricExporterBuilder setTimeout(long timeout, TimeUnit unit) {
        Objects.requireNonNull(unit, "unit");
        Utils.checkArgument(timeout >= 0L, "timeout must be non-negative");
        this.delegate.setTimeout(timeout, unit);
        return this;
    }

    public OtlpHttpMetricExporterBuilder setTimeout(Duration timeout) {
        Objects.requireNonNull(timeout, "timeout");
        return this.setTimeout(timeout.toNanos(), TimeUnit.NANOSECONDS);
    }

    public OtlpHttpMetricExporterBuilder setEndpoint(String endpoint) {
        Objects.requireNonNull(endpoint, "endpoint");
        this.delegate.setEndpoint(endpoint);
        return this;
    }

    public OtlpHttpMetricExporterBuilder setCompression(String compressionMethod) {
        Objects.requireNonNull(compressionMethod, "compressionMethod");
        Utils.checkArgument(compressionMethod.equals("gzip") || compressionMethod.equals("none"), "Unsupported compression method. Supported compression methods include: gzip, none.");
        this.delegate.setCompression(compressionMethod);
        return this;
    }

    public OtlpHttpMetricExporterBuilder addHeader(String key, String value) {
        this.delegate.addHeader(key, value);
        return this;
    }

    public OtlpHttpMetricExporterBuilder setTrustedCertificates(byte[] trustedCertificatesPem) {
        this.delegate.setTrustManagerFromCerts(trustedCertificatesPem);
        return this;
    }

    public OtlpHttpMetricExporterBuilder setClientTls(byte[] privateKeyPem, byte[] certificatePem) {
        this.delegate.setKeyManagerFromCerts(privateKeyPem, certificatePem);
        return this;
    }

    public OtlpHttpMetricExporterBuilder setSslContext(SSLContext sslContext, X509TrustManager trustManager) {
        this.delegate.setSslContext(sslContext, trustManager);
        return this;
    }

    public OtlpHttpMetricExporterBuilder setAggregationTemporalitySelector(AggregationTemporalitySelector aggregationTemporalitySelector) {
        Objects.requireNonNull(aggregationTemporalitySelector, "aggregationTemporalitySelector");
        this.aggregationTemporalitySelector = aggregationTemporalitySelector;
        return this;
    }

    public OtlpHttpMetricExporterBuilder setDefaultAggregationSelector(DefaultAggregationSelector defaultAggregationSelector) {
        Objects.requireNonNull(defaultAggregationSelector, "defaultAggregationSelector");
        this.defaultAggregationSelector = defaultAggregationSelector;
        return this;
    }

    OtlpHttpMetricExporterBuilder exportAsJson() {
        this.delegate.exportAsJson();
        return this;
    }

    public OtlpHttpMetricExporter build() {
        return new OtlpHttpMetricExporter(this.delegate.build(), this.aggregationTemporalitySelector, this.defaultAggregationSelector);
    }
}

