/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.exporter.otlp.trace;

import io.grpc.ManagedChannel;
import io.opentelemetry.api.internal.Utils;
import io.opentelemetry.api.metrics.MeterProvider;
import io.opentelemetry.exporter.internal.grpc.GrpcExporter;
import io.opentelemetry.exporter.internal.grpc.GrpcExporterBuilder;
import io.opentelemetry.exporter.internal.otlp.OtlpUserAgent;
import io.opentelemetry.exporter.internal.otlp.traces.TraceRequestMarshaler;
import io.opentelemetry.exporter.otlp.trace.MarshalerTraceServiceGrpc;
import io.opentelemetry.exporter.otlp.trace.OtlpGrpcSpanExporter;
import java.net.URI;
import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLContext;
import javax.net.ssl.X509TrustManager;

public final class OtlpGrpcSpanExporterBuilder {
    static final String GRPC_SERVICE_NAME = "opentelemetry.proto.collector.trace.v1.TraceService";
    static final String GRPC_ENDPOINT_PATH = "/opentelemetry.proto.collector.trace.v1.TraceService/Export";
    private static final String DEFAULT_ENDPOINT_URL = "http://localhost:4317";
    private static final URI DEFAULT_ENDPOINT = URI.create("http://localhost:4317");
    private static final long DEFAULT_TIMEOUT_SECS = 10L;
    final GrpcExporterBuilder<TraceRequestMarshaler> delegate = GrpcExporter.builder("otlp", "span", 10L, DEFAULT_ENDPOINT, () -> MarshalerTraceServiceGrpc::newFutureStub, "/opentelemetry.proto.collector.trace.v1.TraceService/Export");

    OtlpGrpcSpanExporterBuilder() {
        OtlpUserAgent.addUserAgentHeader(this.delegate::addHeader);
    }

    @Deprecated
    public OtlpGrpcSpanExporterBuilder setChannel(ManagedChannel channel) {
        this.delegate.setChannel(channel);
        return this;
    }

    public OtlpGrpcSpanExporterBuilder setTimeout(long timeout, TimeUnit unit) {
        Objects.requireNonNull(unit, "unit");
        Utils.checkArgument(timeout >= 0L, "timeout must be non-negative");
        this.delegate.setTimeout(timeout, unit);
        return this;
    }

    public OtlpGrpcSpanExporterBuilder setTimeout(Duration timeout) {
        Objects.requireNonNull(timeout, "timeout");
        this.delegate.setTimeout(timeout);
        return this;
    }

    public OtlpGrpcSpanExporterBuilder setEndpoint(String endpoint) {
        Objects.requireNonNull(endpoint, "endpoint");
        this.delegate.setEndpoint(endpoint);
        return this;
    }

    public OtlpGrpcSpanExporterBuilder setCompression(String compressionMethod) {
        Objects.requireNonNull(compressionMethod, "compressionMethod");
        Utils.checkArgument(compressionMethod.equals("gzip") || compressionMethod.equals("none"), "Unsupported compression method. Supported compression methods include: gzip, none.");
        this.delegate.setCompression(compressionMethod);
        return this;
    }

    public OtlpGrpcSpanExporterBuilder setTrustedCertificates(byte[] trustedCertificatesPem) {
        this.delegate.setTrustManagerFromCerts(trustedCertificatesPem);
        return this;
    }

    public OtlpGrpcSpanExporterBuilder setClientTls(byte[] privateKeyPem, byte[] certificatePem) {
        this.delegate.setKeyManagerFromCerts(privateKeyPem, certificatePem);
        return this;
    }

    public OtlpGrpcSpanExporterBuilder setSslContext(SSLContext sslContext, X509TrustManager trustManager) {
        this.delegate.setSslContext(sslContext, trustManager);
        return this;
    }

    public OtlpGrpcSpanExporterBuilder addHeader(String key, String value) {
        this.delegate.addHeader(key, value);
        return this;
    }

    public OtlpGrpcSpanExporterBuilder setMeterProvider(MeterProvider meterProvider) {
        Objects.requireNonNull(meterProvider, "meterProvider");
        this.delegate.setMeterProvider(meterProvider);
        return this;
    }

    public OtlpGrpcSpanExporter build() {
        return new OtlpGrpcSpanExporter(this.delegate.build());
    }
}

