/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.opentracingshim;

import io.opentelemetry.api.baggage.Baggage;
import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.StatusCode;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.ContextKey;
import io.opentelemetry.context.ImplicitContextKeyed;
import io.opentelemetry.opentracingshim.SpanContextShim;
import io.opentelemetry.semconv.trace.attributes.SemanticAttributes;
import io.opentracing.SpanContext;
import io.opentracing.tag.Tag;
import io.opentracing.tag.Tags;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;

final class SpanShim
implements io.opentracing.Span,
ImplicitContextKeyed {
    private static final String DEFAULT_EVENT_NAME = "log";
    private static final String ERROR = "error";
    private static final ContextKey<SpanShim> SPAN_SHIM_KEY = ContextKey.named("opentracing-shim-key");
    private final Span span;
    private final Object spanContextShimLock;
    private volatile SpanContextShim spanContextShim;

    SpanShim(Span span) {
        this(span, Baggage.empty());
    }

    SpanShim(Span span, Baggage baggage) {
        this.span = span;
        this.spanContextShimLock = new Object();
        this.spanContextShim = new SpanContextShim(span.getSpanContext(), baggage);
    }

    Span getSpan() {
        return this.span;
    }

    Baggage getBaggage() {
        return this.spanContextShim.getBaggage();
    }

    @Nullable
    public static SpanShim current() {
        return Context.current().get(SPAN_SHIM_KEY);
    }

    @Override
    public Context storeInContext(Context context) {
        context = context.with(SPAN_SHIM_KEY, this).with(this.span).with(this.spanContextShim.getBaggage());
        return context;
    }

    public SpanContext context() {
        return this.spanContextShim;
    }

    public io.opentracing.Span setTag(String key, String value) {
        if (Tags.ERROR.getKey().equals(key)) {
            StatusCode canonicalCode = Boolean.parseBoolean(value) ? StatusCode.ERROR : StatusCode.OK;
            this.span.setStatus(canonicalCode);
        } else {
            this.span.setAttribute(key, value);
        }
        return this;
    }

    public io.opentracing.Span setTag(String key, boolean value) {
        if (Tags.ERROR.getKey().equals(key)) {
            StatusCode canonicalCode = value ? StatusCode.ERROR : StatusCode.OK;
            this.span.setStatus(canonicalCode);
        } else {
            this.span.setAttribute(key, value);
        }
        return this;
    }

    public io.opentracing.Span setTag(String key, Number value) {
        if (value == null) {
            return this;
        }
        if (value instanceof Integer || value instanceof Long || value instanceof Short || value instanceof Byte) {
            this.span.setAttribute(key, value.longValue());
        } else if (value instanceof Float || value instanceof Double) {
            this.span.setAttribute(key, value.doubleValue());
        } else {
            this.span.setAttribute(key, value.toString());
        }
        return this;
    }

    public <T> io.opentracing.Span setTag(Tag<T> tag, T value) {
        if (tag == null) {
            return this;
        }
        tag.set((io.opentracing.Span)this, value);
        return this;
    }

    public io.opentracing.Span log(Map<String, ?> fields) {
        this.logInternal(-1L, fields);
        return this;
    }

    public io.opentracing.Span log(long timestampMicroseconds, Map<String, ?> fields) {
        this.logInternal(timestampMicroseconds, fields);
        return this;
    }

    public io.opentracing.Span log(String event) {
        this.span.addEvent(event);
        return this;
    }

    public io.opentracing.Span log(long timestampMicroseconds, String event) {
        this.span.addEvent(event, timestampMicroseconds, TimeUnit.MICROSECONDS);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public io.opentracing.Span setBaggageItem(String key, String value) {
        if (key == null || value == null) {
            return this;
        }
        Object object = this.spanContextShimLock;
        synchronized (object) {
            this.spanContextShim = this.spanContextShim.newWithKeyValue(key, value);
        }
        return this;
    }

    @Nullable
    public String getBaggageItem(String key) {
        if (key == null) {
            return null;
        }
        return this.spanContextShim.getBaggageItem(key);
    }

    public io.opentracing.Span setOperationName(String operationName) {
        this.span.updateName(operationName);
        return this;
    }

    public void finish() {
        this.span.end();
    }

    public void finish(long finishMicros) {
        this.span.end(finishMicros, TimeUnit.MICROSECONDS);
    }

    private void logInternal(long timestampMicroseconds, Map<String, ?> fields) {
        String name = SpanShim.getEventNameFromFields(fields);
        Throwable throwable = null;
        boolean isError = false;
        if (name.equals(ERROR)) {
            throwable = SpanShim.findThrowable(fields);
            isError = true;
            if (throwable == null) {
                name = "exception";
            }
        }
        Attributes attributes = SpanShim.convertToAttributes(fields, isError, throwable != null);
        if (throwable != null) {
            this.span.recordException(throwable, attributes);
        } else if (timestampMicroseconds != -1L) {
            this.span.addEvent(name, attributes, timestampMicroseconds, TimeUnit.MICROSECONDS);
        } else {
            this.span.addEvent(name, attributes);
        }
    }

    private static String getEventNameFromFields(Map<String, ?> fields) {
        Object eventValue;
        Object object = eventValue = fields == null ? null : (Object)fields.get("event");
        if (eventValue != null) {
            return eventValue.toString();
        }
        return DEFAULT_EVENT_NAME;
    }

    private static Attributes convertToAttributes(Map<String, ?> fields, boolean isError, boolean isRecordingException) {
        AttributesBuilder attributesBuilder = Attributes.builder();
        for (Map.Entry<String, ?> entry : fields.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            if (value == null) continue;
            if (value instanceof Byte || value instanceof Short || value instanceof Integer || value instanceof Long) {
                attributesBuilder.put(AttributeKey.longKey(key), Long.valueOf(((Number)value).longValue()));
                continue;
            }
            if (value instanceof Float || value instanceof Double) {
                attributesBuilder.put(AttributeKey.doubleKey(key), Double.valueOf(((Number)value).doubleValue()));
                continue;
            }
            if (value instanceof Boolean) {
                attributesBuilder.put(AttributeKey.booleanKey(key), (Boolean)value);
                continue;
            }
            AttributeKey<String> attributeKey = null;
            if (isError && !isRecordingException) {
                if (key.equals("error.kind")) {
                    attributeKey = SemanticAttributes.EXCEPTION_TYPE;
                } else if (key.equals("message")) {
                    attributeKey = SemanticAttributes.EXCEPTION_MESSAGE;
                } else if (key.equals("stack")) {
                    attributeKey = SemanticAttributes.EXCEPTION_STACKTRACE;
                }
            }
            if (isRecordingException && key.equals("error.object")) continue;
            if (attributeKey == null) {
                attributeKey = AttributeKey.stringKey(key);
            }
            attributesBuilder.put(attributeKey, value.toString());
        }
        return attributesBuilder.build();
    }

    @Nullable
    private static Throwable findThrowable(Map<String, ?> fields) {
        Object value = fields.get("error.object");
        if (value instanceof Throwable) {
            return (Throwable)value;
        }
        return null;
    }
}

