/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.container.common.impl.util;

import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.cp.IAtomicLong;
import com.hazelcast.cp.lock.FencedLock;
import com.hazelcast.map.IMap;
import com.sun.enterprise.container.common.spi.ClusteredSingletonLookup;
import fish.payara.nucleus.hazelcast.HazelcastCore;
import java.lang.annotation.Annotation;
import java.util.concurrent.atomic.AtomicReference;
import org.glassfish.internal.api.Globals;
import org.glassfish.internal.api.JavaEEContextUtil;

public abstract class ClusteredSingletonLookupImplBase
implements ClusteredSingletonLookup {
    private final HazelcastCore hzCore = (HazelcastCore)Globals.getDefaultHabitat().getService(HazelcastCore.class, new Annotation[0]);
    private final JavaEEContextUtil ctxUtil = (JavaEEContextUtil)Globals.getDefaultHabitat().getService(JavaEEContextUtil.class, new Annotation[0]);
    private final String componentId;
    private final ClusteredSingletonLookup.SingletonType singletonType;
    private final String keyPrefix;
    private final String mapKey;
    private final AtomicReference<String> sessionHzKey = new AtomicReference();
    private final AtomicReference<FencedLock> lock = new AtomicReference();
    private final AtomicReference<IAtomicLong> count = new AtomicReference();

    public ClusteredSingletonLookupImplBase(String componentId, ClusteredSingletonLookup.SingletonType singletonType) {
        this.componentId = componentId;
        this.singletonType = singletonType;
        this.keyPrefix = this.makeKeyPrefix();
        this.mapKey = this.makeMapKey();
    }

    protected final String getKeyPrefix() {
        return this.keyPrefix;
    }

    protected final String getMapKey() {
        return this.mapKey;
    }

    public final String getSessionHzKey() {
        return this.sessionHzKey.updateAndGet(v -> v != null ? v : this.makeSessionHzKey());
    }

    @Override
    public FencedLock getDistributedLock() {
        return this.lock.updateAndGet(v -> v != null ? v : this.getHazelcastInstance().getCPSubsystem().getLock(this.makeLockKey()));
    }

    @Override
    public IMap<String, Object> getClusteredSingletonMap() {
        try (JavaEEContextUtil.Context ctx = this.ctxUtil.empty().pushContext();){
            IMap iMap = this.getHazelcastInstance().getMap(this.getMapKey());
            return iMap;
        }
    }

    @Override
    public IAtomicLong getClusteredUsageCount() {
        return this.count.updateAndGet(v -> v != null ? v : this.getHazelcastInstance().getCPSubsystem().getAtomicLong(this.makeCountKey()));
    }

    private HazelcastInstance getHazelcastInstance() {
        if (!this.hzCore.isEnabled()) {
            throw new IllegalStateException("ClusteredSingleton.getHazelcastInstance() - Hazelcast is Disabled");
        }
        return this.hzCore.getInstance();
    }

    @Override
    public boolean isClusteredEnabled() {
        return this.hzCore.isEnabled();
    }

    @Override
    public boolean isDistributedLockEnabled() {
        return this.isClusteredEnabled();
    }

    @Override
    public void destroy() {
        this.getClusteredSingletonMap().delete((Object)this.getClusteredSessionKey());
        this.lock.set(null);
        IAtomicLong oldCountValue = this.count.getAndSet(null);
        if (oldCountValue != null) {
            oldCountValue.set(0L);
        }
    }

    @Override
    public HazelcastCore getHazelcastCore() {
        return this.hzCore;
    }

    private String makeKeyPrefix() {
        return String.format("Payara/%s/singleton/", this.singletonType.name().toLowerCase());
    }

    private String makeMapKey() {
        return this.getKeyPrefix() + this.componentId;
    }

    private String makeLockKey() {
        return this.getSessionHzKey() + "/lock";
    }

    private String makeCountKey() {
        return this.getSessionHzKey() + "/count";
    }

    private String makeSessionHzKey() {
        String sessionKey = this.getClusteredSessionKey();
        if (this.componentId.startsWith(sessionKey)) {
            return this.getKeyPrefix() + sessionKey;
        }
        return this.getKeyPrefix() + this.componentId + "/" + sessionKey;
    }
}

