/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.security.shaded.nimbusds.jose.crypto;

import fish.payara.security.shaded.nimbusds.jose.CriticalHeaderParamsAware;
import fish.payara.security.shaded.nimbusds.jose.JOSEException;
import fish.payara.security.shaded.nimbusds.jose.JWEDecrypter;
import fish.payara.security.shaded.nimbusds.jose.JWEHeader;
import fish.payara.security.shaded.nimbusds.jose.crypto.impl.CriticalHeaderParamsDeferral;
import fish.payara.security.shaded.nimbusds.jose.crypto.impl.ECDH;
import fish.payara.security.shaded.nimbusds.jose.crypto.impl.ECDHCryptoProvider;
import fish.payara.security.shaded.nimbusds.jose.jwk.Curve;
import fish.payara.security.shaded.nimbusds.jose.jwk.OctetKeyPair;
import fish.payara.security.shaded.nimbusds.jose.util.Base64URL;
import java.util.Collections;
import java.util.Set;
import javax.crypto.SecretKey;

public class X25519Decrypter
extends ECDHCryptoProvider
implements JWEDecrypter,
CriticalHeaderParamsAware {
    private final OctetKeyPair privateKey;
    private final CriticalHeaderParamsDeferral critPolicy = new CriticalHeaderParamsDeferral();

    public X25519Decrypter(OctetKeyPair privateKey) throws JOSEException {
        this(privateKey, null);
    }

    public X25519Decrypter(OctetKeyPair privateKey, Set<String> defCritHeaders) throws JOSEException {
        super(privateKey.getCurve());
        if (!Curve.X25519.equals(privateKey.getCurve())) {
            throw new JOSEException("X25519Decrypter only supports OctetKeyPairs with crv=X25519");
        }
        if (!privateKey.isPrivate()) {
            throw new JOSEException("The OctetKeyPair doesn't contain a private part");
        }
        this.privateKey = privateKey;
        this.critPolicy.setDeferredCriticalHeaderParams(defCritHeaders);
    }

    @Override
    public Set<Curve> supportedEllipticCurves() {
        return Collections.singleton(Curve.X25519);
    }

    public OctetKeyPair getPrivateKey() {
        return this.privateKey;
    }

    @Override
    public Set<String> getProcessedCriticalHeaderParams() {
        return this.critPolicy.getProcessedCriticalHeaderParams();
    }

    @Override
    public Set<String> getDeferredCriticalHeaderParams() {
        return this.critPolicy.getProcessedCriticalHeaderParams();
    }

    @Override
    public byte[] decrypt(JWEHeader header, Base64URL encryptedKey, Base64URL iv, Base64URL cipherText, Base64URL authTag) throws JOSEException {
        this.critPolicy.ensureHeaderPasses(header);
        OctetKeyPair ephemeralPublicKey = (OctetKeyPair)header.getEphemeralPublicKey();
        if (ephemeralPublicKey == null) {
            throw new JOSEException("Missing ephemeral public key epk JWE header parameter");
        }
        if (!this.privateKey.getCurve().equals(ephemeralPublicKey.getCurve())) {
            throw new JOSEException("Curve of ephemeral public key does not match curve of private key");
        }
        SecretKey Z = ECDH.deriveSharedSecret(ephemeralPublicKey, this.privateKey);
        return this.decryptWithZ(header, Z, encryptedKey, iv, cipherText, authTag);
    }
}

