/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.security.shaded.nimbusds.jose.jwk;

import fish.payara.security.shaded.jcip.annotations.Immutable;
import fish.payara.security.shaded.nimbusds.jose.jwk.JWK;
import fish.payara.security.shaded.nimbusds.jose.jwk.JWKMatcher;
import fish.payara.security.shaded.nimbusds.jose.jwk.JWKSet;
import java.util.LinkedList;
import java.util.List;

@Immutable
public final class JWKSelector {
    private final JWKMatcher matcher;

    public JWKSelector(JWKMatcher matcher) {
        if (matcher == null) {
            throw new IllegalArgumentException("The JWK matcher must not be null");
        }
        this.matcher = matcher;
    }

    public JWKMatcher getMatcher() {
        return this.matcher;
    }

    public List<JWK> select(JWKSet jwkSet) {
        LinkedList<JWK> selectedKeys = new LinkedList<JWK>();
        if (jwkSet == null) {
            return selectedKeys;
        }
        for (JWK key : jwkSet.getKeys()) {
            if (!this.matcher.matches(key)) continue;
            selectedKeys.add(key);
        }
        return selectedKeys;
    }
}

