/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.config.serverbeans;

import com.sun.enterprise.config.serverbeans.Application;
import com.sun.enterprise.config.serverbeans.ApplicationRef;
import com.sun.enterprise.config.serverbeans.Applications;
import com.sun.enterprise.config.serverbeans.Cluster;
import com.sun.enterprise.config.serverbeans.Clusters;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.ConfigLoader;
import com.sun.enterprise.config.serverbeans.Configs;
import com.sun.enterprise.config.serverbeans.DomainExtension;
import com.sun.enterprise.config.serverbeans.Node;
import com.sun.enterprise.config.serverbeans.NodeAgents;
import com.sun.enterprise.config.serverbeans.Nodes;
import com.sun.enterprise.config.serverbeans.Resources;
import com.sun.enterprise.config.serverbeans.SecureAdmin;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.config.serverbeans.ServerRef;
import com.sun.enterprise.config.serverbeans.Servers;
import com.sun.enterprise.config.serverbeans.SystemApplications;
import com.sun.enterprise.config.serverbeans.SystemProperty;
import com.sun.enterprise.config.serverbeans.SystemPropertyBag;
import com.sun.enterprise.config.util.ConfigApiLoggerInfo;
import com.sun.enterprise.util.StringUtils;
import fish.payara.enterprise.config.serverbeans.DGServerRef;
import fish.payara.enterprise.config.serverbeans.DeploymentGroup;
import fish.payara.enterprise.config.serverbeans.DeploymentGroups;
import jakarta.validation.constraints.NotNull;
import java.beans.PropertyVetoException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.admin.config.ApplicationName;
import org.glassfish.api.admin.config.PropertiesDesc;
import org.glassfish.api.admin.config.PropertyDesc;
import org.glassfish.api.admin.config.ReferenceContainer;
import org.glassfish.quality.ToDo;
import org.jvnet.hk2.config.Attribute;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigExtensionMethod;
import org.jvnet.hk2.config.Configured;
import org.jvnet.hk2.config.DuckTyped;
import org.jvnet.hk2.config.Element;
import org.jvnet.hk2.config.types.Property;
import org.jvnet.hk2.config.types.PropertyBag;

@Configured
public interface Domain
extends ConfigBeanProxy,
PropertyBag,
SystemPropertyBag,
ConfigLoader {
    public static final String DOMAIN_NAME_PROPERTY = "administrative.domain.name";

    @Attribute
    public String getApplicationRoot();

    public void setApplicationRoot(String var1) throws PropertyVetoException;

    @Attribute
    public String getLogRoot();

    public void setLogRoot(String var1) throws PropertyVetoException;

    @Attribute
    public String getLocale();

    public void setLocale(String var1) throws PropertyVetoException;

    @Attribute
    public String getVersion();

    @Element
    public SecureAdmin getSecureAdmin();

    public void setSecureAdmin(SecureAdmin var1);

    @Element
    @NotNull
    public Applications getApplications();

    public void setApplications(Applications var1) throws PropertyVetoException;

    @Element
    @NotNull
    public SystemApplications getSystemApplications();

    public void setSystemApplications(SystemApplications var1) throws PropertyVetoException;

    @Element
    @NotNull
    public Resources getResources();

    public void setResources(Resources var1) throws PropertyVetoException;

    @Element(required=true)
    @NotNull
    public Configs getConfigs();

    public void setConfigs(Configs var1) throws PropertyVetoException;

    @Element(required=true)
    @NotNull
    public Servers getServers();

    public void setServers(Servers var1) throws PropertyVetoException;

    @Element
    @NotNull
    public Clusters getClusters();

    public void setClusters(Clusters var1) throws PropertyVetoException;

    @Element
    @NotNull
    public DeploymentGroups getDeploymentGroups();

    public void setDeploymentGroups(DeploymentGroups var1) throws PropertyVetoException;

    @Element
    public Nodes getNodes();

    public void setNodes(Nodes var1) throws PropertyVetoException;

    @Element
    public NodeAgents getNodeAgents();

    public void setNodeAgents(NodeAgents var1) throws PropertyVetoException;

    @Override
    @ToDo(priority=ToDo.Priority.IMPORTANT, details="Any more legal system properties?")
    @PropertiesDesc(systemProperties=true, props={@PropertyDesc(name="com.sun.aas.installRoot", description="Operating system dependent. Path to the directory where the server is installed"), @PropertyDesc(name="com.sun.aas.instanceRoot", description="Operating system dependent. Path to the top level directory for a server instance"), @PropertyDesc(name="com.sun.aas.hostName", description="Operating system dependent. Path to the name of the host (machine)"), @PropertyDesc(name="com.sun.aas.javaRoot", description="Operating system dependent. Path to the library directory for the Sun GlassFish Message Queue software"), @PropertyDesc(name="com.sun.aas.imqLib", description="Operating system dependent. Path to the installation directory for the Java runtime"), @PropertyDesc(name="com.sun.aas.imqLib", description="Operating system dependent. Path to the installation directory for the Java runtime"), @PropertyDesc(name="com.sun.aas.configName", defaultValue="server-config", description="Name of the <config> used by a server instance"), @PropertyDesc(name="com.sun.aas.instanceName", defaultValue="server1", description="Name of the server instance. Not used in the default configuration, but can be used to customize configuration"), @PropertyDesc(name="com.sun.aas.domainName", defaultValue="domain1", description="Name of the domain. Not used in the default configuration, but can be used to customize configuration")})
    @Element
    public List<SystemProperty> getSystemProperty();

    @ToDo(priority=ToDo.Priority.IMPORTANT, details="Provide PropertyDesc for legal props")
    @PropertiesDesc(props={})
    @Element
    public List<Property> getProperty();

    @Element(value="*")
    public List<DomainExtension> getExtensions();

    @DuckTyped
    public String getName();

    @DuckTyped
    public List<Application> getAllDefinedSystemApplications();

    @DuckTyped
    public ApplicationRef getApplicationRefInServer(String var1, String var2);

    @DuckTyped
    public List<ApplicationRef> getApplicationRefsInServer(String var1);

    @DuckTyped
    public List<Application> getSystemApplicationsReferencedFrom(String var1);

    @DuckTyped
    public Application getSystemApplicationReferencedFrom(String var1, String var2);

    @DuckTyped
    public boolean isNamedSystemApplicationReferencedFrom(String var1, String var2);

    @DuckTyped
    public Server getServerNamed(String var1);

    @DuckTyped
    public boolean isServer(String var1);

    @DuckTyped
    public Config getConfigNamed(String var1);

    @DuckTyped
    public Cluster getClusterNamed(String var1);

    @DuckTyped
    public Node getNodeNamed(String var1);

    @DuckTyped
    public boolean isCurrentInstanceMatchingTarget(String var1, String var2, String var3, List<String> var4);

    @DuckTyped
    public List<Server> getServersInTarget(String var1);

    @DuckTyped
    public List<ApplicationRef> getApplicationRefsInTarget(String var1);

    @DuckTyped
    public ApplicationRef getApplicationRefInTarget(String var1, String var2);

    @DuckTyped
    public ApplicationRef getApplicationRefInTarget(String var1, String var2, boolean var3);

    @DuckTyped
    public boolean isAppRefEnabledInTarget(String var1, String var2);

    @DuckTyped
    public boolean isAppEnabledInTarget(String var1, String var2);

    @DuckTyped
    public boolean isAppReferencedByPaaSTarget(String var1);

    @DuckTyped
    public List<String> getAllReferencedTargetsForApplication(String var1);

    @DuckTyped
    public List<String> getAllTargets();

    @DuckTyped
    public List<String> getTargets(String var1);

    @DuckTyped
    public List<Application> getApplicationsInTarget(String var1);

    @DuckTyped
    public String getVirtualServersForApplication(String var1, String var2);

    @DuckTyped
    public String getEnabledForApplication(String var1, String var2);

    @DuckTyped
    public ReferenceContainer getReferenceContainerNamed(String var1);

    @DuckTyped
    public Cluster getClusterForInstance(String var1);

    @DuckTyped
    public List<ReferenceContainer> getAllReferenceContainers();

    @DuckTyped
    public List<ReferenceContainer> getReferenceContainersOf(Config var1);

    @DuckTyped
    public List<Server> getInstancesOnNode(String var1);

    @DuckTyped
    public List<Cluster> getClustersOnNode(String var1);

    @ConfigExtensionMethod
    public <T extends DomainExtension> T getExtensionByType(Class<T> var1);

    @DuckTyped
    public <P extends ConfigBeanProxy> boolean checkIfExtensionExists(Class<P> var1);

    @DuckTyped
    public DeploymentGroup getDeploymentGroupNamed(String var1);

    @DuckTyped
    public List<DeploymentGroup> getDeploymentGroupsForInstance(String var1);

    public static class Duck {
        private static final Logger LOGGER = ConfigApiLoggerInfo.getLogger();

        public static String getName(Domain domain) {
            return domain.getPropertyValue(Domain.DOMAIN_NAME_PROPERTY);
        }

        public static List<Server> getInstancesOnNode(Domain domain, String nodeName) {
            LinkedList<Server> ret = new LinkedList<Server>();
            try {
                if (!StringUtils.ok((String)nodeName)) {
                    return ret;
                }
                List<Server> servers = domain.getServers().getServer();
                for (Server server : servers) {
                    if (!nodeName.equals(server.getNodeRef())) continue;
                    ret.add(server);
                }
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, "NCLS-CFGAPI-00008", e.getLocalizedMessage());
            }
            return ret;
        }

        public static List<Cluster> getClustersOnNode(Domain domain, String nodeName) {
            HashMap<String, Cluster> clMap = new HashMap<String, Cluster>();
            List<Server> serverList = Duck.getInstancesOnNode(domain, nodeName);
            try {
                for (Server server : serverList) {
                    Cluster mycl = server.getCluster();
                    if (!nodeName.equals(server.getNodeRef())) continue;
                    clMap.put(mycl.getName(), mycl);
                }
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, "NCLS-CFGAPI-00007", e.getLocalizedMessage());
            }
            return new ArrayList<Cluster>(clMap.values());
        }

        public static List<Application> getAllDefinedSystemApplications(Domain me) {
            ArrayList<Application> allSysApps = new ArrayList<Application>();
            SystemApplications sa = me.getSystemApplications();
            for (ApplicationName m : sa.getModules()) {
                if (!(m instanceof Application)) continue;
                allSysApps.add((Application)m);
            }
            return Collections.unmodifiableList(allSysApps);
        }

        public static ApplicationRef getApplicationRefInServer(Domain me, String sn, String name) {
            Servers ss = me.getServers();
            List<Server> list = ss.getServer();
            Server theServer = null;
            for (Server s : list) {
                if (!s.getName().equals(sn)) continue;
                theServer = s;
                break;
            }
            ApplicationRef aref = null;
            if (theServer != null) {
                List arefs = theServer.getApplicationRef();
                for (ApplicationRef ar : arefs) {
                    if (!ar.getRef().equals(name)) continue;
                    aref = ar;
                    break;
                }
            }
            return aref;
        }

        public static List<ApplicationRef> getApplicationRefsInServer(Domain me, String sn) {
            Server server = Duck.getServerNamed(me, sn);
            if (server != null) {
                return server.getApplicationRef();
            }
            return Collections.emptyList();
        }

        public static List<Application> getSystemApplicationsReferencedFrom(Domain d, String sn) {
            if (d == null || sn == null) {
                throw new IllegalArgumentException("Null argument");
            }
            List<Application> allApps = d.getAllDefinedSystemApplications();
            if (allApps.isEmpty()) {
                return allApps;
            }
            Server s = Duck.getServerNamed(d, sn);
            ArrayList<Application> referencedApps = new ArrayList<Application>();
            List appsReferenced = s.getApplicationRef();
            for (ApplicationRef ref : appsReferenced) {
                for (Application app : allApps) {
                    if (!ref.getRef().equals(app.getName())) continue;
                    referencedApps.add(app);
                }
            }
            return Collections.unmodifiableList(referencedApps);
        }

        public static Application getSystemApplicationReferencedFrom(Domain d, String sn, String appName) {
            List<Application> allApps = Duck.getSystemApplicationsReferencedFrom(d, sn);
            for (Application app : allApps) {
                if (!app.getName().equals(appName)) continue;
                return app;
            }
            return null;
        }

        public static boolean isNamedSystemApplicationReferencedFrom(Domain d, String appName, String serverName) {
            List<Application> referencedApps = Duck.getSystemApplicationsReferencedFrom(d, serverName);
            for (Application app : referencedApps) {
                if (!app.getName().equals(appName)) continue;
                return true;
            }
            return false;
        }

        public static Server getServerNamed(Domain d, String name) {
            if (d.getServers() == null || name == null) {
                throw new IllegalArgumentException("no <servers> element");
            }
            List<Server> servers = d.getServers().getServer();
            for (Server s : servers) {
                if (!name.equals(s.getName().trim())) continue;
                return s;
            }
            return null;
        }

        public static Config getConfigNamed(Domain d, String name) {
            if (d.getConfigs() == null || name == null) {
                throw new IllegalArgumentException("no <config> element");
            }
            List<Config> configs = d.getConfigs().getConfig();
            for (Config c : configs) {
                if (!name.equals(c.getName().trim())) continue;
                return c;
            }
            return null;
        }

        public static DeploymentGroup getDeploymentGroupNamed(Domain d, String name) {
            if (d.getDeploymentGroups() == null || name == null) {
                throw new IllegalArgumentException("no <deploymentgroup> element");
            }
            List<DeploymentGroup> dgs = d.getDeploymentGroups().getDeploymentGroup();
            for (DeploymentGroup dg : dgs) {
                if (!name.equals(dg.getName().trim())) continue;
                return dg;
            }
            return null;
        }

        public static List<DeploymentGroup> getDeploymentGroupsForInstance(Domain d, String instanceName) {
            LinkedList<DeploymentGroup> result = new LinkedList<DeploymentGroup>();
            List<DeploymentGroup> dgs = d.getDeploymentGroups().getDeploymentGroup();
            if (dgs != null) {
                for (DeploymentGroup dg : dgs) {
                    DGServerRef ref = dg.getDGServerRefByRef(instanceName);
                    if (ref == null) continue;
                    result.add(dg);
                }
            }
            return result;
        }

        public static Cluster getClusterNamed(Domain d, String name) {
            if (name == null) {
                return null;
            }
            List<Cluster> clusters = d.getClusters().getCluster();
            for (Cluster c : clusters) {
                if (!name.equals(c.getName().trim())) continue;
                return c;
            }
            return null;
        }

        public static Node getNodeNamed(Domain d, String name) {
            if (d.getNodes() == null || name == null) {
                return null;
            }
            List<Node> nodes = d.getNodes().getNode();
            for (Node n : nodes) {
                if (!name.equals(n.getName().trim())) continue;
                return n;
            }
            return null;
        }

        public static boolean isCurrentInstanceMatchingTarget(Domain d, String target, String appName, String currentInstance, List<String> referencedTargets) {
            if (target == null || currentInstance == null) {
                return false;
            }
            List<Object> targets = new ArrayList<String>();
            if (!target.equals("domain")) {
                targets.add(target);
            } else {
                if (referencedTargets == null) {
                    referencedTargets = d.getAllReferencedTargetsForApplication(appName);
                }
                targets = referencedTargets;
            }
            for (String string : targets) {
                DeploymentGroup dg;
                if (currentInstance.equals(string)) {
                    return true;
                }
                Cluster cluster = Duck.getClusterNamed(d, string);
                if (cluster != null) {
                    for (Server svr : cluster.getInstances()) {
                        if (!svr.getName().equals(currentInstance)) continue;
                        return true;
                    }
                }
                if ((dg = Duck.getDeploymentGroupNamed(d, string)) == null) continue;
                for (Server svr : dg.getInstances()) {
                    if (!svr.getName().equals(currentInstance)) continue;
                    return true;
                }
            }
            return false;
        }

        public static List<Server> getServersInTarget(Domain me, String target) {
            ArrayList<Server> servers = new ArrayList<Server>();
            Server server = me.getServerNamed(target);
            if (server != null) {
                servers.add(server);
            } else {
                Cluster cluster = Duck.getClusterNamed(me, target);
                if (cluster != null) {
                    servers.addAll(cluster.getInstances());
                } else {
                    DeploymentGroup dg = Duck.getDeploymentGroupNamed(me, target);
                    if (dg != null) {
                        servers.addAll(dg.getInstances());
                    }
                }
            }
            return servers;
        }

        public static List<ApplicationRef> getApplicationRefsInTarget(Domain me, String target) {
            return Duck.getApplicationRefsInTarget(me, target, false);
        }

        public static List<String> getTargets(Domain me, String tgt) {
            ArrayList<String> targets = new ArrayList<String>();
            if (!tgt.equals("domain")) {
                targets.add(tgt);
            } else {
                targets = me.getAllTargets();
            }
            return targets;
        }

        public static List<ApplicationRef> getApplicationRefsInTarget(Domain me, String tgt, boolean includeInstances) {
            List<String> targets = Duck.getTargets(me, tgt);
            ArrayList<ApplicationRef> allAppRefs = new ArrayList<ApplicationRef>();
            for (String target : targets) {
                Server server = me.getServerNamed(target);
                if (server != null) {
                    allAppRefs.addAll(server.getApplicationRef());
                    continue;
                }
                Cluster cluster = Duck.getClusterNamed(me, target);
                if (cluster != null) {
                    allAppRefs.addAll(cluster.getApplicationRef());
                    if (!includeInstances) continue;
                    for (Server svr : cluster.getInstances()) {
                        allAppRefs.addAll(svr.getApplicationRef());
                    }
                    continue;
                }
                DeploymentGroup dg = Duck.getDeploymentGroupNamed(me, target);
                if (dg == null) continue;
                allAppRefs.addAll(dg.getApplicationRef());
                if (!includeInstances) continue;
                for (Server svr : dg.getInstances()) {
                    allAppRefs.addAll(svr.getApplicationRef());
                }
            }
            return allAppRefs;
        }

        public static ApplicationRef getApplicationRefInTarget(Domain me, String appName, String target) {
            for (ApplicationRef ref : Duck.getApplicationRefsInTarget(me, target)) {
                if (!ref.getRef().equals(appName)) continue;
                return ref;
            }
            return null;
        }

        public static boolean isAppRefEnabledInTarget(Domain me, String appName, String target) {
            ApplicationRef clusterRef;
            boolean found = false;
            Cluster containingCluster = Duck.getClusterForInstance(me, target);
            if (!(containingCluster == null || (clusterRef = Duck.getApplicationRefInTarget(me, appName, containingCluster.getName())) != null && Boolean.valueOf(clusterRef.getEnabled()).booleanValue())) {
                return false;
            }
            List<DeploymentGroup> dgs = Duck.getDeploymentGroupsForInstance(me, target);
            if (dgs != null) {
                for (DeploymentGroup dg : dgs) {
                    ApplicationRef ref = dg.getApplicationRef(appName);
                    if (ref != null && Boolean.valueOf(ref.getEnabled()).booleanValue()) continue;
                    return false;
                }
            }
            for (ApplicationRef ref : Duck.getApplicationRefsInTarget(me, target, true)) {
                if (!ref.getRef().equals(appName)) continue;
                found = true;
                if (Boolean.valueOf(ref.getEnabled()).booleanValue()) continue;
                return false;
            }
            return found;
        }

        public static boolean isAppEnabledInTarget(Domain me, String appName, String target) {
            Application application = me.getApplications().getApplication(appName);
            if (application != null && Boolean.valueOf(application.getEnabled()).booleanValue()) {
                List<Object> targets = new ArrayList<String>();
                if (!target.equals("domain")) {
                    targets.add(target);
                } else {
                    targets = Duck.getAllReferencedTargetsForApplication(me, appName);
                }
                for (String string : targets) {
                    if (Duck.isAppRefEnabledInTarget(me, appName, string)) continue;
                    return false;
                }
                return true;
            }
            return false;
        }

        public static List<String> getAllTargets(Domain d) {
            ArrayList<String> targets = new ArrayList<String>();
            for (Server server : d.getServers().getServer()) {
                if (server.getCluster() != null) continue;
                targets.add(server.getName());
            }
            for (Cluster cluster : d.getClusters().getCluster()) {
                targets.add(cluster.getName());
            }
            for (DeploymentGroup dg : d.getDeploymentGroups().getDeploymentGroup()) {
                targets.add(dg.getName());
            }
            return targets;
        }

        public static List<String> getAllReferencedTargetsForApplication(Domain me, String appName) {
            ArrayList<String> referencedTargets = new ArrayList<String>();
            for (String target : me.getAllTargets()) {
                if (me.getApplicationRefInTarget(appName, target) == null) continue;
                referencedTargets.add(target);
            }
            for (String reference : new ArrayList(referencedTargets)) {
                Cluster cluster;
                DeploymentGroup dg = me.getDeploymentGroupNamed(reference);
                if (dg != null) {
                    for (Server instance : dg.getInstances()) {
                        referencedTargets.remove(instance.getName());
                    }
                }
                if ((cluster = me.getClusterNamed(reference)) == null) continue;
                for (Server instance : cluster.getInstances()) {
                    referencedTargets.remove(instance.getName());
                }
            }
            return referencedTargets;
        }

        public static boolean isAppReferencedByPaaSTarget(Domain me, String appName) {
            List<String> referencedTargets = me.getAllReferencedTargetsForApplication(appName);
            for (String target : referencedTargets) {
                Cluster cluster = me.getClusterNamed(target);
                if (cluster == null || !cluster.isVirtual()) continue;
                return true;
            }
            return false;
        }

        public static List<Application> getApplicationsInTarget(Domain me, String target) {
            if (target.equals("domain")) {
                return me.getApplications().getApplications();
            }
            ArrayList<Application> apps = new ArrayList<Application>();
            List<ApplicationRef> applicationRefs = me.getApplicationRefsInTarget(target);
            for (ApplicationRef ref : applicationRefs) {
                Application app = me.getApplications().getApplication(ref.getRef());
                if (app == null) continue;
                apps.add(app);
            }
            return apps;
        }

        public static String getVirtualServersForApplication(Domain d, String target, String appName) {
            ApplicationRef appRef = d.getApplicationRefInTarget(appName, target);
            if (appRef != null) {
                return appRef.getVirtualServers();
            }
            return null;
        }

        public static String getEnabledForApplication(Domain d, String target, String appName) {
            ApplicationRef appRef = d.getApplicationRefInTarget(appName, target);
            if (appRef != null) {
                return appRef.getEnabled();
            }
            return null;
        }

        public static ReferenceContainer getReferenceContainerNamed(Domain d, String name) {
            Cluster c = Duck.getClusterNamed(d, name);
            if (c != null) {
                return c;
            }
            return Duck.getServerNamed(d, name);
        }

        public static List<ReferenceContainer> getReferenceContainersOf(Domain d, Config config) {
            LinkedList<ReferenceContainer> sub = new LinkedList<ReferenceContainer>();
            String name = null;
            if (config != null) {
                name = config.getName();
            }
            if (!StringUtils.ok(name)) {
                return sub;
            }
            List<ReferenceContainer> all = Duck.getAllReferenceContainers(d);
            for (ReferenceContainer rc : all) {
                if (!name.equals(rc.getReference())) continue;
                sub.add(rc);
            }
            return sub;
        }

        public static List<ReferenceContainer> getAllReferenceContainers(Domain d) {
            LinkedList<ReferenceContainer> referenceContainers = new LinkedList<ReferenceContainer>();
            referenceContainers.addAll(d.getServers().getServer());
            referenceContainers.addAll(d.getClusters().getCluster());
            return referenceContainers;
        }

        public static Cluster getClusterForInstance(Domain d, String instanceName) {
            List<Cluster> clusterList = d.getClusters().getCluster();
            for (Cluster cluster : clusterList) {
                List<ServerRef> serverRefs = cluster.getServerRef();
                for (ServerRef serverRef : serverRefs) {
                    if (!serverRef.getRef().equals(instanceName)) continue;
                    return cluster;
                }
            }
            return null;
        }

        public static boolean isServer(Domain d, String name) {
            Server server = d.getServerNamed(name);
            return server != null;
        }

        public static <P extends DomainExtension> boolean checkIfExtensionExists(Domain d, Class<P> configBeanType) {
            for (DomainExtension extension : d.getExtensions()) {
                try {
                    configBeanType.cast(extension);
                    return true;
                }
                catch (Exception exception) {
                }
            }
            return false;
        }
    }
}

