/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.servermgmt.cli;

import com.sun.enterprise.admin.cli.Environment;
import com.sun.enterprise.admin.cli.ProgramOptions;
import com.sun.enterprise.admin.cli.remote.DASUtils;
import com.sun.enterprise.admin.cli.remote.RemoteCLICommand;
import com.sun.enterprise.admin.servermgmt.cli.ListDomainsCommand;
import com.sun.enterprise.admin.servermgmt.cli.LocalDomainCommand;
import com.sun.enterprise.admin.servermgmt.cli.Strings;
import com.sun.enterprise.universal.process.ProcessUtils;
import com.sun.enterprise.util.io.FileUtils;
import com.sun.enterprise.util.net.NetUtils;
import jakarta.inject.Inject;
import java.io.File;
import java.lang.annotation.Annotation;
import java.util.Map;
import java.util.logging.Level;
import org.glassfish.api.Param;
import org.glassfish.api.admin.CommandException;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.hk2.api.ServiceLocator;
import org.jvnet.hk2.annotations.Service;

@Service(name="stop-domain")
@PerLookup
public class StopDomainCommand
extends LocalDomainCommand {
    @Inject
    ServiceLocator serviceLocator;
    @Param(name="domain_name", primary=true, optional=true)
    private String userArgDomainName;
    @Param(name="force", optional=true, defaultValue="true")
    Boolean force;
    @Param(optional=true, defaultValue="false")
    Boolean kill;
    private static final long WAIT_FOR_DAS_TIME_MS = 60000L;

    @Override
    protected void validate() throws CommandException {
        this.setDomainName(this.userArgDomainName);
        super.validate();
    }

    @Override
    protected void initDomain() throws CommandException {
        if (NetUtils.isThisHostLocal((String)this.programOpts.getHost())) {
            super.initDomain();
        } else if (this.userArgDomainName != null) {
            throw new CommandException(Strings.get("StopDomain.noDomainNameAllowed"));
        }
    }

    protected int executeCommand() throws CommandException {
        if (this.isLocal()) {
            if (this.getServerDirs().getLocalPassword() == null) {
                return this.dasNotRunning();
            }
            this.programOpts.setHostAndPort(this.getAdminAddress());
            logger.log(Level.FINER, "Stopping local domain on port {0}", this.programOpts.getPort());
            this.programOpts.setInteractive(false);
            if (!this.isThisDAS(this.getDomainRootDir())) {
                return this.dasNotRunning();
            }
            logger.finer("It's the correct DAS");
        } else {
            if (!DASUtils.pingDASQuietly((ProgramOptions)this.programOpts, (Environment)this.env)) {
                return this.dasNotRunning();
            }
            logger.finer("DAS is running");
            this.programOpts.setInteractive(false);
        }
        this.doCommand();
        return 0;
    }

    protected int dasNotRunning() throws CommandException {
        if (this.kill.booleanValue()) {
            if (this.isLocal()) {
                return this.kill();
            }
            throw new CommandException(Strings.get("StopDomain.dasNotRunningRemotely"));
        }
        if (this.isLocal()) {
            ListDomainsCommand listDomains = (ListDomainsCommand)((Object)this.serviceLocator.getService(ListDomainsCommand.class, new Annotation[0]));
            StringBuilder runningDomains = new StringBuilder();
            try {
                Map<String, Boolean> domains = listDomains.getDomains();
                for (Map.Entry<String, Boolean> entry : domains.entrySet()) {
                    String domain = entry.getKey();
                    if (!entry.getValue().booleanValue()) continue;
                    runningDomains.append("\n").append(domain);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (runningDomains.length() < 1) {
                logger.warning(Strings.get("StopDomain.noDomainsRunning", this.getDomainRootDir()));
            } else {
                logger.warning(Strings.get("StopDomain.selectedDomainNotRunning", this.getDomainRootDir(), runningDomains));
            }
        } else {
            logger.warning(Strings.get("StopDomain.dasNotRunningRemotely"));
        }
        return 1;
    }

    protected void doCommand() throws CommandException {
        RemoteCLICommand cmd = new RemoteCLICommand(this.getName(), this.programOpts, this.env);
        try {
            cmd.executeAndReturnOutput(new String[]{"stop-domain", "--force", this.force.toString()});
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.waitForDeath();
        }
        catch (CommandException ex) {
            if (this.kill.booleanValue() && this.isLocal()) {
                this.kill();
            }
            throw ex;
        }
    }

    protected void waitForDeath() throws CommandException {
        if (!this.programOpts.isTerse()) {
            System.out.print(Strings.get("StopDomain.WaitDASDeath") + " ");
        }
        long startWait = System.currentTimeMillis();
        boolean alive = true;
        int count = 0;
        while (!this.timedOut(startWait)) {
            if (!this.isRunning()) {
                alive = false;
                break;
            }
            try {
                Thread.sleep(100L);
                if (this.programOpts.isTerse() || count++ % 10 != 0) continue;
                System.out.print(".");
            }
            catch (InterruptedException interruptedException) {}
        }
        if (!this.programOpts.isTerse()) {
            System.out.println();
        }
        if (alive) {
            throw new CommandException(Strings.get("StopDomain.DASNotDead", 60L));
        }
    }

    private boolean timedOut(long startTime) {
        return System.currentTimeMillis() - startTime > 60000L;
    }

    protected int kill() throws CommandException {
        File prevPid = null;
        String pids = null;
        try {
            prevPid = new File(this.getServerDirs().getPidFile().getPath() + ".prev");
            if (!prevPid.canRead()) {
                throw new CommandException(Strings.get("StopDomain.nopidprev", prevPid));
            }
            pids = FileUtils.readSmallFile((File)prevPid).trim();
            String s = ProcessUtils.kill((int)Integer.parseInt(pids));
            if (s != null) {
                logger.finer(s);
            }
        }
        catch (CommandException ce) {
            throw ce;
        }
        catch (Exception ex) {
            throw new CommandException(Strings.get("StopDomain.pidprevreaderror", prevPid, ex.getMessage()));
        }
        return 0;
    }
}

