/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.servermgmt.services;

import com.sun.enterprise.admin.servermgmt.services.AppserverServiceType;
import com.sun.enterprise.admin.servermgmt.services.NonSMFServiceAdapter;
import com.sun.enterprise.admin.servermgmt.services.ServiceAdapter;
import com.sun.enterprise.admin.servermgmt.services.ServicesUtils;
import com.sun.enterprise.admin.servermgmt.services.Strings;
import com.sun.enterprise.universal.process.ProcessManagerException;
import com.sun.enterprise.util.OS;
import com.sun.enterprise.util.ObjectAnalyzer;
import com.sun.enterprise.util.io.ServerDirs;
import java.io.File;
import java.util.Map;
import java.util.stream.Collectors;

public class LinuxSystemDService
extends NonSMFServiceAdapter {
    private String targetName;
    File target;
    private static final String TEMPLATE_FILE_NAME = "linux-systemd-service.template";

    static boolean apropos() {
        return OS.isLinuxSystemDBased();
    }

    LinuxSystemDService(ServerDirs dirs, AppserverServiceType type) {
        super(dirs, type);
        if (!LinuxSystemDService.apropos()) {
            throw new IllegalArgumentException(Strings.get("internal.error", "Constructor called but Linux SystemD Services are not available."));
        }
    }

    @Override
    public void initializeInternal() {
        try {
            this.setTemplateFile(TEMPLATE_FILE_NAME);
            this.checkFileSystem();
            this.setTarget();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception ex) {
            throw (ServiceAdapter)this.new ServiceAdapter.OSServiceAdapterException(ex);
        }
    }

    @Override
    public final void createServiceInternal() {
        try {
            this.getTokenMap().put("PID_FILE", this.info.serverDirs.getPidFile().getPath());
            this.getTokenMap().put("SERVICE_PROPERTIES", this.formatAsServiceEnvironmentRecords(this.tokensAndValues()));
            this.handlePreExisting(this.info.force);
            if (this.info.dryRun) {
                this.trace(Strings.get("dryrun"));
            } else {
                ServicesUtils.tokenReplaceTemplateAtDestination(this.getTokenMap(), this.getTemplateFile().getPath(), this.target.getPath());
                this.trace("Target file written: " + this.target);
                this.trace("**********   Object Dump  **********\n" + this.toString());
                this.install();
            }
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw (ServiceAdapter)this.new ServiceAdapter.OSServiceAdapterException(ex);
        }
    }

    @Override
    public final void deleteServiceInternal() {
        try {
            if (this.info.dryRun) {
                this.trace(Strings.get("dryrun"));
            }
            this.uninstall();
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw (ServiceAdapter)this.new ServiceAdapter.OSServiceAdapterException(ex);
        }
    }

    @Override
    public final String getSuccessMessage() {
        if (this.info.dryRun) {
            return Strings.get("dryrun");
        }
        return Strings.get("LinuxSystemDServiceCreated", this.info.serviceName, this.info.type.toString(), this.target, this.getServiceUser(), this.target.getName());
    }

    @Override
    public final void writeReadmeFile(String msg) {
        File f = new File(this.getServerDirs().getServerDir(), "PlatformServices.log");
        ServicesUtils.appendTextToFile(f, msg);
    }

    public final String toString() {
        return ObjectAnalyzer.toStringWithSuper((Object)this);
    }

    @Override
    public final String getLocationArgsStart() {
        if (this.isDomain()) {
            return " --domaindir " + this.getServerDirs().getServerParentDir().getPath() + " ";
        }
        return " --nodedir " + this.getServerDirs().getServerGrandParentDir().getPath() + " --node " + this.getServerDirs().getServerParentDir().getName() + " ";
    }

    @Override
    public final String getLocationArgsStop() {
        return this.getLocationArgsStart();
    }

    private void checkFileSystem() {
        File configDir = new File("/etc/systemd/system");
        this.checkDir(configDir, "no_systemd");
    }

    private void checkDir(File dir, String notDirMsg) {
        if (!dir.isDirectory()) {
            throw new RuntimeException(Strings.get(notDirMsg, dir));
        }
        if (!dir.canWrite()) {
            throw new RuntimeException(Strings.get("no_write_dir", dir));
        }
    }

    private void handlePreExisting(boolean force) {
        boolean result;
        if (this.isPreExisting() && force && (!(result = this.target.delete()) || this.isPreExisting())) {
            throw new RuntimeException(Strings.get("services.alreadyCreated", this.target, "rm"));
        }
    }

    private boolean isPreExisting() {
        return this.target.isFile();
    }

    private void install() throws ProcessManagerException {
    }

    int uninstall() {
        if (this.info.dryRun) {
            this.dryRun("Would have deleted: " + this.target);
        } else if (this.target.delete()) {
            this.trace("Deleted " + this.target);
        }
        return 0;
    }

    private void setTarget() {
        this.targetName = "payara_" + this.info.serverDirs.getServerName() + ".service";
        this.target = new File("/etc/systemd/system", this.targetName);
    }

    private String formatAsServiceEnvironmentRecords(Map<String, String> tokensAndValues) {
        return tokensAndValues.entrySet().stream().map(entry -> "Environment=" + (String)entry.getKey() + "=" + (String)entry.getValue()).collect(Collectors.joining("\n"));
    }
}

