/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.notification.eventbus.core;

import com.sun.enterprise.util.Utility;
import fish.payara.internal.notification.PayaraConfiguredNotifier;
import fish.payara.internal.notification.PayaraNotification;
import fish.payara.micro.cdi.Outbound;
import fish.payara.notification.eventbus.core.CDIEventbusNotifierConfiguration;
import fish.payara.notification.eventbus.core.model.CDIEventbusMessage;
import jakarta.enterprise.inject.spi.CDI;
import jakarta.inject.Inject;
import java.lang.annotation.Annotation;
import java.util.logging.Logger;
import org.glassfish.api.logging.LogLevel;
import org.glassfish.hk2.runlevel.RunLevel;
import org.glassfish.internal.data.ApplicationRegistry;
import org.jvnet.hk2.annotations.Service;

@Service(name="cdieventbus-notifier")
@RunLevel(value=10)
public class CDIEventbusNotifierService
extends PayaraConfiguredNotifier<CDIEventbusNotifierConfiguration> {
    private static final Logger LOGGER = Logger.getLogger(CDIEventbusNotifierService.class.getName());
    @Inject
    private ApplicationRegistry appRegistry;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleNotification(PayaraNotification event) {
        for (String appName : this.appRegistry.getAllApplicationNames()) {
            ClassLoader oldCL = null;
            try {
                ClassLoader appCl = this.appRegistry.get(appName).getAppClassLoader();
                if (appCl == null) continue;
                oldCL = Utility.setContextClassLoader((ClassLoader)appCl);
                CDI.current();
                this.sendNotification(event);
            }
            catch (IllegalStateException e) {
                LOGGER.log(LogLevel.FINE, "CDIEventbusNotifierService.handleNotification: not a CDI application", e);
            }
            finally {
                Utility.setContextClassLoader(oldCL);
            }
        }
    }

    private void sendNotification(final PayaraNotification notification) {
        CDIEventbusMessage event = new CDIEventbusMessage(notification);
        CDI.current().getBeanManager().getEvent().select(new Annotation[]{new Outbound(){

            @Override
            public String eventName() {
                return "";
            }

            @Override
            public boolean loopBack() {
                return Boolean.valueOf(((CDIEventbusNotifierConfiguration)CDIEventbusNotifierService.this.configuration).getLoopBack());
            }

            @Override
            public String[] instanceName() {
                return new String[]{notification.getInstanceName()};
            }

            @Override
            public Class<? extends Annotation> annotationType() {
                return Outbound.class;
            }
        }}).fire((Object)event);
    }
}

