/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.audit.admin;

import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.util.ColumnFormatter;
import fish.payara.audit.AdminAuditConfiguration;
import fish.payara.internal.notification.NotifierUtils;
import fish.payara.internal.notification.PayaraNotifier;
import jakarta.inject.Inject;
import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.glassfish.api.ActionReport;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.CommandLock;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RestEndpoint;
import org.glassfish.api.admin.RestEndpoints;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.hk2.api.ActiveDescriptor;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.hk2.api.ServiceHandle;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.internal.api.Target;
import org.jvnet.hk2.annotations.Service;

@Service(name="get-admin-audit-configuration")
@PerLookup
@CommandLock(value=CommandLock.LockType.NONE)
@ExecuteOn(value={RuntimeType.DAS, RuntimeType.INSTANCE})
@TargetType(value={CommandTarget.DAS, CommandTarget.STANDALONE_INSTANCE, CommandTarget.CLUSTER, CommandTarget.CLUSTERED_INSTANCE, CommandTarget.CONFIG, CommandTarget.DEPLOYMENT_GROUP})
@RestEndpoints(value={@RestEndpoint(configBean=AdminAuditConfiguration.class, opType=RestEndpoint.OpType.GET, path="get-admin-audit-configuration", description="Gets the current configuration settings of the admin audit Service")})
public class GetAdminAuditServiceConfiguration
implements AdminCommand {
    private static final String[] ATTRIBUTE_HEADERS = new String[]{"Enabled", "Audit Level"};
    private static final String[] NOTIFIER_HEADERS = new String[]{"Name", "Notifier Enabled"};
    @Inject
    ServiceLocator serviceLocator;
    @Param(name="target", optional=true, defaultValue="server")
    private String target;
    private Config targetConfig;
    @Inject
    private Target targetUtil;

    public void execute(AdminCommandContext context) {
        ActionReport actionReport = context.getActionReport();
        ColumnFormatter columnFormatter = new ColumnFormatter(ATTRIBUTE_HEADERS);
        ColumnFormatter notifiersColumnFormatter = new ColumnFormatter(NOTIFIER_HEADERS);
        this.targetConfig = this.targetUtil.getConfig(this.target);
        AdminAuditConfiguration config = (AdminAuditConfiguration)this.targetConfig.getExtensionByType(AdminAuditConfiguration.class);
        Object[] configValues = new Object[]{config.getEnabled(), config.getAuditLevel()};
        columnFormatter.addRow(configValues);
        HashMap<String, String> map = new HashMap<String, String>();
        Properties extraProperties = new Properties();
        map.put("enabled", config.getEnabled());
        map.put("auditLevel", config.getAuditLevel());
        extraProperties.put("adminauditConfiguration", map);
        ActionReport notifiersReport = actionReport.addSubActionsReport();
        List allNotifierServiceHandles = this.serviceLocator.getAllServiceHandles(PayaraNotifier.class, new Annotation[0]);
        Properties notifierProps = new Properties();
        if (!config.getNotifierList().isEmpty()) {
            List<String> notifiers = config.getNotifierList();
            for (ServiceHandle serviceHandle : allNotifierServiceHandles) {
                String notifierClassName = serviceHandle.getActiveDescriptor().getImplementationClass().getSimpleName();
                String notifierName = NotifierUtils.getNotifierName((ActiveDescriptor)serviceHandle.getActiveDescriptor());
                Object[] values = new Object[]{notifierName, notifiers.contains(notifierName)};
                notifiersColumnFormatter.addRow(values);
                HashMap<String, Object> mapNotifiers = new HashMap<String, Object>(2);
                mapNotifiers.put("notifierName", values[0]);
                mapNotifiers.put("notifierEnabled", values[1]);
                notifierProps.put("notifierList" + notifierClassName, mapNotifiers);
            }
        }
        notifiersReport.setMessage(notifiersColumnFormatter.toString());
        extraProperties.putAll((Map<?, ?>)notifierProps);
        actionReport.setExtraProperties(extraProperties);
        actionReport.setMessage(columnFormatter.toString());
        actionReport.setActionExitCode(ActionReport.ExitCode.SUCCESS);
    }
}

