/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.spi.persistence.support.sqlstore.impl;

import com.sun.jdo.api.persistence.support.ConnectionFactory;
import com.sun.jdo.api.persistence.support.JDOException;
import com.sun.jdo.api.persistence.support.JDOFatalInternalException;
import com.sun.jdo.api.persistence.support.JDOUnsupportedOptionException;
import com.sun.jdo.api.persistence.support.JDOUserException;
import com.sun.jdo.spi.persistence.support.sqlstore.LogHelperPersistenceManager;
import com.sun.jdo.spi.persistence.support.sqlstore.PersistenceManager;
import com.sun.jdo.spi.persistence.support.sqlstore.PersistenceManagerFactory;
import com.sun.jdo.spi.persistence.support.sqlstore.PersistenceStore;
import com.sun.jdo.spi.persistence.support.sqlstore.SQLStoreManager;
import com.sun.jdo.spi.persistence.support.sqlstore.Transaction;
import com.sun.jdo.spi.persistence.support.sqlstore.VersionConsistencyCache;
import com.sun.jdo.spi.persistence.support.sqlstore.ejb.EJBHelper;
import com.sun.jdo.spi.persistence.support.sqlstore.impl.PersistenceManagerImpl;
import com.sun.jdo.spi.persistence.support.sqlstore.impl.PersistenceManagerWrapper;
import com.sun.jdo.spi.persistence.support.sqlstore.impl.VersionConsistencyCacheImpl;
import com.sun.jdo.spi.persistence.utility.BucketizedHashtable;
import com.sun.jdo.spi.persistence.utility.logging.Logger;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import javax.sql.DataSource;
import org.glassfish.persistence.common.I18NHelper;

public class SQLPersistenceManagerFactory
implements PersistenceManagerFactory {
    private PersistenceStore _store = null;
    private ConnectionFactory _connectionFactory = null;
    private Object _dataSource = null;
    private com.sun.jdo.api.persistence.support.PersistenceManagerFactory _persistenceManagerFactory = null;
    private boolean optimistic = true;
    private boolean retainValues = true;
    private boolean nontransactionalRead = true;
    private boolean ignoreCache = true;
    private int queryTimeout = 0;
    private int updateTimeout = 0;
    private int minPool = 0;
    private int maxPool = 0;
    private static Logger logger = LogHelperPersistenceManager.getLogger();
    private static final ResourceBundle messages = I18NHelper.loadBundle("com.sun.jdo.spi.persistence.support.sqlstore.Bundle", SQLPersistenceManagerFactory.class.getClassLoader());
    private static int pmCacheBucketSize = Integer.getInteger("com.sun.jdo.spi.persistence.support.sqlstore.impl.SQLPersistenceManagerFactory.pmCacheBucketSize", 11);
    private static int pmCacheInitialCapacity = Integer.getInteger("com.sun.jdo.spi.persistence.support.sqlstore.impl.SQLPersistenceManagerFactory.pmCacheInitialCapacity", 11 * pmCacheBucketSize);
    private Map pmCache = new BucketizedHashtable(pmCacheBucketSize, pmCacheInitialCapacity);
    private VersionConsistencyCache vcCache = null;

    public SQLPersistenceManagerFactory() {
    }

    public SQLPersistenceManagerFactory(Object connectionFactory) {
        if (connectionFactory instanceof ConnectionFactory) {
            this._connectionFactory = (ConnectionFactory)connectionFactory;
        } else {
            this._dataSource = connectionFactory;
        }
        if (this instanceof com.sun.jdo.api.persistence.support.PersistenceManagerFactory) {
            this._persistenceManagerFactory = this;
        }
        this.initialize();
    }

    public SQLPersistenceManagerFactory(com.sun.jdo.api.persistence.support.PersistenceManagerFactory persistenceManagerFactory) {
        this._persistenceManagerFactory = persistenceManagerFactory;
        Object cf = this._persistenceManagerFactory.getConnectionFactory();
        if (cf instanceof ConnectionFactory) {
            this._connectionFactory = (ConnectionFactory)cf;
        } else {
            this._dataSource = cf;
        }
        this.initialize();
    }

    @Override
    public void setConnectionUserName(String userName) {
        throw new JDOUnsupportedOptionException(I18NHelper.getMessage(messages, "jdo.persistencemanagerfactoryimpl.notsupported"));
    }

    @Override
    public String getConnectionUserName() {
        return this._persistenceManagerFactory.getConnectionUserName();
    }

    @Override
    public void setConnectionPassword(char[] password) {
        throw new JDOUnsupportedOptionException(I18NHelper.getMessage(messages, "jdo.persistencemanagerfactoryimpl.notsupported"));
    }

    @Override
    public void setConnectionURL(String url) {
        throw new JDOUnsupportedOptionException(I18NHelper.getMessage(messages, "jdo.persistencemanagerfactoryimpl.notsupported"));
    }

    @Override
    public String getConnectionURL() {
        return this._persistenceManagerFactory.getConnectionURL();
    }

    @Override
    public void setConnectionDriverName(String driverName) {
        throw new JDOUnsupportedOptionException(I18NHelper.getMessage(messages, "jdo.persistencemanagerfactoryimpl.notsupported"));
    }

    @Override
    public String getConnectionDriverName() {
        return this._persistenceManagerFactory.getConnectionDriverName();
    }

    @Override
    public void setConnectionFactory(Object cf) {
        throw new JDOUnsupportedOptionException(I18NHelper.getMessage(messages, "jdo.persistencemanagerfactoryimpl.notsupported"));
    }

    @Override
    public Object getConnectionFactory() {
        if (this._dataSource != null) {
            return this._dataSource;
        }
        return this._connectionFactory;
    }

    @Override
    public void setOptimistic(boolean flag) {
        throw new JDOUnsupportedOptionException(I18NHelper.getMessage(messages, "jdo.persistencemanagerfactoryimpl.notsupported"));
    }

    @Override
    public boolean getOptimistic() {
        return this._persistenceManagerFactory.getOptimistic();
    }

    @Override
    public void setRetainValues(boolean flag) {
        throw new JDOUnsupportedOptionException(I18NHelper.getMessage(messages, "jdo.persistencemanagerfactoryimpl.notsupported"));
    }

    @Override
    public boolean getRetainValues() {
        return this._persistenceManagerFactory.getRetainValues();
    }

    @Override
    public void setNontransactionalRead(boolean flag) {
        throw new JDOUnsupportedOptionException(I18NHelper.getMessage(messages, "jdo.persistencemanagerfactoryimpl.notsupported"));
    }

    @Override
    public boolean getNontransactionalRead() {
        return this._persistenceManagerFactory.getNontransactionalRead();
    }

    @Override
    public void setIgnoreCache(boolean flag) {
        throw new JDOUnsupportedOptionException(I18NHelper.getMessage(messages, "jdo.persistencemanagerfactoryimpl.notsupported"));
    }

    @Override
    public boolean getIgnoreCache() {
        return this._persistenceManagerFactory.getIgnoreCache();
    }

    @Override
    public void setQueryTimeout(int timeout) {
        throw new JDOUnsupportedOptionException(I18NHelper.getMessage(messages, "jdo.persistencemanagerfactoryimpl.notsupported"));
    }

    @Override
    public int getQueryTimeout() {
        return this._persistenceManagerFactory.getQueryTimeout();
    }

    @Override
    public void setConnectionMaxPool(int MaxPool) {
        throw new JDOUnsupportedOptionException(I18NHelper.getMessage(messages, "jdo.persistencemanagerfactoryimpl.notsupported"));
    }

    @Override
    public int getConnectionMaxPool() {
        return this._persistenceManagerFactory.getConnectionMaxPool();
    }

    @Override
    public void setConnectionMinPool(int MinPool) {
        throw new JDOUnsupportedOptionException(I18NHelper.getMessage(messages, "jdo.persistencemanagerfactoryimpl.notsupported"));
    }

    @Override
    public int getConnectionMinPool() {
        return this._persistenceManagerFactory.getConnectionMinPool();
    }

    @Override
    public void setConnectionMsWait(int MsWait) {
        throw new JDOUnsupportedOptionException(I18NHelper.getMessage(messages, "jdo.persistencemanagerfactoryimpl.notsupported"));
    }

    @Override
    public int getConnectionMsWait() {
        return this._persistenceManagerFactory.getConnectionMsWait();
    }

    @Override
    public void setConnectionMsInterval(int MsInterval) {
        throw new JDOUnsupportedOptionException(I18NHelper.getMessage(messages, "jdo.persistencemanagerfactoryimpl.notsupported"));
    }

    @Override
    public int getConnectionMsInterval() {
        return this._persistenceManagerFactory.getConnectionMsInterval();
    }

    @Override
    public void setConnectionLoginTimeout(int LoginTimeout) {
        throw new JDOUnsupportedOptionException(I18NHelper.getMessage(messages, "jdo.persistencemanagerfactoryimpl.notsupported"));
    }

    @Override
    public int getConnectionLoginTimeout() {
        return this._persistenceManagerFactory.getConnectionLoginTimeout();
    }

    @Override
    public void setConnectionLogWriter(PrintWriter pw) {
        throw new JDOUnsupportedOptionException(I18NHelper.getMessage(messages, "jdo.persistencemanagerfactoryimpl.notsupported"));
    }

    @Override
    public PrintWriter getConnectionLogWriter() {
        return this._persistenceManagerFactory.getConnectionLogWriter();
    }

    @Override
    public void setConnectionTransactionIsolation(int level) {
        throw new JDOUnsupportedOptionException(I18NHelper.getMessage(messages, "jdo.persistencemanagerfactoryimpl.notsupported"));
    }

    @Override
    public int getConnectionTransactionIsolation() {
        return this._persistenceManagerFactory.getConnectionTransactionIsolation();
    }

    @Override
    public void setConnectionFactoryName(String connectionFactoryName) {
        throw new JDOUnsupportedOptionException(I18NHelper.getMessage(messages, "jdo.persistencemanagerfactoryimpl.notsupported"));
    }

    @Override
    public String getConnectionFactoryName() {
        return this._persistenceManagerFactory.getConnectionFactoryName();
    }

    @Override
    public void setIdentifier(String identifier) {
        throw new JDOUnsupportedOptionException(I18NHelper.getMessage(messages, "jdo.persistencemanagerfactoryimpl.notsupported"));
    }

    @Override
    public String getIdentifier() {
        return this._persistenceManagerFactory.getIdentifier();
    }

    @Override
    public int getMaxPool() {
        return this.maxPool;
    }

    @Override
    public void setMaxPool(int MaxPool) {
        throw new JDOUnsupportedOptionException(I18NHelper.getMessage(messages, "jdo.persistencemanagerfactoryimpl.notsupported"));
    }

    @Override
    public int getMinPool() {
        return this.minPool;
    }

    @Override
    public void setMinPool(int MinPool) {
        throw new JDOUnsupportedOptionException(I18NHelper.getMessage(messages, "jdo.persistencemanagerfactoryimpl.notsupported"));
    }

    @Override
    public void setUpdateTimeout(int timeout) {
        throw new JDOUnsupportedOptionException(I18NHelper.getMessage(messages, "jdo.persistencemanagerfactoryimpl.notsupported"));
    }

    @Override
    public int getUpdateTimeout() {
        return this._persistenceManagerFactory.getUpdateTimeout();
    }

    @Override
    public boolean getSupersedeDeletedInstance() {
        return this._persistenceManagerFactory.getSupersedeDeletedInstance();
    }

    @Override
    public void setSupersedeDeletedInstance(boolean flag) {
        throw new JDOUnsupportedOptionException(I18NHelper.getMessage(messages, "jdo.persistencemanagerfactoryimpl.notsupported"));
    }

    @Override
    public boolean getRequireCopyObjectId() {
        return this._persistenceManagerFactory.getRequireCopyObjectId();
    }

    @Override
    public void setRequireCopyObjectId(boolean flag) {
        throw new JDOUnsupportedOptionException(I18NHelper.getMessage(messages, "jdo.persistencemanagerfactoryimpl.notsupported"));
    }

    @Override
    public boolean getRequireTrackedSCO() {
        return this._persistenceManagerFactory.getRequireTrackedSCO();
    }

    @Override
    public void setRequireTrackedSCO(boolean flag) {
        throw new JDOUnsupportedOptionException(I18NHelper.getMessage(messages, "jdo.persistencemanagerfactoryimpl.notsupported"));
    }

    @Override
    public com.sun.jdo.api.persistence.support.PersistenceManager getPersistenceManager() {
        return this.getPersistenceManager(null, null);
    }

    @Override
    public com.sun.jdo.api.persistence.support.PersistenceManager getPersistenceManager(String username, char[] password) {
        Object[] items;
        boolean debug = logger.isLoggable(300);
        if (this._connectionFactory == null && this._dataSource == null) {
            throw new JDOUserException(I18NHelper.getMessage(messages, "jdo.persistencemanagerfactoryimpl.getpersistencemanager.notconfigured"));
        }
        if (debug) {
            logger.finest("sqlstore.sqlpersistencemgrfactory.getpersistencemgr", (Object)Thread.currentThread());
        }
        PersistenceManagerImpl pm = null;
        jakarta.transaction.Transaction t = EJBHelper.getTransaction();
        if (t != null) {
            if (debug) {
                items = new Object[]{Thread.currentThread(), t};
                logger.finest("sqlstore.sqlpersistencemgrfactory.getpersistencemgr.found", items);
            }
            if ((pm = (PersistenceManagerImpl)this.pmCache.get(t)) == null) {
                pm = this.getFromPool(t, username, password);
                this.pmCache.put(t, pm);
            } else if (pm.isClosed()) {
                if (debug) {
                    items = new Object[]{Thread.currentThread(), t};
                    logger.finest("sqlstore.sqlpersistencemgrfactory.getpersistencemgr.pmclosedfor", items);
                }
                throw new JDOFatalInternalException(I18NHelper.getMessage(messages, "jdo.persistencemanagerfactoryimpl.getpersistencemanager.closed", t));
            }
            Transaction tx = (Transaction)pm.currentTransaction();
            if (debug) {
                logger.finest("sqlstore.sqlpersistencemgrfactory.getpersistencemgr.jdotx", (Object)tx);
            }
            if (!tx.isActive()) {
                tx.begin(t);
            }
            if (!pm.verify(username, password)) {
                throw new JDOUserException(I18NHelper.getMessage(messages, "jdo.persistencemanagerfactoryimpl.getpersistencemanager.error"));
            }
        } else {
            if (debug) {
                logger.finest("sqlstore.sqlpersistencemgrfactory.getpersistencemgr.jdotx.notfound");
            }
            pm = this.getFromPool(null, username, password);
        }
        if (debug) {
            items = new Object[]{Thread.currentThread(), pm, t};
            logger.finest("sqlstore.sqlpersistencemgrfactory.getpersistencemgr.pmt", items);
        }
        return new PersistenceManagerWrapper(pm);
    }

    @Override
    public Properties getProperties() {
        return this._persistenceManagerFactory.getProperties();
    }

    public com.sun.jdo.api.persistence.support.PersistenceManagerFactory getPersistenceManagerFactory() {
        return this._persistenceManagerFactory;
    }

    @Override
    public void registerPersistenceManager(PersistenceManager pm, jakarta.transaction.Transaction t) {
        com.sun.jdo.api.persistence.support.PersistenceManager pm1;
        boolean debug = logger.isLoggable(300);
        if (debug) {
            Object[] items = new Object[]{pm, t};
            logger.finest("sqlstore.sqlpersistencemgrfactory.registerpersistencemgr.pmt", items);
        }
        if ((pm1 = (com.sun.jdo.api.persistence.support.PersistenceManager)this.pmCache.get(t)) == null) {
            this.pmCache.put(t, pm);
            ((PersistenceManagerImpl)pm).setJTATransaction(t);
            return;
        }
        if (pm1 != pm) {
            Object[] items = new Object[]{t, pm1};
            throw new JDOFatalInternalException(I18NHelper.getMessage(messages, "jdo.persistencemanagerfactoryimpl.registerpm.registered", items));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PersistenceManagerImpl getFromPool(jakarta.transaction.Transaction tx, String username, char[] password) {
        boolean debug = logger.isLoggable(300);
        if (debug) {
            logger.finest("sqlstore.sqlpersistencemgrfactory.getfrompool");
        }
        SQLPersistenceManagerFactory sQLPersistenceManagerFactory = this;
        synchronized (sQLPersistenceManagerFactory) {
            if (this._store == null) {
                this.initializeSQLStoreManager(username, password);
            }
        }
        PersistenceManagerImpl pm = new PersistenceManagerImpl(this, tx, username, password);
        pm.setStore(this._store);
        if (debug) {
            Object[] items = new Object[]{pm, tx};
            logger.finest("sqlstore.sqlpersistencemgrfactory.getfrompool.pmt", items);
        }
        return pm;
    }

    private void returnToPool(com.sun.jdo.api.persistence.support.PersistenceManager pm) {
        logger.finest("sqlstore.sqlpersistencemgrfactory.returnToPool");
    }

    @Override
    public void releasePersistenceManager(PersistenceManager pm, jakarta.transaction.Transaction t) {
        boolean debug = logger.isLoggable(300);
        if (debug) {
            Object[] items = new Object[]{pm, t};
            logger.finest("sqlstore.sqlpersistencemgrfactory.releasepm.pmt", items);
        }
        if (t != null) {
            com.sun.jdo.api.persistence.support.PersistenceManager pm1 = (com.sun.jdo.api.persistence.support.PersistenceManager)this.pmCache.get(t);
            if (pm1 == null || pm1 != pm) {
                Object[] items = new Object[]{t, pm1};
                throw new JDOFatalInternalException(I18NHelper.getMessage(messages, "jdo.persistencemanagerfactoryimpl.registerpm.registered", items));
            }
            this.pmCache.remove(t);
        } else {
            this.returnToPool(pm);
        }
    }

    private void initialize() {
        logger.finest("sqlstore.sqlpersistencemgrfactory.init");
        this.optimistic = this._persistenceManagerFactory.getOptimistic();
        this.retainValues = this._persistenceManagerFactory.getRetainValues();
        this.nontransactionalRead = this._persistenceManagerFactory.getNontransactionalRead();
        this.ignoreCache = this._persistenceManagerFactory.getIgnoreCache();
        this.queryTimeout = this._persistenceManagerFactory.getQueryTimeout();
        this.updateTimeout = this._persistenceManagerFactory.getUpdateTimeout();
        this.minPool = this._persistenceManagerFactory.getMinPool();
        this.maxPool = this._persistenceManagerFactory.getMaxPool();
    }

    private void initializeSQLStoreManager(String username, char[] password) {
        Connection conn = null;
        try {
            conn = this.getConnection(username, password);
            if (conn != null) {
                this._store = new SQLStoreManager(conn.getMetaData(), this.getIdentifier());
            }
        }
        catch (Exception e) {
            if (logger.isLoggable(900)) {
                logger.log(900, "jdo.sqlpersistencemanagerfactory.errorgettingDatabaseInfo", (Throwable)e);
            }
            if (e instanceof JDOException) {
                throw (JDOException)e;
            }
            throw new JDOFatalInternalException(I18NHelper.getMessage(messages, "core.configuration.getvendortypefailed"), e);
        }
        finally {
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    private Connection getConnection(String username, char[] password) throws SQLException {
        Connection conn = null;
        conn = this._connectionFactory != null ? this._connectionFactory.getConnection() : (EJBHelper.isManaged() ? EJBHelper.getConnection(this._dataSource, username, password) : (username == null ? ((DataSource)this._dataSource).getConnection() : ((DataSource)this._dataSource).getConnection(username, new String(password))));
        return conn;
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof SQLPersistenceManagerFactory) {
            SQLPersistenceManagerFactory pmf = (SQLPersistenceManagerFactory)obj;
            return pmf._persistenceManagerFactory.equals(this._persistenceManagerFactory);
        }
        return false;
    }

    public int hashCode() {
        return this._persistenceManagerFactory.hashCode();
    }

    @Override
    public VersionConsistencyCache getVersionConsistencyCache() {
        if (null == this.vcCache) {
            if (this._store == null) {
                throw new JDOFatalInternalException(I18NHelper.getMessage(messages, "jdo.persistencemanagerfactoryimpl.getversionconsistencycache.nullstore"));
            }
            this.vcCache = VersionConsistencyCacheImpl.create();
            this._store.getConfigCache().setVersionConsistencyCache(this.vcCache);
        }
        return this.vcCache;
    }

    static {
        if (logger.isLoggable(300)) {
            logger.finest("sqlstore.sqlpersistencemgrfactory.pmCacheBucketSize", (Object)String.valueOf(pmCacheBucketSize));
            logger.finest("sqlstore.sqlpersistencemgrfactory.pmCacheInitialCapacity", (Object)String.valueOf(pmCacheInitialCapacity));
        }
    }
}

