/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.spi.persistence.support.sqlstore.utility;

import java.text.MessageFormat;
import java.util.Vector;

public class StringScanner {
    private static String[] intStrTable = new String[2048];

    static int skipWhite(String s, int offset) {
        int end = s.length();
        if (offset < 0) {
            return end;
        }
        while (offset < end && Character.isWhitespace(s.charAt(offset))) {
            ++offset;
        }
        return offset;
    }

    static int skipTo(String s, int offset, String delim) {
        int end = s.length();
        if (offset < 0) {
            return end;
        }
        while (offset < end && delim.indexOf(s.charAt(offset)) == -1) {
            ++offset;
        }
        return offset;
    }

    static int skipTo(String s, int offset, char delim) {
        int end = s.length();
        if (offset < 0) {
            return end;
        }
        while (offset < end && delim != s.charAt(offset)) {
            ++offset;
        }
        return offset;
    }

    static char charAt(String s, int offset) {
        if (offset < 0 || offset >= s.length()) {
            return '\u0000';
        }
        return s.charAt(offset);
    }

    static int skipInt(String s, int offset) {
        int end = s.length();
        if (offset < 0 || !Character.isDigit(s.charAt(offset))) {
            return end;
        }
        while (offset < end && Character.isDigit(s.charAt(offset))) {
            ++offset;
        }
        return offset;
    }

    public static String format(StringBuilder buf, String fmt, Object o1) {
        return StringScanner.format(buf, fmt, 1, o1, null, null, null, null, null, null, null, null);
    }

    public static String format(StringBuilder buf, String fmt, Object o1, Object o2) {
        return StringScanner.format(buf, fmt, 2, o1, o2, null, null, null, null, null, null, null);
    }

    public static String format(StringBuilder buf, String fmt, Object o1, Object o2, Object o3) {
        return StringScanner.format(buf, fmt, 3, o1, o2, o3, null, null, null, null, null, null);
    }

    public static String format(StringBuilder buf, String fmt, Object o1, Object o2, Object o3, Object o4) {
        return StringScanner.format(buf, fmt, 4, o1, o2, o3, o4, null, null, null, null, null);
    }

    public static String format(StringBuilder buf, String fmt, Object o1, Object o2, Object o3, Object o4, Object o5) {
        return StringScanner.format(buf, fmt, 5, o1, o2, o3, o4, o5, null, null, null, null);
    }

    public static String format(StringBuilder buf, String fmt, Object o1, Object o2, Object o3, Object o4, Object o5, Object o6) {
        return StringScanner.format(buf, fmt, 6, o1, o2, o3, o4, o5, o6, null, null, null);
    }

    public static String format(StringBuilder buf, String fmt, Object o1, Object o2, Object o3, Object o4, Object o5, Object o6, Object o7) {
        return StringScanner.format(buf, fmt, 7, o1, o2, o3, o4, o5, o6, o7, null, null);
    }

    public static String format(StringBuilder buf, String fmt, Object o1, Object o2, Object o3, Object o4, Object o5, Object o6, Object o7, Object o8) {
        return StringScanner.format(buf, fmt, 8, o1, o2, o3, o4, o5, o6, o7, o8, null);
    }

    public static String format(StringBuilder buf, String fmt, Object o1, Object o2, Object o3, Object o4, Object o5, Object o6, Object o7, Object o8, Object o9) {
        return StringScanner.format(buf, fmt, 9, o1, o2, o3, o4, o5, o6, o7, o8, o9);
    }

    public static String format(StringBuilder buf, String fmt, int argcnt, Object o1, Object o2, Object o3, Object o4, Object o5, Object o6, Object o7, Object o8, Object o9) {
        int percent;
        Object[] params = new Object[]{o1, o2, o3, o4, o5, o6, o7, o8, o9};
        int i = 0;
        int begSubstr = 0;
        int nextParam = 0;
        StringBuilder msg = buf == null ? new StringBuilder() : buf;
        int fmtLen = fmt.length();
        while ((percent = fmt.indexOf(37, i)) >= 0 && percent < fmtLen - 1) {
            char c = fmt.charAt(percent + 1);
            boolean leftJustify = false;
            boolean raw = false;
            int nextChar = percent;
            if (c == '-') {
                leftJustify = true;
                if (++nextChar + 1 < fmtLen) {
                    c = fmt.charAt(nextChar + 1);
                }
            }
            if (Character.isDigit(c)) {
                int endInt = StringScanner.skipInt(fmt, nextChar + 1);
                int size = Integer.parseInt(fmt.substring(nextChar + 1, endInt));
                if (size == 0) {
                    raw = true;
                }
                msg.append(fmt.substring(begSubstr, percent));
                if (nextParam < argcnt) {
                    int j;
                    Object p = params[nextParam++];
                    String val = p.toString();
                    int len = val.length();
                    if (!raw) {
                        if (!leftJustify && len < size) {
                            for (j = 0; j < size - len; ++j) {
                                msg.append(" ");
                            }
                        } else if (len > size) {
                            val = val.substring(0, size);
                        }
                    }
                    msg.append(val);
                    if (leftJustify && len < size) {
                        for (j = 0; j < size - len; ++j) {
                            msg.append(" ");
                        }
                    }
                }
                begSubstr = i = endInt;
                continue;
            }
            i = nextChar + 1;
        }
        msg.append(fmt.substring(begSubstr, fmtLen));
        return msg.toString();
    }

    static String createParamString(String message, int argcnt, Object param1, Object param2, Object param3, Object param4, Object param5, Object param6, Object param7, Object param8, Object param9) {
        int esc;
        int lbrace;
        Object[] params;
        if (argcnt < 1 || argcnt > 9) {
            return message;
        }
        Object[] p = null;
        if (argcnt == 1) {
            p = params = new Object[]{param1};
        } else if (argcnt == 2) {
            p = params = new Object[]{param1, param2};
        } else if (argcnt == 3) {
            p = params = new Object[]{param1, param2, param3};
        } else if (argcnt == 4) {
            p = params = new Object[]{param1, param2, param3, param4};
        } else if (argcnt == 5) {
            p = params = new Object[]{param1, param2, param3, param4, param5};
        } else if (argcnt == 6) {
            p = params = new Object[]{param1, param2, param3, param4, param5, param6};
        } else if (argcnt == 7) {
            p = params = new Object[]{param1, param2, param3, param4, param5, param6, param7};
        } else if (argcnt == 8) {
            p = params = new Object[]{param1, param2, param3, param4, param5, param6, param7, param8};
        } else if (argcnt == 9) {
            p = params = new Object[]{param1, param2, param3, param4, param5, param6, param7, param8, param9};
        }
        boolean useJava = false;
        int rbrace = 0;
        int i = 0;
        while ((lbrace = message.indexOf(123, i)) >= 0) {
            rbrace = message.indexOf(125, lbrace + 1);
            if (rbrace < 0 || rbrace - lbrace > 2) {
                useJava = true;
                break;
            }
            i = rbrace + 1;
        }
        if (useJava) {
            return MessageFormat.format(message, p);
        }
        boolean foundEsc = false;
        StringBuilder msg = new StringBuilder();
        i = 0;
        while ((esc = message.indexOf(39, i)) >= 0) {
            msg.append(message.substring(i, esc));
            msg.append(message.substring(esc + 1, esc + 2));
            i = esc + 2;
            foundEsc = true;
        }
        if (foundEsc) {
            msg.append(message.substring(i, message.length()));
            message = msg.toString();
        }
        i = 0;
        int msglen = message.length();
        msg = new StringBuilder();
        while ((lbrace = message.indexOf(123, i)) >= 0 && lbrace < msglen - 1) {
            char c = message.charAt(lbrace + 1);
            if (Character.isDigit(c)) {
                int pnum = c - 48;
                if (0 <= pnum && pnum < argcnt) {
                    Object pp = p[pnum];
                    msg.append(message.substring(i, lbrace));
                    if (pp == null) {
                        msg.append("<null>");
                    } else {
                        msg.append(pp.toString());
                    }
                } else if (argcnt > 0) {
                    // empty if block
                }
                i = lbrace + 3;
                continue;
            }
            i = lbrace + 1;
        }
        msg.append(message.substring(i, msglen));
        return msg.toString();
    }

    public static String levelString(int level) {
        if (level <= 0) {
            return "";
        }
        switch (level) {
            case 1: {
                return "    ";
            }
            case 2: {
                return "        ";
            }
            case 3: {
                return "            ";
            }
            case 4: {
                return "                ";
            }
            case 5: {
                return "                    ";
            }
            case 6: {
                return "                       ";
            }
        }
        String str = "                       ";
        for (int i = 6; i < level; ++i) {
            str = str.concat("    ");
        }
        return str;
    }

    public static Vector splitString(String str, String delimeter) {
        Vector<String> list = new Vector<String>();
        if (str != null) {
            int mark = 0;
            int start = 0;
            int delLen = delimeter.length();
            while ((start = str.indexOf(delimeter, mark)) != -1) {
                if (start != 0) {
                    list.addElement(str.substring(mark, start));
                }
                mark = start + delLen;
            }
            if (mark < str.length()) {
                list.addElement(str.substring(mark));
            }
        }
        return list;
    }

    public static String fill(String str, int len, boolean left) {
        if (str == null) {
            str = "null";
        }
        int startLen = str.length();
        Object nstr = str;
        while (startLen < len) {
            int diff = len - startLen;
            if (diff >= 10) {
                startLen += 10;
                if (left) {
                    nstr = (String)nstr + "          ";
                    continue;
                }
                nstr = "          " + (String)nstr;
                continue;
            }
            if (diff >= 8) {
                startLen += 8;
                if (left) {
                    nstr = (String)nstr + "        ";
                    continue;
                }
                nstr = "        " + (String)nstr;
                continue;
            }
            if (diff >= 4) {
                startLen += 4;
                if (left) {
                    nstr = (String)nstr + "    ";
                    continue;
                }
                nstr = "    " + (String)nstr;
                continue;
            }
            if (diff >= 2) {
                startLen += 2;
                if (left) {
                    nstr = (String)nstr + "  ";
                    continue;
                }
                nstr = "  " + (String)nstr;
                continue;
            }
            ++startLen;
            if (left) {
                nstr = (String)nstr + " ";
                continue;
            }
            nstr = " " + (String)nstr;
        }
        return nstr;
    }

    public static String createParamString(String fmt) {
        return fmt;
    }

    public static String createParamString(String fmt, Object obj1) {
        return StringScanner.createParamString(fmt, 1, obj1, null, null, null, null, null, null, null, null);
    }

    public static String createParamString(String fmt, Object obj1, Object obj2) {
        return StringScanner.createParamString(fmt, 2, obj1, obj2, null, null, null, null, null, null, null);
    }

    public static String createParamString(String fmt, Object obj1, Object obj2, Object obj3) {
        return StringScanner.createParamString(fmt, 3, obj1, obj2, obj3, null, null, null, null, null, null);
    }

    public static String createParamString(String fmt, Object obj1, Object obj2, Object obj3, Object obj4) {
        return StringScanner.createParamString(fmt, 4, obj1, obj2, obj3, obj4, null, null, null, null, null);
    }

    public static String createParamString(String fmt, Object obj1, Object obj2, Object obj3, Object obj4, Object obj5) {
        return StringScanner.createParamString(fmt, 5, obj1, obj2, obj3, obj4, obj5, null, null, null, null);
    }

    public static String createParamString(String fmt, Object obj1, Object obj2, Object obj3, Object obj4, Object obj5, Object obj6) {
        return StringScanner.createParamString(fmt, 6, obj1, obj2, obj3, obj4, obj5, obj6, null, null, null);
    }

    public static String createParamString(String fmt, Object obj1, Object obj2, Object obj3, Object obj4, Object obj5, Object obj6, Object obj7) {
        return StringScanner.createParamString(fmt, 7, obj1, obj2, obj3, obj4, obj5, obj6, obj7, null, null);
    }

    public static String createParamString(String fmt, Object obj1, Object obj2, Object obj3, Object obj4, Object obj5, Object obj6, Object obj7, Object obj8) {
        return StringScanner.createParamString(fmt, 8, obj1, obj2, obj3, obj4, obj5, obj6, obj7, obj8, null);
    }

    public static String createParamString(String fmt, Object obj1, Object obj2, Object obj3, Object obj4, Object obj5, Object obj6, Object obj7, Object obj8, Object obj9) {
        return StringScanner.createParamString(fmt, 9, obj1, obj2, obj3, obj4, obj5, obj6, obj7, obj8, obj9);
    }

    public static String getIntStr(int num) {
        boolean big;
        String str;
        try {
            str = intStrTable[num];
            big = false;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            str = null;
            big = true;
        }
        if (str == null) {
            str = Integer.toString(num);
            if (!big) {
                StringScanner.intStrTable[num] = str;
            }
        }
        return str;
    }
}

