/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.security.jacc.provider.compatibility;

import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Configs;
import com.sun.enterprise.config.serverbeans.JaccProvider;
import com.sun.enterprise.config.serverbeans.SecurityService;
import fish.payara.security.jacc.provider.PolicyConfigurationFactoryImpl;
import fish.payara.security.jacc.provider.PolicyProviderImpl;
import jakarta.inject.Inject;
import java.beans.PropertyVetoException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.hk2.api.PostConstruct;
import org.glassfish.hk2.runlevel.RunLevel;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.TransactionFailure;

@Service
@RunLevel(value=10)
public class JaccProviderCompatibilityStartup
implements PostConstruct {
    public static final String OLD_POLICY_WRAPPER = "com.sun.enterprise.security.provider.PolicyWrapper";
    public static final String OLD_POLICY_CONFIGURATION_FACTORY_IMPL = "com.sun.enterprise.security.provider.PolicyConfigurationFactoryImpl";
    public static final String OLD_SIMPLE_POLICY_WRAPPER = "com.sun.enterprise.security.jacc.provider.SimplePolicyProvider";
    public static final String OLD_SIMPLE_POLICY_CONFIGURATION_FACTORY_IMPL = "com.sun.enterprise.security.jacc.provider.SimplePolicyConfigurationFactory";
    @Inject
    private Configs configs;

    public void postConstruct() {
        for (Config config : this.configs.getConfig()) {
            SecurityService securityService = config.getSecurityService();
            List jaccProviders = securityService.getJaccProvider();
            for (JaccProvider jaccProvider : jaccProviders) {
                String policyProvider = jaccProvider.getPolicyProvider();
                String policyConfigurationFactoryProvider = jaccProvider.getPolicyConfigurationFactoryProvider();
                String newPolicyProvider = policyProvider;
                String newPolicyConfigurationFactoryProvider = policyConfigurationFactoryProvider;
                if (policyProvider.equals(OLD_POLICY_WRAPPER) || policyProvider.equals(OLD_SIMPLE_POLICY_WRAPPER)) {
                    newPolicyProvider = PolicyProviderImpl.class.getCanonicalName();
                }
                if (policyConfigurationFactoryProvider.equals(OLD_POLICY_CONFIGURATION_FACTORY_IMPL) || policyConfigurationFactoryProvider.equals(OLD_SIMPLE_POLICY_CONFIGURATION_FACTORY_IMPL)) {
                    newPolicyConfigurationFactoryProvider = PolicyConfigurationFactoryImpl.class.getCanonicalName();
                }
                if (newPolicyProvider.equals(policyProvider) && newPolicyConfigurationFactoryProvider.equals(policyConfigurationFactoryProvider)) continue;
                this.renameJaccProvider(jaccProvider, newPolicyProvider, newPolicyConfigurationFactoryProvider);
            }
        }
    }

    private void renameJaccProvider(JaccProvider jaccProvider, final String policyProvider, final String policyConfigurationFactoryProvider) {
        final Logger logger = Logger.getAnonymousLogger();
        try {
            ConfigSupport.apply(new SingleConfigCode<JaccProvider>(){

                @Override
                public Object run(JaccProvider param) throws PropertyVetoException, TransactionFailure {
                    logger.log(Level.INFO, "Renaming jacc policy provider from " + param.getPolicyProvider() + " to " + policyProvider);
                    param.setPolicyProvider(policyProvider);
                    logger.log(Level.INFO, "Renaming jacc policy configuration factory provider from " + param.getPolicyConfigurationFactoryProvider() + " to " + policyConfigurationFactoryProvider);
                    param.setPolicyConfigurationFactoryProvider(policyConfigurationFactoryProvider);
                    return param;
                }
            }, jaccProvider);
        }
        catch (TransactionFailure tf) {
            logger.log(Level.SEVERE, "Failure while renaming jacc provider ", tf);
            throw new RuntimeException(tf);
        }
    }
}

