/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.spi;

import com.sun.faces.config.WebConfiguration;
import com.sun.faces.spi.AnnotationScanner;
import com.sun.faces.spi.DiscoverableInjectionProvider;
import com.sun.faces.spi.InjectionProvider;
import com.sun.faces.spi.InjectionProviderException;
import com.sun.faces.util.FacesLogger;
import com.sun.faces.util.Util;
import com.sun.faces.vendor.WebContainerInjectionProvider;
import jakarta.faces.context.ExternalContext;
import jakarta.servlet.ServletContext;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class InjectionProviderFactory {
    private static final InjectionProvider NOOP_PROVIDER = new NoopInjectionProvider();
    private static final InjectionProvider GENERIC_WEB_PROVIDER = new WebContainerInjectionProvider();
    private static final String INJECTION_SERVICE = "META-INF/services/com.sun.faces.spi.injectionprovider";
    private static final String INJECTION_PROVIDER_PROPERTY = "com.sun.faces.InjectionProvider";
    private static final Logger LOGGER = FacesLogger.APPLICATION.getLogger();
    private static final String[] EMPTY_ARRAY = new String[0];

    public static InjectionProvider createInstance(ExternalContext extContext) {
        String providerClass = InjectionProviderFactory.findProviderClass(extContext);
        InjectionProvider provider = InjectionProviderFactory.getProviderInstance(providerClass, extContext);
        if (!NoopInjectionProvider.class.equals(provider.getClass()) && !WebContainerInjectionProvider.class.equals(provider.getClass())) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "faces.spi.injection.provider_configured", new Object[]{provider.getClass().getName()});
            }
            return provider;
        }
        if (WebContainerInjectionProvider.class.equals(provider.getClass())) {
            LOGGER.info("faces.core.injection.provider_generic_web_configured");
            return provider;
        }
        LOGGER.log(Level.WARNING, "faces.spi.injection.no_injection");
        return provider;
    }

    private static InjectionProvider getProviderInstance(String className, ExternalContext extContext) {
        InjectionProvider provider;
        block16: {
            provider = NOOP_PROVIDER;
            if (className != null) {
                try {
                    Class clazz = Util.loadClass(className, InjectionProviderFactory.class);
                    if (InjectionProviderFactory.implementsInjectionProvider(clazz)) {
                        try {
                            Constructor ctor = clazz.getConstructor(ServletContext.class);
                            return (InjectionProvider)ctor.newInstance((ServletContext)extContext.getContext());
                        }
                        catch (NoSuchMethodException nsme) {
                            return (InjectionProvider)clazz.newInstance();
                        }
                        catch (InvocationTargetException ite) {
                            if (LOGGER.isLoggable(Level.SEVERE)) {
                                LOGGER.log(Level.SEVERE, "faces.spi.injection.provider_cannot_instantiate", new Object[]{className});
                                LOGGER.log(Level.SEVERE, "", ite);
                            }
                        }
                    } else if (LOGGER.isLoggable(Level.SEVERE)) {
                        LOGGER.log(Level.SEVERE, "faces.spi.injection.provider_not_implemented", new Object[]{className});
                    }
                }
                catch (ClassNotFoundException cnfe) {
                    if (LOGGER.isLoggable(Level.SEVERE)) {
                        LOGGER.log(Level.SEVERE, "faces.spi.injection.provider_not_found", new Object[]{className});
                    }
                }
                catch (IllegalAccessException | InstantiationException ie) {
                    if (!LOGGER.isLoggable(Level.SEVERE)) break block16;
                    LOGGER.log(Level.SEVERE, "faces.spi.injection.provider_cannot_instantiate", new Object[]{className});
                    LOGGER.log(Level.SEVERE, "", ie);
                }
            }
        }
        if (NOOP_PROVIDER.equals(provider)) {
            try {
                if (Util.loadClass("jakarta.annotation.PostConstruct", null) != null && Util.loadClass("jakarta.annotation.PreDestroy", null) != null) {
                    provider = GENERIC_WEB_PROVIDER;
                }
            }
            catch (Exception e) {
                provider = NOOP_PROVIDER;
            }
        }
        return provider;
    }

    private static boolean implementsInjectionProvider(Class<?> clazz) {
        return InjectionProvider.class.isAssignableFrom(clazz);
    }

    private static boolean extendsDiscoverableInjectionProvider(Class<?> clazz) {
        return DiscoverableInjectionProvider.class.isAssignableFrom(clazz);
    }

    private static String findProviderClass(ExternalContext extContext) {
        WebConfiguration webConfig = WebConfiguration.getInstance(extContext);
        String provider = webConfig.getOptionValue(WebConfiguration.WebContextInitParameter.InjectionProviderClass);
        if (provider != null) {
            return provider;
        }
        provider = System.getProperty(INJECTION_PROVIDER_PROPERTY);
        if (provider != null) {
            return provider;
        }
        String[] serviceEntries = InjectionProviderFactory.getServiceEntries();
        if (serviceEntries.length > 0) {
            for (int i = 0; i < serviceEntries.length && (provider = InjectionProviderFactory.getProviderFromEntry(extContext.getApplicationMap(), serviceEntries[i])) == null; ++i) {
            }
        } else {
            return provider;
        }
        return provider;
    }

    private static String getProviderFromEntry(Map<String, Object> appMap, String entry) {
        block9: {
            if (entry == null) {
                return null;
            }
            String[] parts = Util.split(appMap, entry, ":");
            if (parts.length != 2) {
                if (LOGGER.isLoggable(Level.SEVERE)) {
                    LOGGER.log(Level.SEVERE, "faces.spi.injection.invalid_service_entry", new Object[]{entry});
                }
                return null;
            }
            try {
                Class clazz = Util.loadClass(parts[0], null);
                if (InjectionProviderFactory.extendsDiscoverableInjectionProvider(clazz)) {
                    if (DiscoverableInjectionProvider.isInjectionFeatureAvailable(parts[1])) {
                        return parts[0];
                    }
                    break block9;
                }
                if (LOGGER.isLoggable(Level.SEVERE)) {
                    LOGGER.log(Level.SEVERE, "faces.spi.injection.provider.entry_not_discoverable", new Object[]{parts[0]});
                }
                return null;
            }
            catch (ClassNotFoundException cnfe) {
                if (LOGGER.isLoggable(Level.SEVERE)) {
                    LOGGER.log(Level.SEVERE, "faces.spi.injection.provider_not_found", new Object[]{parts[0]});
                }
                return null;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String[] getServiceEntries() {
        Enumeration<URL> urls;
        ArrayList<String> results;
        block27: {
            results = null;
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            if (loader == null) {
                return EMPTY_ARRAY;
            }
            urls = null;
            try {
                urls = loader.getResources(INJECTION_SERVICE);
            }
            catch (IOException ioe) {
                if (!LOGGER.isLoggable(Level.SEVERE)) break block27;
                LOGGER.log(Level.SEVERE, ioe.toString(), ioe);
            }
        }
        if (urls != null) {
            InputStream input = null;
            BufferedReader reader = null;
            while (urls.hasMoreElements()) {
                try {
                    if (results == null) {
                        results = new ArrayList<String>();
                    }
                    URL url = urls.nextElement();
                    URLConnection conn = url.openConnection();
                    conn.setUseCaches(false);
                    input = conn.getInputStream();
                    if (input == null) continue;
                    try {
                        reader = new BufferedReader(new InputStreamReader(input, "UTF-8"));
                    }
                    catch (Exception e) {
                        reader = new BufferedReader(new InputStreamReader(input));
                    }
                    String line = reader.readLine();
                    while (line != null) {
                        results.add(line.trim());
                        line = reader.readLine();
                    }
                }
                catch (Exception e) {
                    if (!LOGGER.isLoggable(Level.SEVERE)) continue;
                    LOGGER.log(Level.SEVERE, "faces.spi.provider.cannot_read_service", new Object[]{INJECTION_SERVICE});
                    LOGGER.log(Level.SEVERE, e.toString(), e);
                }
                finally {
                    block28: {
                        if (input != null) {
                            try {
                                input.close();
                            }
                            catch (Exception e) {
                                if (!LOGGER.isLoggable(Level.FINEST)) break block28;
                                LOGGER.log(Level.FINEST, "Closing stream", e);
                            }
                        }
                    }
                    if (reader == null) continue;
                    try {
                        reader.close();
                    }
                    catch (Exception e) {
                        if (!LOGGER.isLoggable(Level.FINEST)) continue;
                        LOGGER.log(Level.FINEST, "Closing stream", e);
                    }
                }
            }
        }
        return results != null && !results.isEmpty() ? results.toArray(new String[results.size()]) : EMPTY_ARRAY;
    }

    private static final class NoopInjectionProvider
    implements InjectionProvider,
    AnnotationScanner {
        private NoopInjectionProvider() {
        }

        @Override
        public void inject(Object managedBean) {
        }

        @Override
        public Map<String, List<AnnotationScanner.ScannedAnnotation>> getAnnotatedClassesInCurrentModule(ServletContext extContext) throws InjectionProviderException {
            return Collections.emptyMap();
        }

        @Override
        public void invokePreDestroy(Object managedBean) {
        }

        @Override
        public void invokePostConstruct(Object managedBean) throws InjectionProviderException {
        }
    }
}

