/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.admin;

import com.sun.enterprise.config.serverbeans.AdminService;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.module.ModulesRegistry;
import com.sun.enterprise.module.common_impl.LogHelper;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.util.uuid.UuidGeneratorImpl;
import com.sun.enterprise.v3.admin.CommandRunnerImpl;
import com.sun.enterprise.v3.admin.ProcessHttpCommandRequestException;
import com.sun.enterprise.v3.admin.adapter.AdminEndpointDecider;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.annotation.Annotation;
import java.net.InetAddress;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginException;
import org.glassfish.admin.payload.PayloadFilesManager;
import org.glassfish.admin.payload.PayloadImpl;
import org.glassfish.api.ActionReport;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.CommandModel;
import org.glassfish.api.admin.CommandRunner;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.ParameterMap;
import org.glassfish.api.admin.Payload;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.api.container.Adapter;
import org.glassfish.api.event.EventListener;
import org.glassfish.api.event.EventTypes;
import org.glassfish.api.event.Events;
import org.glassfish.api.event.RestrictTo;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.http.Cookie;
import org.glassfish.grizzly.http.server.HttpHandler;
import org.glassfish.grizzly.http.server.Request;
import org.glassfish.grizzly.http.server.Response;
import org.glassfish.grizzly.http.server.StaticHttpHandler;
import org.glassfish.grizzly.http.util.CookieSerializerUtils;
import org.glassfish.grizzly.http.util.HttpStatus;
import org.glassfish.hk2.api.PostConstruct;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.internal.api.AdminAccessController;
import org.glassfish.internal.api.Privacy;
import org.glassfish.internal.api.RemoteAdminAccessException;
import org.glassfish.internal.api.ServerContext;
import org.glassfish.kernel.KernelLoggerInfo;
import org.glassfish.server.ServerEnvironmentImpl;

public abstract class AdminAdapter
extends StaticHttpHandler
implements Adapter,
PostConstruct,
EventListener {
    public static final String VS_NAME = "__asadmin";
    public static final String PREFIX_URI = "/__asadmin";
    private static final LocalStringManagerImpl adminStrings = new LocalStringManagerImpl(AdminAdapter.class);
    private static final Logger aalogger = KernelLoggerInfo.getLogger();
    private static final Base64.Decoder decoder = Base64.getMimeDecoder();
    private static final String BASIC = "Basic ";
    private static final String SET_COOKIE_HEADER = "Set-Cookie";
    public static final String SESSION_COOKIE_NAME = "JSESSIONID";
    public static final int MAX_AGE = 86400;
    public static final String ASADMIN_PATH = "/__asadmin";
    private static final String QUERY_STRING_SEPARATOR = "&";
    @Inject
    ModulesRegistry modulesRegistry;
    @Inject
    CommandRunnerImpl commandRunner;
    @Inject
    ServerEnvironmentImpl env;
    @Inject
    Events events;
    @Inject
    @Named(value="default-instance-name")
    Config config;
    private AdminEndpointDecider epd = null;
    @Inject
    ServerContext sc;
    @Inject
    ServiceLocator habitat;
    @Inject
    @Named(value="default-instance-name")
    volatile AdminService as;
    @Inject
    volatile Domain domain;
    @Inject
    @Named(value="default-instance-name")
    private volatile Server server;
    @Inject
    AdminAccessController authenticator;
    final Class<? extends Privacy> privacyClass;
    private boolean isRegistered = false;
    CountDownLatch latch = new CountDownLatch(1);

    protected AdminAdapter(Class<? extends Privacy> privacyClass) {
        super((Set)null);
        this.privacyClass = privacyClass;
    }

    @Override
    public final HttpHandler getHttpService() {
        return this;
    }

    public void postConstruct() {
        this.events.register(this);
        this.epd = new AdminEndpointDecider(this.config);
        this.addDocRoot((String)this.env.getProps().get("com.sun.aas.instanceRoot") + "/asadmindocroot/");
    }

    public void onMissingResource(Request req, Response res) {
        LogHelper.getDefaultLogger().log(Level.FINER, "Received something on {0}", req.getRequestURI());
        LogHelper.getDefaultLogger().log(Level.FINER, "QueryString = {0}", req.getQueryString());
        HttpStatus statusCode = HttpStatus.OK_200;
        String requestURI = req.getRequestURI();
        ActionReport report = this.getClientActionReport(requestURI, req);
        if (requestURI.indexOf(46) != -1) {
            requestURI = requestURI.substring(0, requestURI.indexOf(46));
        }
        PayloadImpl.Outbound outboundPayload = PayloadImpl.Outbound.newInstance();
        try {
            if (!this.latch.await(20L, TimeUnit.SECONDS)) {
                report = this.getClientActionReport(req.getRequestURI(), req);
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                report.setMessage("V3 cannot process this command at this time, please wait");
            } else {
                Subject s;
                Subject subject = s = this.authenticator == null ? null : this.authenticator.loginAsAdmin(req);
                if (s == null) {
                    this.reportAuthFailure(res, report, "adapter.auth.userpassword", "Invalid user name or password", 401, "WWW-Authenticate", "BASIC");
                    return;
                }
                report = this.doCommand(requestURI, req, report, (Payload.Outbound)outboundPayload, s);
            }
        }
        catch (ProcessHttpCommandRequestException reqEx) {
            report = reqEx.getReport();
            statusCode = reqEx.getResponseStatus();
        }
        catch (InterruptedException e) {
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setMessage("V3 cannot process this command at this time, please wait");
        }
        catch (Exception e) {
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setMessage("Exception while processing command: " + e);
        }
        try {
            res.setStatus(statusCode);
            ByteArrayOutputStream baos = new ByteArrayOutputStream(1024);
            report.writeReport(baos);
            ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
            Properties reportProps = new Properties();
            reportProps.setProperty("data-request-type", "report");
            outboundPayload.addPart(0, report.getContentType(), "report", reportProps, bais);
            res.setContentType(outboundPayload.getContentType());
            String commandName = req.getRequestURI().substring(this.getContextRoot().length() + 1);
            if (this.isSingleInstanceCommand(commandName)) {
                res.addHeader(SET_COOKIE_HEADER, this.getCookieHeader(req));
            }
            outboundPayload.writeTo(res.getOutputStream());
            res.getOutputStream().flush();
            res.finish();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public boolean hasCookieHeader(Request req) {
        String[] nameValuePair = this.getJSESSIONIDHeaders(req);
        if (nameValuePair != null) {
            String headerValue = nameValuePair[1];
            int index = headerValue.lastIndexOf(46);
            return headerValue.substring(index + 1).equals(this.server.getName());
        }
        return false;
    }

    public String[] getJSESSIONIDHeaders(Request req) {
        for (String header : req.getHeaders("Cookie")) {
            String[] cookieHeaders;
            for (String cookieHeader : cookieHeaders = header.trim().split(";")) {
                String[] nameValuePair = cookieHeader.trim().split("=");
                if (!nameValuePair[0].equals(SESSION_COOKIE_NAME)) continue;
                return nameValuePair;
            }
        }
        return null;
    }

    public boolean isSingleInstanceCommand(String commandName) {
        ExecuteOn executeOn;
        CommandModel model = this.commandRunner.getModel(this.getScope(commandName), this.getCommandAfterScope(commandName), aalogger);
        return model != null && (executeOn = model.getClusteringAttributes()) != null && executeOn.value().length == 1 && executeOn.value()[0].equals((Object)RuntimeType.SINGLE_INSTANCE);
    }

    public String getCookieHeader(Request req) {
        String sessionId = null;
        sessionId = this.hasCookieHeader(req) ? this.getJSESSIONIDHeaders(req)[1] : this.createSessionId();
        StringBuilder sb = new StringBuilder();
        Cookie cookie = new Cookie(SESSION_COOKIE_NAME, sessionId);
        cookie.setMaxAge(86400);
        cookie.setPath("/__asadmin");
        cookie.setVersion(1);
        CookieSerializerUtils.serializeServerCookie((StringBuilder)sb, (boolean)true, (boolean)false, (boolean)false, (Cookie)cookie);
        return sb.toString();
    }

    public String createSessionId() {
        UuidGeneratorImpl uuidGenerator = new UuidGeneratorImpl();
        StringBuilder sessionBuf = new StringBuilder();
        String sessionId = uuidGenerator.generateUuid();
        sessionBuf.append(sessionId).append('.').append(this.server.getName());
        return sessionBuf.toString();
    }

    public AdminAccessController.Access authenticate(Request req) throws Exception {
        try {
            this.authenticator.loginAsAdmin(req);
            return this.env.isDas() ? AdminAccessController.Access.FULL : AdminAccessController.Access.READONLY;
        }
        catch (RemoteAdminAccessException ex) {
            return AdminAccessController.Access.FORBIDDEN;
        }
        catch (LoginException ex) {
            return AdminAccessController.Access.NONE;
        }
    }

    public static String[] getUserPassword(Request req) throws IOException {
        String authHeader = req.getHeader("Authorization");
        if (authHeader == null) {
            return new String[]{"", ""};
        }
        String dec = new String(decoder.decode(authHeader.substring(BASIC.length())), StandardCharsets.UTF_8);
        int i = dec.indexOf(58);
        if (i < 0) {
            return new String[]{"", ""};
        }
        return new String[]{dec.substring(0, i), dec.substring(i + 1)};
    }

    private void reportAuthFailure(Response res, ActionReport report, String msgKey, String msg, int httpStatus, String headerName, String headerValue) throws IOException {
        report.setActionExitCode(ActionReport.ExitCode.FAILURE);
        String messageForResponse = adminStrings.getLocalString(msgKey, msg);
        report.setMessage(messageForResponse);
        report.setActionDescription("Authentication error");
        res.setStatus(httpStatus, messageForResponse);
        if (headerName != null) {
            res.setHeader(headerName, headerValue);
        }
        res.setContentType(report.getContentType());
        report.writeReport(res.getOutputStream());
        res.getOutputStream().flush();
        res.finish();
    }

    private ActionReport getClientActionReport(String requestURI, Request req) {
        ActionReport report = null;
        if (requestURI.indexOf(46) != -1) {
            String qualifier = requestURI.substring(requestURI.indexOf(46) + 1);
            report = (ActionReport)this.habitat.getService(ActionReport.class, qualifier, new Annotation[0]);
        } else {
            String accept;
            String userAgent = req.getHeader("User-Agent");
            if (userAgent != null) {
                report = (ActionReport)this.habitat.getService(ActionReport.class, userAgent.substring(userAgent.indexOf(47) + 1), new Annotation[0]);
            }
            if (report == null && (accept = req.getHeader("Accept")) != null) {
                StringTokenizer st = new StringTokenizer(accept, ",");
                while (report == null && st.hasMoreElements()) {
                    String scheme = st.nextToken();
                    report = (ActionReport)this.habitat.getService(ActionReport.class, scheme.substring(scheme.indexOf(47) + 1), new Annotation[0]);
                }
            }
        }
        if (report == null) {
            report = (ActionReport)this.habitat.getService(ActionReport.class, "html", new Annotation[0]);
        }
        return report;
    }

    protected abstract boolean validatePrivacy(AdminCommand var1);

    private ActionReport doCommand(String requestURI, Request req, ActionReport report, Payload.Outbound outboundPayload, Subject subject) throws ProcessHttpCommandRequestException {
        block17: {
            if (!requestURI.startsWith(this.getContextRoot())) {
                String msg = adminStrings.getLocalString("adapter.panic", "Wrong request landed in AdminAdapter {0}", new Object[]{requestURI});
                report.setMessage(msg);
                LogHelper.getDefaultLogger().info(msg);
                return report;
            }
            String command = "";
            if (requestURI.length() > this.getContextRoot().length() + 1) {
                command = requestURI.substring(this.getContextRoot().length() + 1);
            }
            String scope = this.getScope(command);
            command = this.getCommandAfterScope(command);
            String qs = req.getQueryString();
            ParameterMap parameters = this.extractParameters(qs);
            String passwordOptions = req.getHeader("X-passwords");
            if (passwordOptions != null) {
                this.decodePasswords(parameters, passwordOptions);
            }
            try {
                AdminCommand adminCommand;
                String uploadValue = (String)parameters.getOne("upload");
                if ("false".equalsIgnoreCase(uploadValue)) {
                    Buffer contentBuffer = req.getInputBuffer().getBuffer();
                    int capacity = contentBuffer.capacity();
                    byte[] path = new byte[capacity];
                    for (int i = 0; i < capacity; ++i) {
                        path[i] = contentBuffer.get(i);
                    }
                    parameters.add("path", new String(path));
                    parameters.remove("upload");
                }
                PayloadImpl.Inbound inboundPayload = PayloadImpl.Inbound.newInstance((String)req.getContentType(), (InputStream)req.getInputStream());
                if (aalogger.isLoggable(Level.FINE)) {
                    aalogger.log(Level.FINE, "***** AdminAdapter {0}  *****", req.getMethod());
                }
                if ("true".equalsIgnoreCase(uploadValue)) {
                    File extractLocation = new File(this.domain.getApplicationRoot() + File.separator + "upload-" + inboundPayload.hashCode() + File.separator);
                    if (!extractLocation.mkdirs()) {
                        aalogger.log(Level.WARNING, PayloadFilesManager.strings.getLocalString("payload.mkdirsFailed", "Attempt to create directories for {0} failed; no further information is available. Continuing.", new Object[]{extractLocation.getAbsolutePath()}));
                    }
                    PayloadFilesManager.Perm permFileManager = new PayloadFilesManager.Perm(extractLocation, null, aalogger);
                    permFileManager.processParts((Payload.Inbound)inboundPayload);
                    parameters.add("path", extractLocation.toString());
                    parameters.remove("upload");
                }
                if ((adminCommand = this.commandRunner.getCommand(scope, command, report, aalogger)) == null) {
                    if (report.getActionExitCode() == ActionReport.ExitCode.FAILURE) {
                        return report;
                    }
                    String message = adminStrings.getLocalString("adapter.command.notfound", "Command {0} not found", new Object[]{command});
                    aalogger.log(Level.FINE, message);
                    report.setMessage(message);
                    report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                    return report;
                }
                String modelETag = req.getHeader("X-If-Command-Model-Match");
                if (modelETag != null && !this.commandRunner.validateCommandModelETag(adminCommand, modelETag)) {
                    String message = adminStrings.getLocalString("commandmodel.etag.invalid", "Cached command model for command {0} is invalid.", new Object[]{command});
                    aalogger.log(Level.FINE, message);
                    report.setMessage(message);
                    report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                    throw new ProcessHttpCommandRequestException(report, HttpStatus.PRECONDITION_FAILED_412);
                }
                if (this.validatePrivacy(adminCommand)) {
                    CommandRunner.CommandInvocation inv = this.commandRunner.getCommandInvocation(scope, command, report, subject, parameters.containsKey("notify"));
                    inv.parameters(parameters).inbound((Payload.Inbound)inboundPayload).outbound(outboundPayload).execute();
                    try {
                        CommandRunnerImpl.ExecutionContext inv2 = (CommandRunnerImpl.ExecutionContext)inv;
                        report = inv2.report();
                    }
                    catch (Exception exception) {}
                    break block17;
                }
                report.failure(aalogger, adminStrings.getLocalString("adapter.wrongprivacy", "Command {0} does not have {1} visibility", new Object[]{command, this.privacyClass.getSimpleName().toLowerCase(Locale.ENGLISH)}), null);
                return report;
            }
            catch (ProcessHttpCommandRequestException reqEx) {
                throw reqEx;
            }
            catch (Throwable t) {
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                report.setFailureCause(t);
                report.setMessage(t.getLocalizedMessage());
                report.setActionDescription("Last-chance AdminAdapter exception handler");
            }
        }
        return report;
    }

    public void afterService(Request req, Response res) throws Exception {
    }

    public void fireAdapterEvent(String type, Object data) {
    }

    void decodePasswords(ParameterMap pmap, String requestString) {
        StringTokenizer stoken = new StringTokenizer(requestString == null ? "" : requestString, QUERY_STRING_SEPARATOR);
        while (stoken.hasMoreTokens()) {
            String token = stoken.nextToken();
            if (token.indexOf(61) == -1) continue;
            String paramName = token.substring(0, token.indexOf(61));
            String value = token.substring(token.indexOf(61) + 1);
            try {
                value = URLDecoder.decode(value, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                aalogger.log(Level.WARNING, "NCLS-CORE-00001", new Object[]{paramName, value});
                continue;
            }
            try {
                value = new String(decoder.decode(value), StandardCharsets.UTF_8);
            }
            catch (IllegalArgumentException e) {
                aalogger.log(Level.WARNING, "NCLS-CORE-00001", new Object[]{paramName, value});
                continue;
            }
            pmap.add(paramName, value);
        }
    }

    ParameterMap extractParameters(String requestString) {
        ParameterMap parameters = new ParameterMap();
        StringTokenizer stoken = new StringTokenizer(requestString == null ? "" : requestString, QUERY_STRING_SEPARATOR);
        while (stoken.hasMoreTokens()) {
            String token = stoken.nextToken();
            if (token.indexOf(61) == -1) continue;
            String paramName = token.substring(0, token.indexOf(61));
            String value = token.substring(token.indexOf(61) + 1);
            try {
                value = URLDecoder.decode(value, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                aalogger.log(Level.WARNING, "NCLS-CORE-00001", new Object[]{paramName, value});
            }
            parameters.add(paramName, value);
        }
        if (aalogger.isLoggable(Level.FINER)) {
            for (Map.Entry entry : parameters.entrySet()) {
                for (String v : (List)entry.getValue()) {
                    aalogger.log(Level.FINER, "Key {0} = {1}", new Object[]{entry.getKey(), v});
                }
            }
        }
        return parameters;
    }

    public void event(@RestrictTo(value="server_ready") EventListener.Event event) {
        if (event.is(EventTypes.SERVER_READY)) {
            this.latch.countDown();
            aalogger.fine("Ready to receive administrative commands");
        }
    }

    @Override
    public int getListenPort() {
        return this.epd.getListenPort();
    }

    @Override
    public InetAddress getListenAddress() {
        return this.epd.getListenAddress();
    }

    @Override
    public List<String> getVirtualServers() {
        return this.epd.getAsadminHosts();
    }

    @Override
    public boolean isRegistered() {
        return this.isRegistered;
    }

    @Override
    public void setRegistered(boolean isRegistered) {
        this.isRegistered = isRegistered;
    }

    private String getScope(String command) {
        int ci = command.indexOf(47);
        return ci != -1 ? command.substring(0, ci + 1) : null;
    }

    private String getCommandAfterScope(String command) {
        int ci = command.indexOf(47);
        return ci != -1 ? (command = command.substring(ci + 1)) : command;
    }
}

