/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.admin;

import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.JavaConfig;
import com.sun.enterprise.module.bootstrap.StartupContext;
import com.sun.enterprise.util.OS;
import com.sun.enterprise.v3.admin.Strings;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.lang.management.RuntimeMXBean;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.ActionReport;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AccessRequired;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.CommandLock;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RestEndpoint;
import org.glassfish.api.admin.RestEndpoints;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.hk2.api.PerLookup;
import org.jvnet.hk2.annotations.Service;

@Service(name="_get-runtime-info")
@PerLookup
@CommandLock(value=CommandLock.LockType.NONE)
@ExecuteOn(value={RuntimeType.INSTANCE})
@TargetType(value={CommandTarget.DAS, CommandTarget.STANDALONE_INSTANCE, CommandTarget.CLUSTERED_INSTANCE})
@RestEndpoints(value={@RestEndpoint(configBean=Domain.class, opType=RestEndpoint.OpType.GET, path="get-runtime-info", description="Get Runtime Info")})
@AccessRequired(resource={"domain"}, action={"read"})
public class RuntimeInfo
implements AdminCommand {
    @Inject
    ServerEnvironment env;
    @Inject
    private StartupContext ctx;
    @Inject
    @Named(value="default-instance-name")
    private Config config;
    @Param(name="target", optional=true, defaultValue="com.sun.aas.instanceName")
    String target;
    private boolean jpdaEnabled;
    private JavaConfig javaConfig;
    private ActionReport report;
    private ActionReport.MessagePart top;
    private Logger logger;
    private StringBuilder reportMessage = new StringBuilder();
    private boolean restartable;

    @Override
    public void execute(AdminCommandContext context) {
        this.report = context.getActionReport();
        this.report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
        this.top = this.report.getTopMessagePart();
        this.logger = context.getLogger();
        boolean javaEnabledOnCmd = Boolean.parseBoolean(this.ctx.getArguments().getProperty("-debug"));
        this.javaConfig = this.config.getJavaConfig();
        this.jpdaEnabled = javaEnabledOnCmd || Boolean.parseBoolean(this.javaConfig.getDebugEnabled());
        int debugPort = this.parsePort(this.javaConfig.getDebugOptions());
        this.top.addProperty("debug", Boolean.toString(this.jpdaEnabled));
        this.top.addProperty("debugPort", Integer.toString(debugPort));
        OperatingSystemMXBean osBean = ManagementFactory.getOperatingSystemMXBean();
        this.top.addProperty("os.arch", osBean.getArch());
        this.top.addProperty("os.name", osBean.getName());
        this.top.addProperty("os.version", osBean.getVersion());
        this.top.addProperty("availableProcessorsCount", "" + osBean.getAvailableProcessors());
        if (!OS.isAix()) {
            try {
                final Method jm = osBean.getClass().getMethod("getTotalPhysicalMemorySize", new Class[0]);
                AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws Exception {
                        if (!jm.isAccessible()) {
                            jm.setAccessible(true);
                        }
                        return null;
                    }
                });
                this.top.addProperty("totalPhysicalMemorySize", "" + jm.invoke((Object)osBean, new Object[0]));
            }
            catch (Exception ex) {
                this.logger.log(Level.SEVERE, null, ex);
            }
        }
        RuntimeMXBean rmxb = ManagementFactory.getRuntimeMXBean();
        this.top.addProperty("startTimeMillis", "" + rmxb.getStartTime());
        this.top.addProperty("pid", rmxb.getName());
        this.checkDtrace();
        this.setDasName();
        this.top.addProperty("java.vm.name", System.getProperty("java.vm.name"));
        this.reportMessage.append(Strings.get("runtime.info.debug", this.jpdaEnabled ? "enabled" : "not enabled"));
        this.report.setMessage(this.reportMessage.toString());
    }

    private void checkDtrace() {
        try {
            Class.forName("com.sun.tracing.ProviderFactory");
            this.top.addProperty("dtrace", "true");
        }
        catch (Exception ex) {
            this.top.addProperty("dtrace", "false");
        }
    }

    private void setDasName() {
        try {
            String name = this.env.getInstanceRoot().getName();
            this.top.addProperty("domain_name", name);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private int parsePort(String s) {
        String[] ss;
        int port = -1;
        for (String sub : ss = s.split(",")) {
            if (!sub.startsWith("address=")) continue;
            try {
                port = Integer.parseInt(sub.substring(8));
            }
            catch (Exception e) {
                port = -1;
            }
            break;
        }
        return port;
    }
}

