/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.server;

import com.sun.enterprise.admin.report.HTMLActionReporter;
import com.sun.enterprise.config.serverbeans.AppTenant;
import com.sun.enterprise.config.serverbeans.Application;
import com.sun.enterprise.config.serverbeans.ApplicationRef;
import com.sun.enterprise.config.serverbeans.Applications;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.config.serverbeans.SystemApplications;
import com.sun.enterprise.deploy.shared.ArchiveFactory;
import com.sun.enterprise.util.io.FileUtils;
import com.sun.enterprise.v3.bootstrap.BootCommandService;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.inject.Provider;
import java.io.File;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.ActionReport;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.api.deployment.DeployCommandParameters;
import org.glassfish.api.deployment.DeploymentContext;
import org.glassfish.api.deployment.OpsParams;
import org.glassfish.api.deployment.UndeployCommandParameters;
import org.glassfish.api.deployment.archive.Archive;
import org.glassfish.api.deployment.archive.ArchiveHandler;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.glassfish.api.event.EventListener;
import org.glassfish.api.event.EventTypes;
import org.glassfish.api.event.Events;
import org.glassfish.deployment.common.ApplicationConfigInfo;
import org.glassfish.deployment.common.DeploymentContextImpl;
import org.glassfish.deployment.common.DeploymentUtils;
import org.glassfish.deployment.common.InstalledLibrariesResolver;
import org.glassfish.deployment.monitor.DeploymentLifecycleStatsProvider;
import org.glassfish.external.probe.provider.PluginPoint;
import org.glassfish.external.probe.provider.StatsProviderManager;
import org.glassfish.hk2.api.Filter;
import org.glassfish.hk2.api.PostConstruct;
import org.glassfish.hk2.api.PreDestroy;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.runlevel.RunLevel;
import org.glassfish.hk2.utilities.BuilderHelper;
import org.glassfish.internal.data.ApplicationInfo;
import org.glassfish.internal.data.ApplicationRegistry;
import org.glassfish.internal.data.ContainerRegistry;
import org.glassfish.internal.data.EngineInfo;
import org.glassfish.internal.deployment.ApplicationOrderInfo;
import org.glassfish.internal.deployment.Deployment;
import org.glassfish.internal.deployment.DeploymentOrder;
import org.glassfish.internal.deployment.DeploymentTracing;
import org.glassfish.internal.deployment.ExtendedDeploymentContext;
import org.glassfish.internal.deployment.SnifferManager;
import org.glassfish.internal.deployment.analysis.StructuredDeploymentTracing;
import org.glassfish.kernel.KernelLoggerInfo;
import org.glassfish.security.services.impl.AuthenticationServiceImpl;
import org.jvnet.hk2.annotations.Optional;
import org.jvnet.hk2.annotations.Service;

@Service(name="ApplicationLoaderService")
@RunLevel(value=15, mode=0)
public class ApplicationLoaderService
implements PreDestroy,
PostConstruct {
    final Logger logger = KernelLoggerInfo.getLogger();
    @Inject
    @Optional
    private AuthenticationServiceImpl authenticationService;
    @Inject
    Deployment deployment;
    @Inject
    Provider<ArchiveFactory> archiveFactoryProvider;
    @Inject
    SnifferManager snifferManager;
    @Inject
    ContainerRegistry containerRegistry;
    @Inject
    ApplicationRegistry appRegistry;
    @Inject
    private BootCommandService bootCommandService;
    @Inject
    Events events;
    @Inject
    protected Applications applications;
    protected SystemApplications systemApplications;
    protected Domain domain;
    @Inject
    @Named(value="default-instance-name")
    Server server;
    @Inject
    ServerEnvironment env;
    @Inject
    ServiceLocator habitat;
    private String deploymentTracingEnabled = null;
    private Map<String, Integer> appOrderInfoMap = new HashMap<String, Integer>();
    private int appOrder = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postConstruct() {
        assert (this.env != null);
        try {
            this.logger.fine("Satisfying Optional Packages dependencies...");
            InstalledLibrariesResolver.initializeInstalledLibRegistry((String)this.env.getLibPath().getAbsolutePath());
        }
        catch (Exception e) {
            this.logger.log(Level.WARNING, "NCLS-CORE-00035", e);
        }
        DeploymentLifecycleStatsProvider dlsp = new DeploymentLifecycleStatsProvider();
        StatsProviderManager.register((String)"deployment", (PluginPoint)PluginPoint.SERVER, (String)"deployment/lifecycle", (Object)dlsp);
        this.deploymentTracingEnabled = System.getProperty("org.glassfish.deployment.trace");
        this.domain = (Domain)this.habitat.getService(Domain.class, new Annotation[0]);
        this.systemApplications = this.domain.getSystemApplications();
        for (Object systemApp : this.systemApplications.getApplications()) {
            this.appOrderInfoMap.put(systemApp.getName(), this.appOrder++);
        }
        List standaloneAdapters = this.applications.getApplicationsWithSnifferType("connector", true);
        for (Object standaloneAdapter : standaloneAdapters) {
            this.appOrderInfoMap.put(standaloneAdapter.getName(), this.appOrder++);
        }
        List allApplications = this.applications.getApplications();
        for (Application app : allApplications) {
            this.appOrderInfoMap.put(app.getName(), this.appOrder++);
        }
        for (Application systemApp : this.systemApplications.getApplications()) {
            if (!Boolean.valueOf(systemApp.getDeployProperties().getProperty("load-system-app-on-startup")).booleanValue() || !this.deployment.isAppEnabled(systemApp) && !this.loadAppOnDAS(systemApp.getName())) continue;
            Integer order = this.appOrderInfoMap.get(systemApp.getName());
            ApplicationOrderInfo info = new ApplicationOrderInfo(systemApp, order.intValue());
            DeploymentOrder.addApplicationDeployment((ApplicationOrderInfo)info);
        }
        for (Application standaloneAdapter : standaloneAdapters) {
            if (!this.deployment.isAppEnabled(standaloneAdapter) && !this.loadAppOnDAS(standaloneAdapter.getName())) continue;
            DeploymentOrder.addApplicationDeployment((ApplicationOrderInfo)new ApplicationOrderInfo(standaloneAdapter, this.appOrderInfoMap.get(standaloneAdapter.getName()).intValue()));
        }
        for (Application app : allApplications) {
            ApplicationInfo appDeployment;
            if (app.isStandaloneModule() && app.containsSnifferType("connector") || (appDeployment = this.deployment.get(app.getName())) != null && appDeployment.isRunning() || !Boolean.valueOf(app.getEnabled()).booleanValue() && !this.loadAppOnDAS(app.getName())) continue;
            DeploymentOrder.addApplicationDeployment((ApplicationOrderInfo)new ApplicationOrderInfo(app, this.appOrderInfoMap.get(app.getName()).intValue()));
        }
        ArrayList<Deployment.ApplicationDeployment> appDeployments = new ArrayList<Deployment.ApplicationDeployment>();
        Iterator iter = DeploymentOrder.getApplicationDeployments();
        while (iter.hasNext()) {
            Application app = (Application)iter.next();
            ApplicationRef appRef = this.server.getApplicationRef(app.getName());
            if (appRef == null) continue;
            appDeployments.addAll(this.processApplication(app, appRef));
        }
        String defaultParam = this.env.getStartupContext().getArguments().getProperty("default");
        if (defaultParam != null) {
            this.initializeRuntimeDependencies();
            File sourceFile = defaultParam.equals(".") ? new File(System.getProperty("user.dir")) : new File(defaultParam);
            if (sourceFile.exists()) {
                sourceFile = sourceFile.getAbsoluteFile();
                ReadableArchive sourceArchive = null;
                try {
                    ExtendedDeploymentContext depContext;
                    Deployment.ApplicationDeployment appDeployment;
                    sourceArchive = ((ArchiveFactory)this.archiveFactoryProvider.get()).openArchive(sourceFile);
                    DeployCommandParameters parameters = new DeployCommandParameters(sourceFile);
                    parameters.name = sourceFile.getName();
                    parameters.enabled = Boolean.TRUE;
                    parameters.origin = OpsParams.Origin.deploy;
                    HTMLActionReporter report = new HTMLActionReporter();
                    if (!sourceFile.isDirectory()) {
                        final File tmpFile = File.createTempFile(sourceFile.getName(), "");
                        String path = tmpFile.getAbsolutePath();
                        if (!tmpFile.delete()) {
                            this.logger.log(Level.WARNING, "NCLS-CORE-00036", path);
                        }
                        File tmpDir = new File(path);
                        FileUtils.deleteOnExit((File)tmpDir);
                        this.events.register(new EventListener(){

                            public void event(EventListener.Event event) {
                                if (event.is(EventTypes.SERVER_SHUTDOWN) && tmpFile.exists()) {
                                    FileUtils.whack((File)tmpFile);
                                }
                            }
                        });
                        if (tmpDir.mkdirs()) {
                            ArchiveHandler handler = this.deployment.getArchiveHandler(sourceArchive);
                            String appName = handler.getDefaultApplicationName(sourceArchive);
                            DeploymentContextImpl dummyContext = new DeploymentContextImpl((ActionReport)report, this.logger, sourceArchive, (OpsParams)parameters, this.env);
                            handler.expand(sourceArchive, ((ArchiveFactory)this.archiveFactoryProvider.get()).createArchive(tmpDir), (DeploymentContext)dummyContext);
                            sourceArchive = ((ArchiveFactory)this.archiveFactoryProvider.get()).openArchive(tmpDir);
                            this.logger.log(Level.INFO, "NCLS-CORE-00037", tmpDir.getAbsolutePath());
                            parameters.name = appName;
                        }
                    }
                    if ((appDeployment = this.deployment.prepare(null, depContext = this.deployment.getBuilder(this.logger, (OpsParams)parameters, (ActionReport)report).source(sourceArchive).build())) == null) {
                        this.logger.log(Level.SEVERE, "NCLS-CORE-00038", sourceFile.getAbsolutePath());
                    } else {
                        appDeployments.add(appDeployment);
                    }
                }
                catch (IOException | RuntimeException e) {
                    this.logger.log(Level.SEVERE, "NCLS-CORE-00039", e);
                }
                finally {
                    if (sourceArchive != null) {
                        try {
                            sourceArchive.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
        }
        this.events.send(new EventListener.Event<Object>(Deployment.ALL_APPLICATIONS_LOADED, null), false);
        for (Deployment.ApplicationDeployment depl : appDeployments) {
            this.deployment.initialize(depl.appInfo, depl.appInfo.getSniffers(), depl.context);
        }
        this.events.send(new EventListener.Event<Object>(Deployment.ALL_APPLICATIONS_PROCESSED, null));
    }

    private void initializeRuntimeDependencies() {
        this.habitat.getAllServices((Filter)BuilderHelper.createNameFilter((String)"ManagedBeanManagerImpl"));
        this.habitat.getAllServices((Filter)BuilderHelper.createNameFilter((String)"ResourceManager"));
        this.habitat.getAllServices((Filter)BuilderHelper.createNameFilter((String)"ApplicationScopedResourcesManager"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Deployment.ApplicationDeployment> processApplication(Application app, ApplicationRef appRef) {
        URI uri;
        long operationStartTime = Calendar.getInstance().getTimeInMillis();
        this.initializeRuntimeDependencies();
        String source = app.getLocation();
        String appName = app.getName();
        if (Boolean.valueOf(app.getDeployProperties().getProperty("isLifecycle")).booleanValue()) {
            return Collections.emptyList();
        }
        try {
            uri = new URI(source);
        }
        catch (URISyntaxException e) {
            this.logger.log(Level.SEVERE, "NCLS-CORE-00040", e.getLocalizedMessage());
            return Collections.emptyList();
        }
        ArrayList<Deployment.ApplicationDeployment> appDeployments = new ArrayList<Deployment.ApplicationDeployment>();
        File sourceFile = new File(uri);
        if (sourceFile.exists()) {
            try {
                Archive archive = null;
                try {
                    StructuredDeploymentTracing structuredTracing = this.deploymentTracingEnabled != null ? StructuredDeploymentTracing.create((String)app.getName()) : StructuredDeploymentTracing.createDisabled((String)app.getName());
                    DeploymentTracing tracing = null;
                    DeployCommandParameters deploymentParams = app.getDeployParameters(appRef);
                    deploymentParams.target = this.server.getName();
                    deploymentParams.origin = OpsParams.Origin.load;
                    deploymentParams.command = OpsParams.Command.startup_server;
                    if (this.domain.isAppReferencedByPaaSTarget(appName) && this.server.isDas()) {
                        deploymentParams.target = this.deployment.getDefaultTarget(appName, deploymentParams.origin, deploymentParams._classicstyle);
                    }
                    archive = ((ArchiveFactory)this.archiveFactoryProvider.get()).openArchive(sourceFile, deploymentParams);
                    HTMLActionReporter report = new HTMLActionReporter();
                    ExtendedDeploymentContext depContext = this.deployment.getBuilder(this.logger, (OpsParams)deploymentParams, (ActionReport)report).source((ReadableArchive)archive).build();
                    tracing = structuredTracing.register((DeploymentContext)depContext);
                    depContext.getAppProps().putAll((Map<?, ?>)app.getDeployProperties());
                    depContext.setModulePropsMap(app.getModulePropertiesMap());
                    new ApplicationConfigInfo(app).store(depContext.getAppProps());
                    appDeployments.add(this.deployment.prepare((Collection)this.deployment.getSniffersFromApp(app), depContext));
                    appDeployments.addAll(this.loadApplicationForTenants(app, appRef, (ActionReport)report));
                    if (report.getActionExitCode().equals((Object)ActionReport.ExitCode.SUCCESS)) {
                        if (tracing != null) {
                            tracing.print(System.out);
                        }
                        this.logger.log(Level.INFO, "NCLS-CORE-00022", new Object[]{appName, Calendar.getInstance().getTimeInMillis() - operationStartTime});
                    } else {
                        this.logger.log(Level.SEVERE, "NCLS-CORE-00041", report.getMessage());
                    }
                }
                finally {
                    if (archive != null) {
                        try {
                            archive.close();
                        }
                        catch (IOException e) {
                            this.logger.log(Level.FINE, "NCLS-CORE-00039", e);
                        }
                    }
                }
            }
            catch (IOException e) {
                this.logger.log(Level.SEVERE, "NCLS-CORE-00042", e);
            }
        } else {
            this.logger.log(Level.SEVERE, "NCLS-CORE-00043", source);
        }
        appDeployments.removeIf(t -> t == null);
        return appDeployments;
    }

    public String toString() {
        return "Application Loader";
    }

    public void preDestroy() {
        ApplicationInfo appInfo;
        ArrayList allApplications = new ArrayList();
        List standaloneAdapters = this.applications.getApplicationsWithSnifferType("connector", true);
        allApplications.addAll(this.applications.getApplications());
        allApplications.addAll(this.systemApplications.getApplications());
        for (Application app : allApplications) {
            if (app.isStandaloneModule() && app.containsSnifferType("connector")) continue;
            appInfo = this.deployment.get(app.getName());
            this.stopApplication(app, appInfo);
        }
        for (Application app : standaloneAdapters) {
            appInfo = this.deployment.get(app.getName());
            this.stopApplication(app, appInfo);
        }
        HashSet allAppNames = new HashSet();
        allAppNames.addAll(this.appRegistry.getAllApplicationNames());
        for (String appName : allAppNames) {
            ApplicationInfo appInfo2 = this.appRegistry.get(appName);
            this.stopApplication(null, appInfo2);
        }
        for (EngineInfo engineInfo : this.containerRegistry.getContainers()) {
            engineInfo.stop(this.logger);
        }
        this.events.send(new EventListener.Event<Object>(Deployment.ALL_APPLICATIONS_STOPPED, null), false);
    }

    private void stopApplication(Application app, ApplicationInfo appInfo) {
        HTMLActionReporter dummy = new HTMLActionReporter();
        if (appInfo != null) {
            UndeployCommandParameters parameters = new UndeployCommandParameters(appInfo.getName());
            parameters.origin = OpsParams.Origin.unload;
            parameters.command = OpsParams.Command.shutdown_server;
            try {
                this.deployment.disable(parameters, app, appInfo, (ActionReport)dummy, this.logger);
            }
            catch (Exception e) {
                this.logger.log(Level.SEVERE, "NCLS-CORE-00025", e);
            }
            this.unloadApplicationForTenants(app, (ActionReport)dummy);
            this.appRegistry.remove(appInfo.getName());
        }
    }

    private void unloadApplicationForTenants(Application app, ActionReport report) {
        if (app == null || app.getAppTenants() == null) {
            return;
        }
        for (AppTenant tenant : app.getAppTenants().getAppTenant()) {
            UndeployCommandParameters parameters = new UndeployCommandParameters();
            parameters.name = DeploymentUtils.getInternalNameForTenant((String)app.getName(), (String)tenant.getTenant());
            parameters.origin = OpsParams.Origin.unload;
            parameters.target = this.server.getName();
            ApplicationInfo appInfo = this.deployment.get(parameters.name);
            if (appInfo == null) continue;
            ActionReport subReport = report.addSubActionsReport();
            try {
                ExtendedDeploymentContext deploymentContext = this.deployment.getBuilder(KernelLoggerInfo.getLogger(), (OpsParams)parameters, subReport).source(appInfo.getSource()).build();
                deploymentContext.getAppProps().putAll((Map<?, ?>)app.getDeployProperties());
                deploymentContext.getAppProps().putAll((Map<?, ?>)tenant.getDeployProperties());
                deploymentContext.setModulePropsMap(app.getModulePropertiesMap());
                deploymentContext.setTenant(tenant.getTenant(), app.getName());
                this.deployment.unload(appInfo, deploymentContext);
            }
            catch (Throwable e) {
                subReport.setActionExitCode(ActionReport.ExitCode.FAILURE);
                subReport.setMessage(e.getMessage());
                subReport.setFailureCause(e);
            }
            this.appRegistry.remove(appInfo.getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Deployment.ApplicationDeployment> loadApplicationForTenants(Application app, ApplicationRef appRef, ActionReport report) {
        if (app.getAppTenants() == null) {
            return Collections.unmodifiableList(Collections.emptyList());
        }
        ArrayList<Deployment.ApplicationDeployment> appDeployments = new ArrayList<Deployment.ApplicationDeployment>();
        for (AppTenant tenant : app.getAppTenants().getAppTenant()) {
            DeployCommandParameters commandParams = app.getDeployParameters(appRef);
            commandParams.contextroot = tenant.getContextRoot();
            commandParams.target = this.server.getName();
            commandParams.name = DeploymentUtils.getInternalNameForTenant((String)app.getName(), (String)tenant.getTenant());
            commandParams.enabled = Boolean.TRUE;
            commandParams.origin = OpsParams.Origin.load;
            ActionReport subReport = report.addSubActionsReport();
            Archive archive = null;
            try {
                URI uri = new URI(app.getLocation());
                File file = new File(uri);
                if (file.exists()) {
                    archive = ((ArchiveFactory)this.archiveFactoryProvider.get()).openArchive(file);
                    ExtendedDeploymentContext deploymentContext = this.deployment.getBuilder(KernelLoggerInfo.getLogger(), (OpsParams)commandParams, subReport).source((ReadableArchive)archive).build();
                    deploymentContext.getAppProps().putAll((Map<?, ?>)app.getDeployProperties());
                    deploymentContext.getAppProps().putAll((Map<?, ?>)tenant.getDeployProperties());
                    deploymentContext.setModulePropsMap(app.getModulePropertiesMap());
                    deploymentContext.setTenant(tenant.getTenant(), app.getName());
                    appDeployments.add(this.deployment.prepare((Collection)this.deployment.getSniffersFromApp(app), deploymentContext));
                    continue;
                }
                this.logger.log(Level.SEVERE, "NCLS-CORE-00043", app.getLocation());
            }
            catch (Throwable e) {
                subReport.setActionExitCode(ActionReport.ExitCode.FAILURE);
                subReport.setMessage(e.getMessage());
                subReport.setFailureCause(e);
            }
            finally {
                try {
                    if (archive == null) continue;
                    archive.close();
                }
                catch (IOException uri) {}
            }
        }
        return Collections.unmodifiableList(appDeployments);
    }

    private boolean loadAppOnDAS(String appName) {
        if (this.server.isDas()) {
            List targets = this.domain.getAllReferencedTargetsForApplication(appName);
            for (String target : targets) {
                if (DeploymentUtils.isDASTarget((String)target)) continue;
                return true;
            }
        }
        return false;
    }
}

