/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.web.admin.cli;

import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.HttpService;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.lang.annotation.Annotation;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.CommandLock;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RestEndpoint;
import org.glassfish.api.admin.RestEndpoints;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.grizzly.config.dom.Protocol;
import org.glassfish.grizzly.config.dom.ProtocolChain;
import org.glassfish.grizzly.config.dom.ProtocolFilter;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.internal.api.Target;
import org.jvnet.hk2.annotations.Service;

@Service(name="list-protocol-filters")
@PerLookup
@CommandLock(value=CommandLock.LockType.NONE)
@I18n(value="list.protocol.filters")
@ExecuteOn(value={RuntimeType.DAS})
@TargetType(value={CommandTarget.DAS, CommandTarget.STANDALONE_INSTANCE, CommandTarget.CLUSTER, CommandTarget.CONFIG})
@RestEndpoints(value={@RestEndpoint(configBean=HttpService.class, opType=RestEndpoint.OpType.GET, path="list-protocol-filters", description="list-protocol-filters")})
public class ListProtocolFilters
implements AdminCommand {
    @Param(name="target", optional=true, defaultValue="server")
    String target;
    @Param(name="protocol", primary=true)
    String protocolName;
    @Inject
    @Named(value="default-instance-name")
    Config config;
    @Inject
    Domain domain;
    @Inject
    ServiceLocator services;

    public void execute(AdminCommandContext context) {
        ProtocolChain chain;
        Target targetUtil = (Target)this.services.getService(Target.class, new Annotation[0]);
        Config newConfig = targetUtil.getConfig(this.target);
        if (newConfig != null) {
            this.config = newConfig;
        }
        ActionReport report = context.getActionReport();
        Protocol protocol = this.config.getNetworkConfig().getProtocols().findProtocol(this.protocolName);
        if (protocol != null && protocol.getProtocolChainInstanceHandler() != null && (chain = protocol.getProtocolChainInstanceHandler().getProtocolChain()) != null) {
            for (ProtocolFilter filter : chain.getProtocolFilter()) {
                report.getTopMessagePart().addChild().setMessage(filter.getName());
            }
        }
        report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
    }
}

