/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.connectors.config.validators;

import com.sun.enterprise.config.serverbeans.ResourcePool;
import jakarta.validation.ConstraintValidator;
import jakarta.validation.ConstraintValidatorContext;
import org.glassfish.connectors.config.ConnectorConnectionPool;
import org.glassfish.connectors.config.validators.ConnectionPoolConstraint;
import org.glassfish.connectors.config.validators.ConnectionPoolErrorMessages;

public class ConnectionPoolValidator
implements ConstraintValidator<ConnectionPoolConstraint, ResourcePool> {
    protected ConnectionPoolErrorMessages poolFaults;

    public void initialize(ConnectionPoolConstraint constraint) {
        this.poolFaults = constraint.value();
    }

    public boolean isValid(ResourcePool pool, ConstraintValidatorContext constraintValidatorContext) {
        if (!ConnectorConnectionPool.class.isInstance(pool)) {
            return true;
        }
        ConnectorConnectionPool connPool = (ConnectorConnectionPool)pool;
        if (this.poolFaults == ConnectionPoolErrorMessages.POOL_SIZE_STEADY) {
            return this.getSteadyPoolSize(connPool) >= 0;
        }
        if (this.poolFaults == ConnectionPoolErrorMessages.POOL_SIZE_MAX) {
            int steadyPoolSize = this.getSteadyPoolSize(connPool);
            int maxPoolSize = this.getMaxPoolSize(connPool);
            return maxPoolSize > 0 && maxPoolSize >= steadyPoolSize;
        }
        return true;
    }

    private int getSteadyPoolSize(ConnectorConnectionPool pool) {
        return this.toInt(pool.getSteadyPoolSize(), "8");
    }

    private int getMaxPoolSize(ConnectorConnectionPool pool) {
        return this.toInt(pool.getMaxPoolSize(), "32");
    }

    private int toInt(String valueToParse, String defaultValue) {
        if (valueToParse == null) {
            return Integer.parseInt(defaultValue);
        }
        return Integer.parseInt(valueToParse);
    }
}

