/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.realm;

import com.sun.enterprise.util.Utility;
import jakarta.servlet.ServletContext;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.nio.charset.CharacterCodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.cert.X509Certificate;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.logging.Level;
import javax.management.ObjectName;
import org.apache.catalina.Authenticator;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.HttpRequest;
import org.apache.catalina.HttpResponse;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.LogFacade;
import org.apache.catalina.Logger;
import org.apache.catalina.Realm;
import org.apache.catalina.authenticator.AuthenticatorBase;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.deploy.LoginConfig;
import org.apache.catalina.deploy.SecurityCollection;
import org.apache.catalina.deploy.SecurityConstraint;
import org.apache.catalina.realm.GenericPrincipal;
import org.apache.catalina.util.HexUtils;
import org.apache.catalina.util.LifecycleSupport;
import org.apache.catalina.util.MD5Encoder;

public abstract class RealmBase
implements Lifecycle,
Realm {
    protected static final java.util.logging.Logger log = LogFacade.getLogger();
    protected static final ResourceBundle rb = log.getResourceBundle();
    private static final String DATE_ONE = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz", Locale.US).format(new Date(1L));
    protected int debug = 0;
    protected Container container;
    protected boolean checkIfRequestIsSecure;
    protected String digest;
    protected String digestEncoding;
    protected static final String info = "org.apache.catalina.realm.RealmBase/1.0";
    protected LifecycleSupport lifecycle = new LifecycleSupport(this);
    protected volatile MessageDigest md;
    protected static final MD5Encoder md5Encoder = new MD5Encoder();
    protected static volatile MessageDigest md5Helper;
    protected boolean started;
    protected PropertyChangeSupport support = new PropertyChangeSupport(this);
    protected boolean validate = true;
    protected ObjectName controller;

    @Override
    public Container getContainer() {
        return this.container;
    }

    public int getDebug() {
        return this.debug;
    }

    public void setDebug(int debug) {
        this.debug = debug;
    }

    @Override
    public void setContainer(Container container) {
        Container oldContainer = this.container;
        this.container = container;
        this.checkIfRequestIsSecure = container.isCheckIfRequestIsSecure();
        this.support.firePropertyChange("container", oldContainer, this.container);
    }

    public String getDigest() {
        return this.digest;
    }

    public void setDigest(String digest) {
        this.digest = digest;
    }

    public String getDigestEncoding() {
        return this.digestEncoding;
    }

    public void setDigestEncoding(String charset) {
        this.digestEncoding = charset;
    }

    @Override
    public String getInfo() {
        return info;
    }

    public boolean getValidate() {
        return this.validate;
    }

    public void setValidate(boolean validate) {
        this.validate = validate;
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.support.addPropertyChangeListener(listener);
    }

    @Override
    public Principal authenticate(String username, char[] credentials) {
        char[] serverCredentials = this.getPassword(username);
        boolean validated = serverCredentials == null ? false : (this.hasMessageDigest() ? this.equalsIgnoreCase(serverCredentials, this.digest(credentials)) : Arrays.equals(serverCredentials, credentials));
        if (!validated) {
            return null;
        }
        return this.getPrincipal(username);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Principal authenticate(String username, char[] clientDigest, String nOnce, String nc, String cnonce, String qop, String realm, char[] md5a2) {
        char[] md5a1 = this.getDigest(username, realm);
        if (md5a1 == null) {
            return null;
        }
        int nOnceLength = nOnce != null ? nOnce.length() : 0;
        int ncLength = nc != null ? nc.length() : 0;
        int cnonceLength = cnonce != null ? cnonce.length() : 0;
        int qopLength = qop != null ? qop.length() : 0;
        int md5a2Length = md5a2 != null ? md5a2.length : 0;
        char[] serverDigestValue = new char[md5a1.length + 1 + nOnceLength + 1 + ncLength + 1 + cnonceLength + 1 + qopLength + 1 + md5a2Length];
        System.arraycopy(md5a1, 0, serverDigestValue, 0, md5a1.length);
        int ind = md5a1.length;
        serverDigestValue[ind++] = 58;
        if (nOnce != null) {
            System.arraycopy(nOnce.toCharArray(), 0, serverDigestValue, ind, nOnceLength);
            ind += nOnceLength;
        }
        serverDigestValue[ind++] = 58;
        if (nc != null) {
            System.arraycopy(nc.toCharArray(), 0, serverDigestValue, ind, ncLength);
            ind += ncLength;
        }
        serverDigestValue[ind++] = 58;
        if (cnonce != null) {
            System.arraycopy(cnonce.toCharArray(), 0, serverDigestValue, ind, cnonceLength);
            ind += cnonceLength;
        }
        serverDigestValue[ind++] = 58;
        if (qop != null) {
            System.arraycopy(qop.toCharArray(), 0, serverDigestValue, ind, qopLength);
            ind += qopLength;
        }
        serverDigestValue[ind++] = 58;
        if (md5a2 != null) {
            System.arraycopy(md5a2, 0, serverDigestValue, ind, md5a2Length);
        }
        byte[] valueBytes = null;
        try {
            valueBytes = Utility.convertCharArrayToByteArray((char[])serverDigestValue, (String)this.getDigestEncoding());
        }
        catch (CharacterCodingException cce) {
            String msg = MessageFormat.format(rb.getString("AS-WEB-CORE-00312"), this.getDigestEncoding());
            log.log(Level.SEVERE, msg, cce);
            throw new IllegalArgumentException(cce.getMessage());
        }
        char[] serverDigest = null;
        Object msg = md5Helper;
        synchronized (msg) {
            serverDigest = md5Encoder.encode(md5Helper.digest(valueBytes));
        }
        if (log.isLoggable(Level.FINE)) {
            msg = "Username:" + username + " ClientSigest:" + Arrays.toString(clientDigest) + " nOnce:" + nOnce + " nc:" + nc + " cnonce:" + cnonce + " qop:" + qop + " realm:" + realm + "md5a2:" + Arrays.toString(md5a2) + " Server digest:" + String.valueOf(serverDigest);
            log.log(Level.FINE, (String)msg);
        }
        if (Arrays.equals(serverDigest, clientDigest)) {
            return this.getPrincipal(username);
        }
        return null;
    }

    @Override
    public Principal authenticate(X509Certificate[] certificates) {
        if (certificates == null || certificates.length < 1) {
            return null;
        }
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "Authenticating client certificate chain");
        }
        if (this.validate) {
            for (X509Certificate certificate : certificates) {
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, "Checking validity for ''{0}''", certificate.getSubjectX500Principal().getName());
                }
                try {
                    certificate.checkValidity();
                }
                catch (Exception e) {
                    log.log(Level.FINE, "Validity exception", e);
                    return null;
                }
            }
        }
        return this.getPrincipal(certificates[0].getSubjectX500Principal().getName());
    }

    public void backgroundProcess() {
    }

    @Override
    public SecurityConstraint[] findSecurityConstraints(HttpRequest request, Context context) {
        return this.findSecurityConstraints(request.getRequestPathMB().toString(), ((HttpServletRequest)request.getRequest()).getMethod(), context);
    }

    @Override
    public SecurityConstraint[] findSecurityConstraints(String uri, String method, Context context) {
        int j;
        ArrayList<SecurityConstraint> results = null;
        if (!context.hasConstraints()) {
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "  No applicable constraints defined");
            }
            return null;
        }
        String origUri = uri;
        boolean caseSensitiveMapping = ((StandardContext)context).isCaseSensitiveMapping();
        if (uri != null && !caseSensitiveMapping) {
            uri = uri.toLowerCase(Locale.ENGLISH);
        }
        boolean found = false;
        List<SecurityConstraint> constraints = context.getConstraints();
        for (SecurityConstraint constraint : constraints) {
            SecurityCollection[] collection2 = constraint.findCollections();
            if (collection2 == null) continue;
            if (log.isLoggable(Level.FINEST)) {
                String string = "Checking constraint '" + constraint + "' against " + method + " " + origUri + " --> " + constraint.included(uri, method, caseSensitiveMapping);
                log.log(Level.FINEST, string);
            }
            if (log.isLoggable(Level.FINE) && constraint.included(uri, method, caseSensitiveMapping)) {
                log.log(Level.FINE, "  Matched constraint ''{0}'' against {1} {2}", new Object[]{constraint, method, origUri});
            }
            for (SecurityCollection collection1 : collection2) {
                String[] patterns = collection1.findPatterns();
                if (patterns == null) continue;
                for (int k = 0; k < patterns.length; ++k) {
                    String pattern;
                    String string = pattern = caseSensitiveMapping ? patterns[k] : patterns[k].toLowerCase(Locale.ENGLISH);
                    if (uri == null || !uri.equals(pattern)) continue;
                    found = true;
                    if (!collection1.findMethod(method)) continue;
                    if (results == null) {
                        results = new ArrayList();
                    }
                    results.add(constraint);
                }
            }
        }
        if (found) {
            return this.resultsToArray(results);
        }
        int longest = -1;
        for (SecurityConstraint constraint : constraints) {
            SecurityCollection[] securityCollectionArray = constraint.findCollections();
            if (securityCollectionArray == null) continue;
            if (log.isLoggable(Level.FINEST)) {
                String msg = "  Checking constraint '" + constraint + "' against " + method + " " + origUri + " --> " + constraint.included(uri, method, caseSensitiveMapping);
                log.log(Level.FINE, msg);
            }
            if (log.isLoggable(Level.FINE) && constraint.included(uri, method, caseSensitiveMapping)) {
                log.log(Level.FINE, "  Matched constraint ''{0}'' against {1} {2}", new Object[]{constraint, method, origUri});
            }
            for (j = 0; j < securityCollectionArray.length; ++j) {
                String[] patterns = securityCollectionArray[j].findPatterns();
                if (patterns == null) continue;
                boolean matched = false;
                int length = -1;
                for (String pattern1 : patterns) {
                    String pattern;
                    String string = pattern = caseSensitiveMapping ? pattern1 : pattern1.toLowerCase(Locale.ENGLISH);
                    if (!pattern.startsWith("/") || !pattern.endsWith("/*") || pattern.length() < longest) continue;
                    if (pattern.length() == 2) {
                        matched = true;
                        length = pattern.length();
                        continue;
                    }
                    if (uri == null || !pattern.regionMatches(0, uri, 0, pattern.length() - 1) && (pattern.length() - 2 != uri.length() || !pattern.regionMatches(0, uri, 0, pattern.length() - 2))) continue;
                    matched = true;
                    length = pattern.length();
                }
                if (!matched) continue;
                found = true;
                if (length > longest) {
                    if (results != null) {
                        results.clear();
                    }
                    longest = length;
                }
                if (!securityCollectionArray[j].findMethod(method)) continue;
                if (results == null) {
                    results = new ArrayList();
                }
                results.add(constraint);
            }
        }
        if (found) {
            return this.resultsToArray(results);
        }
        for (SecurityConstraint constraint : constraints) {
            SecurityCollection[] securityCollectionArray = constraint.findCollections();
            if (securityCollectionArray == null) continue;
            if (log.isLoggable(Level.FINEST)) {
                String msg = "  Checking constraint '" + constraint + "' against " + method + " " + origUri + " --> " + constraint.included(uri, method, caseSensitiveMapping);
                log.log(Level.FINEST, msg);
            }
            if (log.isLoggable(Level.FINE) && constraint.included(uri, method, caseSensitiveMapping)) {
                log.log(Level.FINE, "  Matched constraint ''{0}'' against {1} {2}", new Object[]{constraint, method, origUri});
            }
            boolean matched = false;
            int pos = -1;
            for (int j2 = 0; j2 < securityCollectionArray.length; ++j2) {
                String[] patterns = securityCollectionArray[j2].findPatterns();
                if (patterns == null) continue;
                for (int k = 0; k < patterns.length && !matched; ++k) {
                    String pattern;
                    String string = pattern = caseSensitiveMapping ? patterns[k] : patterns[k].toLowerCase(Locale.ENGLISH);
                    if (uri == null || !pattern.startsWith("*.")) continue;
                    int slash = uri.lastIndexOf(47);
                    int dot = uri.lastIndexOf(46);
                    if (slash < 0 || dot <= slash || dot == uri.length() - 1 || uri.length() - dot != pattern.length() - 1 || !pattern.regionMatches(1, uri, dot, uri.length() - dot)) continue;
                    matched = true;
                    pos = j2;
                }
            }
            if (!matched) continue;
            found = true;
            if (!securityCollectionArray[pos].findMethod(method)) continue;
            if (results == null) {
                results = new ArrayList<SecurityConstraint>();
            }
            results.add(constraint);
        }
        if (found) {
            return this.resultsToArray(results);
        }
        for (SecurityConstraint constraint : constraints) {
            SecurityCollection[] securityCollectionArray = constraint.findCollections();
            if (securityCollectionArray == null) continue;
            if (log.isLoggable(Level.FINEST)) {
                String msg = "  Checking constraint '" + constraint + "' against " + method + " " + origUri + " --> " + constraint.included(uri, method, caseSensitiveMapping);
                log.log(Level.FINEST, msg);
            }
            if (log.isLoggable(Level.FINE) && constraint.included(uri, method, caseSensitiveMapping)) {
                log.log(Level.FINE, "  Matched constraint ''{0}'' against {1} {2}", new Object[]{constraint, method, origUri});
            }
            for (j = 0; j < securityCollectionArray.length; ++j) {
                String[] patterns = securityCollectionArray[j].findPatterns();
                if (patterns == null) continue;
                boolean matched = false;
                for (int k = 0; k < patterns.length && !matched; ++k) {
                    String pattern;
                    String string = pattern = caseSensitiveMapping ? patterns[k] : patterns[k].toLowerCase(Locale.ENGLISH);
                    if (!pattern.equals("/")) continue;
                    matched = true;
                }
                if (!matched) continue;
                if (results == null) {
                    results = new ArrayList();
                }
                results.add(constraint);
            }
        }
        if (results == null && log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "  No applicable constraint located");
        }
        return this.resultsToArray(results);
    }

    private SecurityConstraint[] resultsToArray(ArrayList<SecurityConstraint> results) {
        if (results == null) {
            return null;
        }
        SecurityConstraint[] array = new SecurityConstraint[results.size()];
        results.toArray(array);
        return array;
    }

    @Override
    public boolean hasResourcePermission(HttpRequest request, HttpResponse response, SecurityConstraint[] constraints, Context context) throws IOException {
        if (constraints == null || constraints.length == 0) {
            return true;
        }
        Principal principal = ((HttpServletRequest)request.getRequest()).getUserPrincipal();
        for (int i = 0; i < constraints.length; ++i) {
            SecurityConstraint constraint = constraints[i];
            String[] roles = constraint.findAuthRoles();
            if (roles == null) {
                roles = new String[]{};
            }
            if (constraint.getAllRoles()) {
                return true;
            }
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "  Checking roles {0}", principal);
            }
            if (roles.length == 0) {
                if (constraint.getAuthConstraint()) {
                    ((HttpServletResponse)response.getResponse()).sendError(403);
                    response.setDetailMessage(rb.getString("AS-WEB-CORE-00313"));
                    if (log.isLoggable(Level.FINE)) {
                        log.log(Level.FINE, "No roles ");
                    }
                    return false;
                }
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, "Passing all access");
                }
                return true;
            }
            if (principal == null) {
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, "  No user authenticated, cannot grant access");
                }
                ((HttpServletResponse)response.getResponse()).sendError(403);
                response.setDetailMessage(rb.getString("AS-WEB-CORE-00314"));
                return false;
            }
            for (int j = 0; j < roles.length; ++j) {
                if (this.hasRole(principal, roles[j])) {
                    if (log.isLoggable(Level.FINE)) {
                        log.log(Level.FINE, "Role found:  {0}", roles[j]);
                    }
                    return true;
                }
                if (!log.isLoggable(Level.FINE)) continue;
                log.log(Level.FINE, "No role found:  {0}", roles[j]);
            }
        }
        ((HttpServletResponse)response.getResponse()).sendError(403);
        response.setDetailMessage(rb.getString("AS-WEB-CORE-00313"));
        return false;
    }

    @Override
    public boolean hasRole(HttpRequest request, HttpResponse response, Principal principal, String role) {
        return this.hasRole(principal, role);
    }

    @Override
    public int preAuthenticateCheck(HttpRequest request, HttpResponse response, SecurityConstraint[] constraints, boolean disableProxyCaching, boolean securePagesWithPragma, boolean ssoEnabled) throws IOException {
        for (SecurityConstraint constraint : constraints) {
            if (!constraint.getAuthConstraint()) continue;
            this.disableProxyCaching(request, response, disableProxyCaching, securePagesWithPragma);
            return 1;
        }
        return 0;
    }

    @Override
    public boolean invokeAuthenticateDelegate(HttpRequest request, HttpResponse response, Context context, Authenticator authenticator, boolean calledFromAuthenticate) throws IOException {
        LoginConfig config = context.getLoginConfig();
        return ((AuthenticatorBase)authenticator).authenticate(request, response, config);
    }

    @Override
    public boolean invokePostAuthenticateDelegate(HttpRequest request, HttpResponse response, Context context) throws IOException {
        return true;
    }

    @Override
    public boolean hasRole(Principal principal, String role) {
        if (principal == null || role == null || !(principal instanceof GenericPrincipal)) {
            return false;
        }
        GenericPrincipal gp = (GenericPrincipal)principal;
        if (gp.getRealm() != this && log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "Different realm {0} {1}", new Object[]{this, gp.getRealm()});
        }
        boolean result = gp.hasRole(role);
        if (log.isLoggable(Level.FINE)) {
            String name = principal.getName();
            if (result) {
                log.log(Level.FINE, "AS-WEB-CORE-00315", new Object[]{name, role});
            } else {
                log.log(Level.FINE, "AS-WEB-CORE-00316", new Object[]{name, role});
            }
        }
        return result;
    }

    @Override
    public boolean hasUserDataPermission(HttpRequest request, HttpResponse response, SecurityConstraint[] constraints) throws IOException {
        return this.hasUserDataPermission(request, response, constraints, null, null);
    }

    @Override
    public boolean hasUserDataPermission(HttpRequest request, HttpResponse response, SecurityConstraint[] constraints, String uri, String method) throws IOException {
        String queryString;
        if (constraints == null || constraints.length == 0) {
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "  No applicable security constraint defined");
            }
            return true;
        }
        for (int i = 0; i < constraints.length; ++i) {
            SecurityConstraint constraint = constraints[i];
            String userConstraint = constraint.getUserConstraint();
            if (userConstraint == null) {
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, "  No applicable user data constraint defined");
                }
                return true;
            }
            if (!userConstraint.equals("NONE")) continue;
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "  User data constraint has no restrictions");
            }
            return true;
        }
        if (request.getRequest().isSecure()) {
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "  User data constraint already satisfied");
            }
            return true;
        }
        HttpServletRequest hrequest = (HttpServletRequest)request.getRequest();
        HttpServletResponse hresponse = (HttpServletResponse)response.getResponse();
        int redirectPort = request.getConnector().getRedirectPort();
        if (redirectPort <= 0) {
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "  SSL redirect is disabled");
            }
            hresponse.sendError(403);
            response.setDetailMessage(hrequest.getRequestURI());
            return false;
        }
        StringBuilder file = new StringBuilder();
        String protocol = "https";
        String host = hrequest.getServerName();
        file.append(protocol).append("://").append(host);
        if (redirectPort != 443) {
            file.append(":").append(redirectPort);
        }
        file.append(hrequest.getRequestURI());
        String requestedSessionId = hrequest.getRequestedSessionId();
        if (requestedSessionId != null && hrequest.isRequestedSessionIdFromURL()) {
            String sessionParameterName = request.getContext() != null ? request.getContext().getSessionParameterName() : "jsessionid";
            file.append(";").append(sessionParameterName).append("=");
            file.append(requestedSessionId);
        }
        if ((queryString = hrequest.getQueryString()) != null) {
            file.append('?');
            file.append(queryString);
        }
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "Redirecting to {0}", file.toString());
        }
        hresponse.sendRedirect(file.toString());
        return false;
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.support.removePropertyChangeListener(listener);
    }

    @Override
    public void addLifecycleListener(LifecycleListener listener) {
        this.lifecycle.addLifecycleListener(listener);
    }

    @Override
    public List<LifecycleListener> findLifecycleListeners() {
        return this.lifecycle.findLifecycleListeners();
    }

    @Override
    public void removeLifecycleListener(LifecycleListener listener) {
        this.lifecycle.removeLifecycleListener(listener);
    }

    @Override
    public void start() throws LifecycleException {
        if (this.started) {
            if (log.isLoggable(Level.INFO)) {
                log.log(Level.FINE, "AS-WEB-CORE-00317");
            }
            return;
        }
        this.lifecycle.fireLifecycleEvent("start", null);
        this.started = true;
        if (this.digest != null) {
            try {
                this.md = MessageDigest.getInstance(this.digest);
            }
            catch (NoSuchAlgorithmException e) {
                String msg = MessageFormat.format(rb.getString("AS-WEB-CORE-00318"), this.digest);
                throw new LifecycleException(msg, e);
            }
        }
    }

    @Override
    public void stop() throws LifecycleException {
        if (!this.started) {
            if (log.isLoggable(Level.INFO)) {
                log.log(Level.INFO, "AS-WEB-CORE-00319");
            }
            return;
        }
        this.lifecycle.fireLifecycleEvent("stop", null);
        this.started = false;
        this.md = null;
        this.destroy();
    }

    public void destroy() {
    }

    @Override
    public void logout(HttpRequest hreq) {
    }

    @Override
    public boolean isSecurityExtensionEnabled(ServletContext servletContext) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected char[] digest(char[] credentials) {
        if (!this.hasMessageDigest()) {
            return credentials;
        }
        RealmBase realmBase = this;
        synchronized (realmBase) {
            try {
                this.md.reset();
                byte[] bytes = null;
                try {
                    bytes = Utility.convertCharArrayToByteArray((char[])credentials, (String)this.getDigestEncoding());
                }
                catch (CharacterCodingException cce) {
                    String msg = MessageFormat.format(rb.getString("AS-WEB-CORE-00312"), this.getDigestEncoding());
                    log.log(Level.SEVERE, msg, cce);
                    throw new IllegalArgumentException(cce.getMessage());
                }
                this.md.update(bytes);
                return HexUtils.convert(this.md.digest());
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "AS-WEB-CORE-00320", e);
                return credentials;
            }
        }
    }

    protected boolean hasMessageDigest() {
        return this.md != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected char[] getDigest(String username, String realmName) {
        if (md5Helper == null) {
            try {
                md5Helper = MessageDigest.getInstance("MD5");
            }
            catch (NoSuchAlgorithmException e) {
                log.log(Level.SEVERE, "AS-WEB-CORE-00321", e);
                throw new IllegalStateException(e.getMessage());
            }
        }
        if (this.hasMessageDigest()) {
            return this.getPassword(username);
        }
        char[] pwd = this.getPassword(username);
        int usernameLength = username != null ? username.length() : 0;
        int realmNameLength = realmName != null ? realmName.length() : 0;
        int pwdLength = pwd != null ? pwd.length : 0;
        char[] digestValue = new char[usernameLength + 1 + realmNameLength + 1 + pwdLength];
        int ind = 0;
        if (username != null) {
            System.arraycopy(username.toCharArray(), 0, digestValue, 0, usernameLength);
            ind = usernameLength;
        }
        digestValue[ind++] = 58;
        if (realmName != null) {
            System.arraycopy(realmName.toCharArray(), 0, digestValue, ind, realmNameLength);
            ind += realmNameLength;
        }
        digestValue[ind++] = 58;
        if (pwd != null) {
            System.arraycopy(pwd, 0, digestValue, ind, pwdLength);
        }
        byte[] valueBytes = null;
        try {
            valueBytes = Utility.convertCharArrayToByteArray((char[])digestValue, (String)this.getDigestEncoding());
        }
        catch (CharacterCodingException cce) {
            String msg = MessageFormat.format(rb.getString("AS-WEB-CORE-00312"), this.getDigestEncoding());
            log.log(Level.SEVERE, msg, cce);
            throw new IllegalArgumentException(cce.getMessage());
        }
        byte[] digest = null;
        MessageDigest messageDigest = md5Helper;
        synchronized (messageDigest) {
            digest = md5Helper.digest(valueBytes);
        }
        return md5Encoder.encode(digest);
    }

    protected abstract String getName();

    protected abstract char[] getPassword(String var1);

    protected abstract Principal getPrincipal(String var1);

    protected void log(String message) {
        Logger logger = null;
        String name = null;
        if (this.container != null) {
            logger = this.container.getLogger();
            name = this.container.getName();
        }
        if (logger != null) {
            logger.log(this.getName() + "[" + name + "]: " + message);
        } else if (log.isLoggable(Level.INFO)) {
            log.log(Level.INFO, "{0}[{1}]: {2}", new Object[]{this.getName(), name, message});
        }
    }

    protected void log(String message, Throwable t) {
        Logger logger = null;
        String name = null;
        if (this.container != null) {
            logger = this.container.getLogger();
            name = this.container.getName();
        }
        if (logger != null) {
            logger.log(this.getName() + "[" + name + "]: " + message, t, 2);
        } else {
            log.log(Level.WARNING, this.getName() + "[" + name + "]: " + message, t);
        }
    }

    protected void disableProxyCaching(HttpRequest request, HttpResponse response, boolean disableProxyCaching, boolean securePagesWithPragma) {
        HttpServletRequest hsrequest = (HttpServletRequest)request.getRequest();
        if (!(!disableProxyCaching || "POST".equalsIgnoreCase(hsrequest.getMethod()) || this.checkIfRequestIsSecure && hsrequest.isSecure())) {
            HttpServletResponse sresponse = (HttpServletResponse)response.getResponse();
            if (securePagesWithPragma) {
                sresponse.setHeader("Pragma", "No-cache");
                sresponse.setHeader("Cache-Control", "no-cache");
            } else {
                sresponse.setHeader("Cache-Control", "private");
            }
            sresponse.setHeader("Expires", DATE_ONE);
        }
    }

    public ObjectName getController() {
        return this.controller;
    }

    public void setController(ObjectName controller) {
        this.controller = controller;
    }

    @Override
    public Principal getAlternatePrincipal(HttpRequest req) {
        return null;
    }

    @Override
    public String getAlternateAuthType(HttpRequest req) {
        return null;
    }

    @Override
    public void setRealmName(String name, String authMethod) {
    }

    @Override
    public String getRealmName() {
        return null;
    }

    @Override
    public Principal authenticate(HttpServletRequest hreq) {
        throw new UnsupportedOperationException();
    }

    private boolean equalsIgnoreCase(char[] arr1, char[] arr2) {
        if (arr1 == null) {
            return arr2 == null;
        }
        if (arr2 == null || arr1.length != arr2.length) {
            return false;
        }
        boolean result = true;
        for (int i = 0; i < arr1.length; ++i) {
            if (Character.toLowerCase(arr1[i]) == Character.toLowerCase(arr2[i])) continue;
            return false;
        }
        return result;
    }
}

