/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.startup;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.logging.Level;
import javax.naming.NamingException;
import javax.naming.directory.DirContext;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.Deployer;
import org.apache.catalina.Engine;
import org.apache.catalina.Host;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleEvent;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.LogFacade;
import org.apache.catalina.Logger;
import org.apache.catalina.core.StandardHost;
import org.apache.catalina.startup.ExpandWar;
import org.apache.naming.resources.ResourceAttributes;

public class HostConfig
implements LifecycleListener {
    private static final java.util.logging.Logger log = LogFacade.getLogger();
    private static final ResourceBundle rb = log.getResourceBundle();
    private File appBase = null;
    private File configBase = null;
    protected String configClass = "org.apache.catalina.startup.ContextConfig";
    protected String contextClass = "org.apache.catalina.core.StandardContext";
    protected int debug = 0;
    protected List<String> deployed = new ArrayList<String>();
    protected Host host = null;
    private boolean deployXML = false;
    private boolean unpackWARs = false;
    private final Map<String, Long> webXmlLastModified = new HashMap<String, Long>();
    private final Map<String, Long> contextXmlLastModified = new HashMap<String, Long>();
    private final HashMap<String, Long> warLastModified = new HashMap();
    private boolean xmlValidation = false;
    private boolean xmlNamespaceAware = false;
    protected Set<String> invalidWars = new HashSet<String>();

    public String getConfigClass() {
        return this.configClass;
    }

    public void setConfigClass(String configClass) {
        this.configClass = configClass;
    }

    public String getContextClass() {
        return this.contextClass;
    }

    public void setContextClass(String contextClass) {
        this.contextClass = contextClass;
    }

    public int getDebug() {
        return this.debug;
    }

    public void setDebug(int debug) {
        this.debug = debug;
    }

    public boolean isDeployXML() {
        return this.deployXML;
    }

    public void setDeployXML(boolean deployXML) {
        this.deployXML = deployXML;
    }

    public boolean isUnpackWARs() {
        return this.unpackWARs;
    }

    public void setUnpackWARs(boolean unpackWARs) {
        this.unpackWARs = unpackWARs;
    }

    public void setXmlValidation(boolean xmlValidation) {
        this.xmlValidation = xmlValidation;
    }

    public boolean getXmlValidation() {
        return this.xmlValidation;
    }

    public boolean getXmlNamespaceAware() {
        return this.xmlNamespaceAware;
    }

    public void setXmlNamespaceAware(boolean xmlNamespaceAware) {
        this.xmlNamespaceAware = xmlNamespaceAware;
    }

    @Override
    public void lifecycleEvent(LifecycleEvent event) {
        if (event.getType().equals("check")) {
            this.check();
        }
        try {
            this.host = (Host)((Object)event.getLifecycle());
            if (this.host instanceof StandardHost) {
                int hostDebug = ((StandardHost)this.host).getDebug();
                if (hostDebug > this.debug) {
                    this.debug = hostDebug;
                }
                this.setDeployXML(((StandardHost)this.host).isDeployXML());
                this.setUnpackWARs(((StandardHost)this.host).isUnpackWARs());
                this.setXmlNamespaceAware(((StandardHost)this.host).getXmlNamespaceAware());
                this.setXmlValidation(((StandardHost)this.host).getXmlValidation());
            }
        }
        catch (ClassCastException e) {
            String msg = MessageFormat.format(rb.getString("AS-WEB-CORE-00450"), event.getLifecycle());
            log.log(Level.SEVERE, msg, e);
            return;
        }
        if (event.getType().equals("start")) {
            this.start();
        } else if (event.getType().equals("stop")) {
            this.stop();
        }
    }

    protected File appBase() {
        if (this.appBase != null) {
            return this.appBase;
        }
        File file = new File(this.host.getAppBase());
        if (!file.isAbsolute()) {
            file = new File(System.getProperty("catalina.base"), this.host.getAppBase());
        }
        try {
            this.appBase = file.getCanonicalFile();
        }
        catch (IOException e) {
            this.appBase = file;
        }
        return this.appBase;
    }

    protected File configBase() {
        if (this.configBase != null) {
            return this.configBase;
        }
        File file = new File(System.getProperty("catalina.base"), "conf");
        Container parent = this.host.getParent();
        if (parent != null && parent instanceof Engine) {
            file = new File(file, parent.getName());
        }
        file = new File(file, this.host.getName());
        try {
            this.configBase = file.getCanonicalFile();
        }
        catch (IOException e) {
            this.configBase = file;
        }
        return this.configBase;
    }

    protected void deployApps() {
        if (!(this.host instanceof Deployer)) {
            return;
        }
        File appBase = this.appBase();
        if (!appBase.exists() || !appBase.isDirectory()) {
            return;
        }
        File configBase = this.configBase();
        if (configBase.exists() && configBase.isDirectory()) {
            String[] configFiles = configBase.list();
            this.deployDescriptors(configBase, configFiles);
        }
        String[] files = appBase.list();
        this.deployWARs(appBase, files);
        this.deployDirectories(appBase, files);
    }

    protected void deployDescriptors(File configBase, String[] files) {
        if (!this.deployXML) {
            return;
        }
        for (int i = 0; i < files.length; ++i) {
            if (files[i].equalsIgnoreCase("META-INF") || files[i].equalsIgnoreCase("WEB-INF") || this.deployed.contains(files[i])) continue;
            File dir = new File(configBase, files[i]);
            if (!files[i].toLowerCase(Locale.ENGLISH).endsWith(".xml")) continue;
            this.deployed.add(files[i]);
            String file = files[i].substring(0, files[i].length() - 4);
            Object contextPath = "/" + file.replace('_', '/');
            if (file.equals("ROOT")) {
                contextPath = "";
            }
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "AS-WEB-CORE-00451", files[i]);
            }
            try {
                if (this.host.findChild((String)contextPath) != null) {
                    if (!this.deployed.contains(file) && !this.deployed.contains(file + ".war")) continue;
                    ((Deployer)((Object)this.host)).remove((String)contextPath);
                }
                URL config = new URL("file", null, dir.getCanonicalPath());
                ((Deployer)((Object)this.host)).install(config, null);
                continue;
            }
            catch (Throwable t) {
                String msg = MessageFormat.format(rb.getString("AS-WEB-CORE-00452"), files[i]);
                log.log(Level.SEVERE, msg, t);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deployWARs(File appBase, String[] files) {
        for (String file : files) {
            URL url;
            if (file.equalsIgnoreCase("META-INF") || file.equalsIgnoreCase("WEB-INF") || this.deployed.contains(file)) continue;
            File dir = new File(appBase, file);
            if (!file.toLowerCase(Locale.ENGLISH).endsWith(".war") || !dir.isFile() || this.invalidWars.contains(file)) continue;
            this.deployed.add(file);
            Object contextPath = "/" + file;
            int period = ((String)contextPath).lastIndexOf(46);
            if (period >= 0) {
                contextPath = ((String)contextPath).substring(0, period);
            }
            if (!this.validateContextPath(appBase, (String)contextPath)) {
                log.log(Level.SEVERE, "AS-WEB-CORE-00453", file);
                this.invalidWars.add(file);
                continue;
            }
            if (((String)contextPath).equals("/ROOT")) {
                contextPath = "";
            }
            if (this.host.findChild((String)contextPath) != null) continue;
            JarFile jar = null;
            JarEntry entry = null;
            InputStream istream = null;
            FilterOutputStream ostream = null;
            File xml = new File(this.configBase, file.substring(0, file.lastIndexOf(".")) + ".xml");
            if (!xml.exists()) {
                try {
                    jar = new JarFile(dir);
                    entry = jar.getJarEntry("META-INF/context.xml");
                    if (entry != null) {
                        int n;
                        istream = jar.getInputStream(entry);
                        ostream = new BufferedOutputStream(new FileOutputStream(xml), 1024);
                        byte[] buffer = new byte[1024];
                        while ((n = istream.read(buffer)) >= 0) {
                            ((BufferedOutputStream)ostream).write(buffer, 0, n);
                        }
                        ((BufferedOutputStream)ostream).flush();
                        ostream.close();
                        ostream = null;
                        istream.close();
                        istream = null;
                        entry = null;
                        jar.close();
                        jar = null;
                        this.deployDescriptors(this.configBase(), this.configBase.list());
                        return;
                    }
                }
                catch (IOException buffer) {
                }
                finally {
                    if (ostream != null) {
                        try {
                            ostream.close();
                        }
                        catch (Throwable n) {}
                        ostream = null;
                    }
                    if (istream != null) {
                        try {
                            istream.close();
                        }
                        catch (Throwable n) {}
                        istream = null;
                    }
                    entry = null;
                    if (jar != null) {
                        try {
                            jar.close();
                        }
                        catch (Throwable n) {}
                        jar = null;
                    }
                }
            }
            if (this.isUnpackWARs()) {
                String msg;
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, "AS-WEB-CORE-00454", file);
                }
                url = null;
                String path = null;
                try {
                    url = new URL("jar:file:" + dir.getCanonicalPath() + "!/");
                    path = ExpandWar.expand(this.host, url);
                }
                catch (IOException e) {
                    log.log(Level.WARNING, "AS-WEB-CORE-00455", file);
                    continue;
                }
                catch (Throwable t) {
                    msg = MessageFormat.format(rb.getString("AS-WEB-CORE-00456"), file);
                    log.log(Level.SEVERE, msg, t);
                    continue;
                }
                try {
                    if (path == null) continue;
                    url = new URL("file:" + path);
                    ((Deployer)((Object)this.host)).install((String)contextPath, url);
                }
                catch (Throwable t) {
                    msg = MessageFormat.format(rb.getString("AS-WEB-CORE-00456"), file);
                    log.log(Level.SEVERE, msg, t);
                }
                continue;
            }
            if (log.isLoggable(Level.INFO)) {
                log.log(Level.INFO, "AS-WEB-CORE-00457", file);
            }
            try {
                url = new URL("file", null, dir.getCanonicalPath());
                url = new URL("jar:" + url.toString() + "!/");
                ((Deployer)((Object)this.host)).install((String)contextPath, url);
            }
            catch (Throwable t) {
                String msg = MessageFormat.format(rb.getString("AS-WEB-CORE-00458"), file);
                log.log(Level.SEVERE, msg, t);
            }
        }
    }

    protected void deployDirectories(File appBase, String[] files) {
        for (int i = 0; i < files.length; ++i) {
            File dir;
            if (files[i].equalsIgnoreCase("META-INF") || files[i].equalsIgnoreCase("WEB-INF") || this.deployed.contains(files[i]) || !(dir = new File(appBase, files[i])).isDirectory()) continue;
            this.deployed.add(files[i]);
            File webInf = new File(dir, "/WEB-INF");
            if (!webInf.exists() || !webInf.isDirectory() || !webInf.canRead()) continue;
            Object contextPath = "/" + files[i];
            if (files[i].equals("ROOT")) {
                contextPath = "";
            }
            if (this.host.findChild((String)contextPath) != null) continue;
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "AS-WEB-CORE-00459", files[i]);
            }
            long t1 = System.currentTimeMillis();
            try {
                URL url = new URL("file", null, dir.getCanonicalPath());
                ((Deployer)((Object)this.host)).install((String)contextPath, url);
            }
            catch (Throwable t) {
                String msg = MessageFormat.format(rb.getString("AS-WEB-CORE-00460"), files[i]);
                log.log(Level.SEVERE, msg, t);
            }
            long t2 = System.currentTimeMillis();
            if (t2 - t1 <= 200L || !log.isLoggable(Level.FINE)) continue;
            log.log(Level.FINE, "Deployed {0} {1}", new Object[]{files[i], t2 - t1});
        }
    }

    private boolean validateContextPath(File appBase, String contextPath) {
        StringBuilder docBase;
        String canonicalDocBase = null;
        try {
            String canonicalAppBase = appBase.getCanonicalPath();
            docBase = new StringBuilder(canonicalAppBase);
            if (canonicalAppBase.endsWith(File.separator)) {
                docBase.append(contextPath.substring(1).replace('/', File.separatorChar));
            } else {
                docBase.append(contextPath.replace('/', File.separatorChar));
            }
            canonicalDocBase = new File(docBase.toString()).getCanonicalPath();
            if (canonicalDocBase.endsWith(File.separator)) {
                docBase.append(File.separator);
            }
        }
        catch (IOException ioe) {
            return false;
        }
        return canonicalDocBase.equals(docBase.toString());
    }

    protected void checkContextLastModified() {
        if (!(this.host instanceof Deployer)) {
            return;
        }
        Deployer deployer = (Deployer)((Object)this.host);
        String[] contextNames = deployer.findDeployedApps();
        for (int i = 0; i < contextNames.length; ++i) {
            String contextName = contextNames[i];
            Context context = deployer.findDeployedApp(contextName);
            if (!(context instanceof Lifecycle)) continue;
            try {
                DirContext resources = context.getResources();
                if (resources == null) continue;
                ResourceAttributes webXmlAttributes = (ResourceAttributes)resources.getAttributes("/WEB-INF/web.xml");
                ResourceAttributes webInfAttributes = (ResourceAttributes)resources.getAttributes("/WEB-INF");
                long newLastModified = webXmlAttributes.getLastModified();
                long webInfLastModified = webInfAttributes.getLastModified();
                Long lastModified = this.webXmlLastModified.get(contextName);
                if (lastModified == null) {
                    this.webXmlLastModified.put(contextName, newLastModified);
                } else if (lastModified != newLastModified) {
                    if (newLastModified > webInfLastModified + 5000L) {
                        this.webXmlLastModified.remove(contextName);
                        this.restartContext(context);
                    } else {
                        this.webXmlLastModified.put(contextName, newLastModified);
                    }
                }
            }
            catch (NamingException resources) {
                // empty catch block
            }
            Long lastModified = this.contextXmlLastModified.get(contextName);
            String configBase = this.configBase().getPath();
            String configFileName = context.getConfigFile();
            if (configFileName == null) continue;
            File configFile = new File(configFileName);
            if (!configFile.isAbsolute()) {
                configFile = new File(System.getProperty("catalina.base"), configFile.getPath());
            }
            long newLastModified = configFile.lastModified();
            if (lastModified == null) {
                this.contextXmlLastModified.put(contextName, newLastModified);
                continue;
            }
            if (lastModified == newLastModified) continue;
            this.contextXmlLastModified.remove(contextName);
            String fileName = configFileName;
            if (!fileName.startsWith(configBase)) continue;
            fileName = fileName.substring(configBase.length() + 1);
            try {
                this.deployed.remove(fileName);
                if (this.host.findChild(contextName) != null) {
                    ((Deployer)((Object)this.host)).remove(contextName);
                }
            }
            catch (Throwable t) {
                String msg = MessageFormat.format(rb.getString("AS-WEB-CORE-00461"), fileName);
                log.log(Level.SEVERE, msg, t);
            }
            this.deployApps();
        }
        if (this.isUnpackWARs()) {
            String[] files;
            File appBase = this.appBase();
            if (!appBase.exists() || !appBase.isDirectory()) {
                return;
            }
            for (String file : files = appBase.list()) {
                if (!file.endsWith(".war")) continue;
                File dir = new File(appBase, file);
                Long lastModified = this.warLastModified.get(file);
                long dirLastModified = dir.lastModified();
                if (lastModified == null) {
                    this.warLastModified.put(file, dir.lastModified());
                    continue;
                }
                if (dirLastModified <= lastModified) continue;
                String expandedDir = file;
                int period = expandedDir.lastIndexOf(46);
                if (period >= 0) {
                    expandedDir = expandedDir.substring(0, period);
                }
                File expanded = new File(appBase, expandedDir);
                Object contextPath = "/" + expandedDir;
                if (((String)contextPath).equals("/ROOT")) {
                    contextPath = "";
                }
                if (dirLastModified > expanded.lastModified()) {
                    try {
                        this.deployed.remove(file);
                        this.deployed.remove(expandedDir + ".xml");
                        if (this.host.findChild((String)contextPath) != null) {
                            ((Deployer)((Object)this.host)).remove((String)contextPath, false);
                            ExpandWar.deleteDir(expanded);
                        }
                    }
                    catch (Throwable t) {
                        String msg = MessageFormat.format(rb.getString("AS-WEB-CORE-00461"), file);
                        log.log(Level.SEVERE, msg, t);
                    }
                    this.deployApps();
                }
                if (this.host.findChild((String)contextPath) == null) continue;
                this.webXmlLastModified.remove(contextPath);
                this.warLastModified.put(file, dir.lastModified());
            }
        }
    }

    protected boolean restartContext(Context context) {
        String msg;
        boolean result = true;
        if (log.isLoggable(Level.INFO)) {
            log.log(Level.INFO, "AS-WEB-CORE-00462", context.getName());
        }
        try {
            ((Lifecycle)((Object)context)).stop();
        }
        catch (Exception ex) {
            msg = MessageFormat.format(rb.getString("AS-WEB-CORE-00463"), context.getName());
            log.log(Level.WARNING, msg, ex);
        }
        try {
            ((Lifecycle)((Object)context)).start();
        }
        catch (Exception e) {
            msg = MessageFormat.format(rb.getString("AS-WEB-CORE-00464"), context.getName());
            log.log(Level.WARNING, msg, e);
            result = false;
        }
        return result;
    }

    protected String expand(URL war) throws IOException {
        return ExpandWar.expand(this.host, war);
    }

    protected void expand(InputStream input, File docBase, String name) throws IOException {
        ExpandWar.expand(input, docBase, name);
    }

    protected void log(String message) {
        Logger logger = null;
        if (this.host != null) {
            logger = this.host.getLogger();
        }
        if (logger != null) {
            logger.log("HostConfig[" + this.host.getName() + "]: " + message);
        } else {
            log.info(message);
        }
    }

    protected void log(String message, Throwable throwable) {
        Logger logger = null;
        if (this.host != null) {
            logger = this.host.getLogger();
        }
        if (logger != null) {
            logger.log("HostConfig[" + this.host.getName() + "] " + message, throwable);
        } else {
            log.log(Level.SEVERE, message, throwable);
        }
    }

    public void start() {
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "AS-WEB-CORE-00465");
        }
        if (this.host.getDeployOnStartup()) {
            this.deployApps();
        } else {
            File configBase = this.configBase();
            if (configBase.exists() && configBase.isDirectory()) {
                String[] configFiles = configBase.list();
                this.deployDescriptors(configBase, configFiles);
            }
        }
    }

    public void stop() {
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "AS-WEB-CORE-00466");
        }
        this.undeployApps();
        this.appBase = null;
        this.configBase = null;
    }

    protected void undeployApps() {
        String[] contextPaths;
        if (!(this.host instanceof Deployer)) {
            return;
        }
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "AS-WEB-CORE-00467");
        }
        for (String contextPath : contextPaths = ((Deployer)((Object)this.host)).findDeployedApps()) {
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "AS-WEB-CORE-00468", contextPath);
            }
            try {
                ((Deployer)((Object)this.host)).remove(contextPath);
            }
            catch (Throwable t) {
                String msg = MessageFormat.format(rb.getString("AS-WEB-CORE-00469"), contextPath);
                log.log(Level.SEVERE, msg, t);
            }
        }
        this.webXmlLastModified.clear();
        this.deployed.clear();
    }

    protected void check() {
        if (this.host.getAutoDeploy()) {
            this.deployApps();
            this.checkContextLastModified();
        }
    }
}

