/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.webservices.monitoring;

import jakarta.servlet.http.HttpServletRequest;
import java.util.logging.Level;
import org.glassfish.webservices.SOAPMessageContext;
import org.glassfish.webservices.monitoring.EndpointImpl;
import org.glassfish.webservices.monitoring.EndpointType;
import org.glassfish.webservices.monitoring.HttpRequestInfoImpl;
import org.glassfish.webservices.monitoring.MessageListener;
import org.glassfish.webservices.monitoring.MessageTrace;
import org.glassfish.webservices.monitoring.MessageTraceImpl;
import org.glassfish.webservices.monitoring.WebServiceEngineImpl;

public class JAXWSEndpointImpl
extends EndpointImpl {
    JAXWSEndpointImpl(String endpointSelector, EndpointType type) {
        super(endpointSelector, type);
    }

    public boolean processRequest(SOAPMessageContext messageContext) throws Exception {
        boolean status = true;
        WebServiceEngineImpl wsMonitor = WebServiceEngineImpl.getInstance();
        try {
            if (!this.listeners.isEmpty() || wsMonitor.hasGlobalMessageListener()) {
                String messageID = (String)messageContext.get("MONITORING_MESSAGE_ID");
                if (messageID != null) {
                    HttpServletRequest httpReq = (HttpServletRequest)messageContext.get("jakarta.xml.ws.servlet.request");
                    wsMonitor.processRequest(messageID, messageContext, new HttpRequestInfoImpl(httpReq));
                }
                if (!this.listeners.isEmpty()) {
                    MessageTraceImpl requestTrace = new MessageTraceImpl();
                    requestTrace.setEndpoint(this);
                    requestTrace.setMessageContext(messageContext);
                    HttpServletRequest httpReq = (HttpServletRequest)messageContext.get("jakarta.xml.ws.servlet.request");
                    requestTrace.setTransportInfo(new HttpRequestInfoImpl(httpReq));
                    messageContext.put("MONITORING_REQUEST_MESSAGE_TRACE", requestTrace);
                }
            }
        }
        catch (Exception e) {
            WebServiceEngineImpl.sLogger.log(Level.WARNING, "AS-WSJSR109IMPL-00043", e.getMessage());
            throw e;
        }
        return status;
    }

    public void processResponse(SOAPMessageContext messageContext) throws Exception {
        WebServiceEngineImpl wsEngine = WebServiceEngineImpl.getInstance();
        try {
            if (wsEngine.hasGlobalMessageListener() || !this.listeners.isEmpty()) {
                String messageID = (String)messageContext.get("MONITORING_MESSAGE_ID");
                if (messageID != null) {
                    wsEngine.processResponse(messageID, messageContext);
                }
                if (!this.listeners.isEmpty()) {
                    MessageTraceImpl responseTrace = new MessageTraceImpl();
                    responseTrace.setEndpoint(this);
                    responseTrace.setMessageContext(messageContext);
                    for (MessageListener listener : this.listeners) {
                        listener.invocationProcessed((MessageTrace)messageContext.get("MONITORING_REQUEST_MESSAGE_TRACE"), responseTrace);
                    }
                }
            }
        }
        catch (Exception e) {
            WebServiceEngineImpl.sLogger.log(Level.WARNING, "AS-WSJSR109IMPL-00044", e.getMessage());
            throw e;
        }
    }
}

