/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.nucleus.microprofile.config.source;

import com.sun.enterprise.security.store.DomainScopedPasswordAliasStore;
import fish.payara.nucleus.microprofile.config.source.PayaraConfigSource;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.config.support.TranslatedConfigView;
import org.glassfish.internal.api.Globals;

public class PasswordAliasConfigSource
extends PayaraConfigSource {
    private final DomainScopedPasswordAliasStore store = Globals.getDefaultHabitat().getService(DomainScopedPasswordAliasStore.class, new Annotation[0]);

    public int getOrdinal() {
        return Integer.parseInt(this.configService.getMPConfig().getPasswordOrdinality());
    }

    public Map<String, String> getProperties() {
        HashMap<String, String> properties = new HashMap<String, String>();
        this.store.keys().forEachRemaining(key -> properties.put((String)key, new String(this.store.get(key))));
        return properties;
    }

    @Override
    public Set<String> getPropertyNames() {
        HashSet<String> propertyNames = new HashSet<String>();
        this.store.keys().forEachRemaining(propertyNames::add);
        return propertyNames;
    }

    public String getValue(String name) {
        Objects.requireNonNull(name, "Name perameter cannot be null");
        String value = null;
        if (this.store.containsKey(name)) {
            value = new String(this.store.get(name));
        } else if (TranslatedConfigView.getAlias((String)name) != null) {
            try {
                value = TranslatedConfigView.getRealPasswordFromAlias((String)name);
            }
            catch (IllegalArgumentException iae) {
                Logger.getLogger(PasswordAliasConfigSource.class.getName()).log(Level.FINEST, iae.getMessage());
            }
            catch (IOException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException | CertificateException exception) {
                Logger.getLogger(PasswordAliasConfigSource.class.getName()).log(Level.FINE, "Exception caught reading from Password Alias store", exception);
            }
        }
        return value;
    }

    public String getName() {
        return "Password Alias";
    }
}

