/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.appserver.monitoring.rest.service.adapter;

import com.sun.enterprise.config.serverbeans.Config;
import fish.payara.appserver.monitoring.rest.service.configuration.RestMonitoringConfiguration;
import jakarta.inject.Inject;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;
import org.glassfish.grizzly.config.dom.NetworkListener;
import org.glassfish.grizzly.config.dom.ThreadPool;
import org.glassfish.hk2.api.ServiceLocator;

public class RestMonitoringEndpointDecider {
    private String contextRoot;
    private int port;
    private InetAddress address;
    private int maxThreadPoolSize = 5;
    private Config config;
    private static final Logger logger = Logger.getLogger(RestMonitoringEndpointDecider.class.getName());
    private List<String> hosts;
    private RestMonitoringConfiguration restMonitoringServiceConfiguration;
    private static final String DEFAULT_CONTEXT_ROOT = "/rest-monitoring";
    public static final int DEFAULT_ADMIN_PORT = 4848;
    @Inject
    ServiceLocator habitat;

    public RestMonitoringEndpointDecider(Config config, RestMonitoringConfiguration restMonitoringServiceConfiguration) {
        if (config == null || logger == null) {
            throw new IllegalArgumentException("config or logger can't be null");
        }
        this.config = config;
        this.restMonitoringServiceConfiguration = restMonitoringServiceConfiguration;
        this.setValues();
    }

    public int getListenPort() {
        return this.port;
    }

    public InetAddress getListenAddress() {
        return this.address;
    }

    public int getMaxThreadPoolSize() {
        return this.maxThreadPoolSize;
    }

    public String getContextRoot() {
        return this.contextRoot;
    }

    private void setValues() {
        NetworkListener networkListener = this.config.getAdminListener();
        ThreadPool threadPool = networkListener.findThreadPool();
        if (threadPool != null) {
            try {
                this.maxThreadPoolSize = Integer.parseInt(threadPool.getMaxThreadPoolSize());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        String defaultVirtualServer = networkListener.findHttpProtocol().getHttp().getDefaultVirtualServer();
        this.hosts = Collections.unmodifiableList(Arrays.asList(defaultVirtualServer));
        try {
            this.address = InetAddress.getByName(networkListener.getAddress());
        }
        catch (UnknownHostException e) {
            throw new IllegalStateException(e);
        }
        if ("admin-listener".equals(networkListener.getName())) {
            this.contextRoot = this.restMonitoringServiceConfiguration == null ? DEFAULT_CONTEXT_ROOT : this.restMonitoringServiceConfiguration.getContextRoot();
            try {
                this.port = Integer.parseInt(networkListener.getPort());
            }
            catch (NumberFormatException ne) {
                this.port = 4848;
            }
        } else {
            try {
                this.port = Integer.parseInt(networkListener.getPort());
            }
            catch (NumberFormatException ne) {
                this.port = 4848;
            }
            this.contextRoot = this.restMonitoringServiceConfiguration == null ? DEFAULT_CONTEXT_ROOT : this.restMonitoringServiceConfiguration.getContextRoot();
        }
    }

    public List<String> getHosts() {
        return this.hosts;
    }
}

